/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.gmavenplus.model.internal.Version;
import org.codehaus.gmavenplus.mojo.AbstractToolsMojo;
import org.codehaus.gmavenplus.util.FileUtils;
import org.codehaus.gmavenplus.util.NoExitSecurityManager;
import org.codehaus.gmavenplus.util.ReflectionUtils;

@Mojo(name="execute", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ExecuteMojo
extends AbstractToolsMojo {
    protected static final Version GROOVY_1_7_0 = new Version(1, 7, 0);
    @Parameter(required=true)
    protected String[] scripts;
    @Parameter(defaultValue="false")
    protected boolean continueExecuting;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(defaultValue="false")
    protected boolean skipScriptExecution;

    public void execute() throws MojoExecutionException {
        this.doExecute();
    }

    protected synchronized void doExecute() throws MojoExecutionException {
        if (this.skipScriptExecution) {
            this.getLog().info((CharSequence)"Skipping script execution because ${skipScriptExecution} was set to true.");
            return;
        }
        if (this.scripts == null || this.scripts.length == 0) {
            this.getLog().info((CharSequence)"No scripts specified for execution. Skipping.");
            return;
        }
        try {
            this.setupClassWrangler(this.project.getTestClasspathElements(), this.includeClasspath);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to add project test dependencies to classpath.", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Test dependencies weren't resolved.", (Exception)((Object)e));
        }
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Project test classpath:\n" + this.project.getTestClasspathElements()));
            }
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().debug((CharSequence)"Unable to log project test classpath");
        }
        if (this.groovyVersionSupportsAction()) {
            SecurityManager sm = System.getSecurityManager();
            try {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(new NoExitSecurityManager());
                }
                Class<?> groovyShellClass = this.classWrangler.getClass("groovy.lang.GroovyShell");
                Object shell = this.setupShell(groovyShellClass);
                this.executeScripts(groovyShellClass, shell);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Unable to get a Groovy class from classpath (" + e.getMessage() + "). Do you have Groovy as a compile dependency in your project or the plugin?", (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
            }
            finally {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(sm);
                }
            }
        } else {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support script execution. The minimum version of Groovy required is " + this.minGroovyVersion + ". Skipping script execution."));
        }
    }

    protected Object setupShell(Class<?> groovyShellClass) throws InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Object shell;
        if (this.sourceEncoding != null) {
            Class<?> compilerConfigurationClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilerConfiguration");
            Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, this.sourceEncoding);
            shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, ClassLoader.class, compilerConfigurationClass), this.classWrangler.getClassLoader(), compilerConfiguration);
        } else {
            shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, ClassLoader.class), this.classWrangler.getClassLoader());
        }
        this.initializeProperties();
        Method setProperty = ReflectionUtils.findMethod(groovyShellClass, "setProperty", String.class, Object.class);
        if (this.bindPropertiesToSeparateVariables) {
            for (Object k : this.properties.keySet()) {
                ReflectionUtils.invokeMethod(setProperty, shell, k, this.properties.get(k));
            }
        } else {
            ReflectionUtils.invokeMethod(setProperty, shell, "properties", this.properties);
        }
        return shell;
    }

    protected void executeScripts(Class<?> groovyShellClass, Object shell) throws InvocationTargetException, IllegalAccessException, MojoExecutionException {
        int scriptNum = 1;
        for (String script : this.scripts) {
            block8: {
                try {
                    try {
                        this.executeScriptFromUrl(groovyShellClass, shell, script);
                    }
                    catch (MalformedURLException e) {
                        File scriptFile = new File(script);
                        if (scriptFile.isFile()) {
                            if (this.getLog().isInfoEnabled()) {
                                this.getLog().info((CharSequence)("Running Groovy script from " + scriptFile.getCanonicalPath() + "."));
                            }
                            Method evaluateFile = ReflectionUtils.findMethod(groovyShellClass, "evaluate", File.class);
                            ReflectionUtils.invokeMethod(evaluateFile, shell, scriptFile);
                            break block8;
                        }
                        Method evaluateString = ReflectionUtils.findMethod(groovyShellClass, "evaluate", String.class);
                        ReflectionUtils.invokeMethod(evaluateString, shell, script);
                    }
                }
                catch (IOException ioe) {
                    if (this.continueExecuting) {
                        this.getLog().error((CharSequence)("An Exception occurred while executing script " + scriptNum + ". Continuing to execute remaining scripts."), (Throwable)ioe);
                    }
                    throw new MojoExecutionException("An Exception occurred while executing script " + scriptNum + ".", (Exception)ioe);
                }
            }
            ++scriptNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeScriptFromUrl(Class<?> groovyShellClass, Object shell, String script) throws IOException, InvocationTargetException, IllegalAccessException {
        block7: {
            URL url;
            block6: {
                url = new URL(script);
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("Running Groovy script from " + url + "."));
                }
                if (!this.groovyAtLeast(GROOVY_1_7_0)) break block6;
                Method evaluateUrlWithReader = ReflectionUtils.findMethod(groovyShellClass, "evaluate", Reader.class);
                BufferedReader reader = null;
                try {
                    reader = this.sourceEncoding != null ? new BufferedReader(new InputStreamReader(url.openStream(), this.sourceEncoding)) : new BufferedReader(new InputStreamReader(url.openStream()));
                    ReflectionUtils.invokeMethod(evaluateUrlWithReader, shell, reader);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(reader);
                    throw throwable;
                }
                FileUtils.closeQuietly(reader);
                break block7;
            }
            Method evaluateUrlWithStream = ReflectionUtils.findMethod(groovyShellClass, "evaluate", InputStream.class);
            InputStream inputStream = null;
            try {
                if (this.sourceEncoding != null) {
                    this.getLog().warn((CharSequence)"Source encoding does not apply to Groovy versions previous to 1.7.0, ignoring.");
                }
                inputStream = url.openStream();
                ReflectionUtils.invokeMethod(evaluateUrlWithStream, shell, inputStream);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(inputStream);
                throw throwable;
            }
            FileUtils.closeQuietly(inputStream);
        }
    }
}

