/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.File;
import java.net.URI;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.file.api.ServiceAdapter;
import org.fabric3.binding.file.common.Strategy;
import org.fabric3.binding.file.provision.FileBindingSourceDefinition;
import org.fabric3.binding.file.runtime.DataHandlerServiceAdapter;
import org.fabric3.binding.file.runtime.DefaultServiceAdapter;
import org.fabric3.binding.file.runtime.ServiceAdaptorWrapper;
import org.fabric3.binding.file.runtime.receiver.PassThroughInterceptor;
import org.fabric3.binding.file.runtime.receiver.ReceiverConfiguration;
import org.fabric3.binding.file.runtime.receiver.ReceiverManager;
import org.fabric3.binding.file.runtime.receiver.ReceiverMonitor;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.SourceWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class FileSourceWireAttacher
implements SourceWireAttacher<FileBindingSourceDefinition> {
    private static final ServiceAdapter ADAPTER = new DefaultServiceAdapter();
    private static final ServiceAdapter JAF_ADAPTER = new DataHandlerServiceAdapter();
    private ReceiverManager receiverManager;
    private ClassLoaderRegistry registry;
    private ComponentManager manager;
    private ReceiverMonitor monitor;
    private File baseDir;

    public FileSourceWireAttacher(@Reference ReceiverManager receiverManager, @Reference ClassLoaderRegistry registry, @Reference ComponentManager manager, @Reference HostInfo hostInfo, @Monitor ReceiverMonitor monitor) {
        this.receiverManager = receiverManager;
        this.registry = registry;
        this.manager = manager;
        this.monitor = monitor;
        this.baseDir = new File(hostInfo.getDataDir(), "inbox");
    }

    public void attach(FileBindingSourceDefinition source, PhysicalTargetDefinition target, Wire wire) throws WiringException {
        String id = source.getUri().toString();
        File location = this.getLocation(source);
        File errorLocation = this.getErrorLocation(source);
        File archiveLocation = this.getArchiveLocation(source);
        String pattern = source.getPattern();
        Strategy strategy = source.getStrategy();
        PassThroughInterceptor interceptor = new PassThroughInterceptor();
        for (InvocationChain chain : wire.getInvocationChains()) {
            chain.addInterceptor((Interceptor)interceptor);
        }
        ServiceAdapter adapter = this.getAdaptor(source);
        long delay = source.getDelay();
        ReceiverConfiguration configuration = new ReceiverConfiguration(id, location, pattern, strategy, errorLocation, archiveLocation, interceptor, adapter, delay, this.monitor);
        this.receiverManager.create(configuration);
    }

    public void detach(FileBindingSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        String id = source.getUri().toString();
        this.receiverManager.remove(id);
    }

    public void attachObjectFactory(FileBindingSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalTargetDefinition target) {
        throw new UnsupportedOperationException();
    }

    public void detachObjectFactory(FileBindingSourceDefinition source, PhysicalTargetDefinition target) {
        throw new UnsupportedOperationException();
    }

    private File getLocation(FileBindingSourceDefinition source) {
        String location = source.getLocation();
        return this.resolve(location);
    }

    private File getArchiveLocation(FileBindingSourceDefinition source) {
        File archiveLocation = null;
        String archiveLocationStr = source.getArchiveLocation();
        if (archiveLocationStr != null) {
            archiveLocation = this.resolve(archiveLocationStr);
        }
        return archiveLocation;
    }

    private File getErrorLocation(FileBindingSourceDefinition source) {
        File errorLocation = null;
        String errorLocationStr = source.getErrorLocation();
        if (errorLocationStr != null) {
            errorLocation = this.resolve(errorLocationStr);
        }
        return errorLocation;
    }

    private File resolve(String location) {
        File file = new File(location);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.baseDir, location);
    }

    private ServiceAdapter getAdaptor(FileBindingSourceDefinition source) throws WiringException {
        String adapterClass = source.getAdapterClass();
        if (adapterClass == null) {
            URI adapterUri = source.getAdapterUri();
            if (adapterUri == null) {
                return source.isDataHandler() ? JAF_ADAPTER : ADAPTER;
            }
            Component component = this.manager.getComponent(adapterUri);
            if (component == null) {
                throw new WiringException("Binding adaptor component not found: " + adapterUri);
            }
            if (!(component instanceof AtomicComponent)) {
                throw new WiringException("Adaptor component must implement " + AtomicComponent.class.getName() + ": " + adapterUri);
            }
            return new ServiceAdaptorWrapper((AtomicComponent)component);
        }
        URI uri = source.getClassLoaderId();
        ClassLoader loader = this.registry.getClassLoader(uri);
        if (loader == null) {
            throw new WiringException("ClassLoader not found: " + uri);
        }
        try {
            return (ServiceAdapter)loader.loadClass(adapterClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new WiringException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WiringException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WiringException((Throwable)e);
        }
    }
}

