/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.fabric3.binding.file.api.InvalidDataException;
import org.fabric3.binding.file.runtime.AbstractFileServiceAdapter;
import org.fabric3.host.util.IOHelper;

public class DefaultServiceAdapter
extends AbstractFileServiceAdapter {
    public Object[] beforeInvoke(File file) throws InvalidDataException {
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
            return new Object[]{new BufferedInputStream(fileStream)};
        }
        catch (FileNotFoundException e) {
            IOHelper.closeQuietly(fileStream);
            throw new InvalidDataException(e);
        }
    }

    public void afterInvoke(File file, Object[] payload) {
        if (payload.length != 1) {
            throw new AssertionError((Object)("Invalid payload length: " + payload.length));
        }
        if (!(payload[0] instanceof Closeable)) {
            throw new AssertionError((Object)("Invalid payload type: " + payload[0]));
        }
        IOHelper.closeQuietly((Closeable)((Closeable)payload[0]));
    }
}

