/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.fabric3.binding.file.api.InvalidDataException;
import org.fabric3.binding.file.runtime.AbstractFileServiceAdapter;
import org.fabric3.host.util.IOHelper;

public class DataHandlerServiceAdapter
extends AbstractFileServiceAdapter {
    public Object[] beforeInvoke(File file) throws InvalidDataException {
        try {
            DataHandler dataHandler = new DataHandler((DataSource)new CloseableDataSource(file));
            return new Object[]{dataHandler};
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
    }

    public void afterInvoke(File file, Object[] payload) {
        if (payload.length != 1) {
            throw new AssertionError((Object)("Invalid payload length: " + payload.length));
        }
        if (!(payload[0] instanceof DataHandler)) {
            throw new AssertionError((Object)("Invalid payload type: " + payload[0]));
        }
        DataHandler dataHandler = (DataHandler)payload[0];
        try {
            IOHelper.closeQuietly((Closeable)dataHandler.getInputStream());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private class CloseableDataSource
    implements DataSource {
        private InputStream inputStream;

        private CloseableDataSource(File file) throws FileNotFoundException {
            this.inputStream = new FileInputStream(file);
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this.getClass().getName();
        }
    }
}

