/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.file.generator;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.activation.DataHandler;
import org.fabric3.binding.file.common.Strategy;
import org.fabric3.binding.file.generator.InvalidContractException;
import org.fabric3.binding.file.model.FileBindingDefinition;
import org.fabric3.binding.file.provision.FileBindingSourceDefinition;
import org.fabric3.binding.file.provision.FileBindingTargetDefinition;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.generator.BindingGenerator;
import org.fabric3.spi.generator.EffectivePolicy;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.model.type.java.JavaType;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class FileBindingGenerator
implements BindingGenerator<FileBindingDefinition> {
    private static final String REGEX_ALL = ".*";
    private HostInfo info;
    private long defaultDelay = 2000L;

    @Property(required=false)
    public void setDelay(long delay) {
        this.defaultDelay = delay;
    }

    public FileBindingGenerator(@Reference HostInfo info) {
        this.info = info;
    }

    public FileBindingSourceDefinition generateSource(LogicalBinding<FileBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        this.validateServiceContract(contract);
        boolean dataHandler = this.isDataHandler(contract);
        FileBindingDefinition definition = (FileBindingDefinition)binding.getDefinition();
        String pattern = definition.getPattern();
        if (pattern == null) {
            pattern = REGEX_ALL;
        }
        String location = definition.getLocation();
        Strategy strategy = definition.getStrategy();
        String archiveLocation = definition.getArchiveLocation();
        URI uri = ((Bindable)binding.getParent()).getUri();
        String errorLocation = definition.getErrorLocation();
        if (errorLocation == null) {
            throw new GenerationException("Error location must be specified on the file binding configuration for " + uri);
        }
        String adapterClass = definition.getAdapterClass();
        URI adaptorUri = this.getAdaptorUri(definition);
        long delay = definition.getDelay();
        if (delay == -1L) {
            delay = this.defaultDelay;
        }
        return new FileBindingSourceDefinition(uri, pattern, location, strategy, archiveLocation, errorLocation, adapterClass, adaptorUri, delay, dataHandler);
    }

    public FileBindingTargetDefinition generateTarget(LogicalBinding<FileBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        this.validateReferenceContract(contract);
        FileBindingDefinition definition = (FileBindingDefinition)binding.getDefinition();
        String location = definition.getLocation();
        String adapterClass = definition.getAdapterClass();
        URI adaptorUri = this.getAdaptorUri(definition);
        return new FileBindingTargetDefinition(location, adapterClass, adaptorUri);
    }

    public PhysicalTargetDefinition generateServiceBindingTarget(LogicalBinding<FileBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        throw new UnsupportedOperationException();
    }

    private void validateReferenceContract(ServiceContract contract) throws InvalidContractException {
        if (contract.getOperations().size() != 1) {
            throw new InvalidContractException("File transfer binding contracts must contain one operation of the form openStream(String id)");
        }
        Operation operation = (Operation)contract.getOperations().get(0);
        DataType dataType = (DataType)operation.getInputTypes().get(0);
        if (!(dataType instanceof JavaType)) {
            throw new InvalidContractException("Unsupported parameter type on binding contract: " + dataType);
        }
        JavaType javaType = (JavaType)dataType;
        if (!String.class.isAssignableFrom(javaType.getPhysical())) {
            throw new InvalidContractException("Parameter type on binding contract must be a string: " + dataType);
        }
        DataType outputType = operation.getOutputType();
        if (!(outputType instanceof JavaType)) {
            throw new InvalidContractException("Unsupported output type on binding contract: " + outputType);
        }
        JavaType javaOutputType = (JavaType)outputType;
        if (!OutputStream.class.isAssignableFrom(javaOutputType.getPhysical())) {
            throw new InvalidContractException("Output type on binding contract must be a java.io.OutputStream: " + dataType);
        }
    }

    private void validateServiceContract(ServiceContract contract) throws InvalidContractException {
        if (contract.getOperations().size() > 1 || contract.getOperations().isEmpty()) {
            throw new InvalidContractException("File transfer binding contracts must contain one operation");
        }
    }

    private boolean isDataHandler(ServiceContract contract) {
        for (Operation operation : contract.getOperations()) {
            for (DataType dataType : operation.getInputTypes()) {
                if (!DataHandler.class.isAssignableFrom(dataType.getPhysical())) continue;
                return true;
            }
        }
        return false;
    }

    private URI getAdaptorUri(FileBindingDefinition definition) throws GenerationException {
        String uri = definition.getAdapterUri();
        if (uri == null) {
            return null;
        }
        try {
            return new URI(this.info.getDomain().toString() + "/" + uri);
        }
        catch (URISyntaxException e) {
            throw new GenerationException((Throwable)e);
        }
    }
}

