/*
 * Decompiled with CFR 0.152.
 */
package org.castor.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.ConfigurationException;

public abstract class Configuration {
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private final ClassLoader _applicationClassLoader;
    private final ClassLoader _domainClassLoader;
    private final Configuration _parent;
    private final Map _map = new HashMap();

    protected Configuration() {
        this(null, null);
    }

    protected Configuration(ClassLoader app, ClassLoader domain) {
        this._applicationClassLoader = app != null ? app : this.getClass().getClassLoader();
        this._domainClassLoader = domain != null ? domain : this.getClass().getClassLoader();
        this._parent = null;
    }

    protected Configuration(Configuration parent) {
        this._applicationClassLoader = parent.getApplicationClassLoader();
        this._domainClassLoader = parent.getDomainClassLoader();
        this._parent = parent;
    }

    public final ClassLoader getApplicationClassLoader() {
        return this._applicationClassLoader;
    }

    public final ClassLoader getDomainClassLoader() {
        return this._domainClassLoader;
    }

    protected void loadDefaultProperties(String path, String filename) {
        Properties properties = new Properties();
        boolean inCastorJar = this.loadFromClassPath(properties, path + filename);
        boolean inJavaLibDir = this.loadFromJavaHome(properties, filename);
        if (!inCastorJar && !inJavaLibDir) {
            throw new ConfigurationException("Failed to load configuration: " + filename);
        }
        this._map.putAll(properties);
    }

    protected void loadUserProperties(String filename) {
        Properties properties = new Properties();
        boolean onClasspathRoot = this.loadFromClassPath(properties, "/" + filename);
        if (!onClasspathRoot) {
            this.loadFromWorkingDirectory(properties, filename);
        }
        this._map.putAll(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFromClassPath(Properties properties, String filename) {
        InputStream classPathStream = null;
        try {
            URL url = this.getClass().getResource(filename);
            if (url != null) {
                classPathStream = url.openStream();
                properties.load(classPathStream);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Configuration loaded from classpath: " + filename));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to load configuration from classpath: " + filename), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (classPathStream != null) {
                try {
                    classPathStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to close configuration from classpath: " + filename));
                }
            }
        }
    }

    private boolean loadFromJavaHome(Properties properties, String filename) {
        try {
            String javaHome = System.getProperty("java.home");
            if (javaHome == null) {
                return false;
            }
            return this.loadFromFile(properties, new File(new File(javaHome, "lib"), filename));
        }
        catch (SecurityException ex) {
            LOG.warn((Object)"Security policy prevented access to system property 'java.home'.", (Throwable)ex);
            return false;
        }
    }

    private boolean loadFromWorkingDirectory(Properties properties, String filename) {
        return this.loadFromFile(properties, new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFromFile(Properties properties, File file) {
        InputStream fileStream = null;
        try {
            if (file.exists() && file.canRead()) {
                fileStream = new FileInputStream(file);
                properties.load(fileStream);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Configuration file loaded: " + file));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SecurityException ex) {
            LOG.warn((Object)("Security policy prevented access to configuration file: " + file), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to load configuration file: " + file), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to close configuration file: " + file));
                }
            }
        }
    }

    public final synchronized Object put(String key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this._map.put(key, value);
    }

    public final synchronized Object remove(String key) {
        return this._map.remove(key);
    }

    protected synchronized Object get(String key) {
        Object value = this._map.get(key);
        if (value == null && this._parent != null) {
            value = this._parent.get(key);
        }
        return value;
    }

    public final Boolean getBoolean(String key) {
        Object objectValue = this.get(key);
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Boolean) {
            return (Boolean)objectValue;
        }
        if (objectValue instanceof String) {
            String stringValue = (String)objectValue;
            if ("true".equalsIgnoreCase(stringValue)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(stringValue)) {
                return Boolean.FALSE;
            }
        }
        Object[] args = new Object[]{key, objectValue};
        String msg = "Configuration value can not be converted to boolean: {0}={1}";
        throw new ConfigurationException(MessageFormat.format(msg, args));
    }

    public final boolean getBoolean(String key, boolean defaultValue) {
        Object objectValue = this.get(key);
        if (objectValue instanceof Boolean) {
            return (Boolean)objectValue;
        }
        if (objectValue instanceof String) {
            String stringValue = (String)objectValue;
            if ("true".equalsIgnoreCase(stringValue)) {
                return true;
            }
            if ("false".equalsIgnoreCase(stringValue)) {
                return false;
            }
        }
        return defaultValue;
    }

    public final Integer getInteger(String key) {
        Object objectValue = this.get(key);
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Integer) {
            return (Integer)objectValue;
        }
        if (objectValue instanceof String) {
            try {
                return Integer.valueOf((String)objectValue);
            }
            catch (NumberFormatException ex) {
                Object[] args = new Object[]{key, objectValue};
                String msg = "Configuration value can not be converted to int: {0}={1}";
                throw new ConfigurationException(MessageFormat.format(msg, args), ex);
            }
        }
        Object[] args = new Object[]{key, objectValue};
        String msg = "Configuration value can not be converted to int: {0}={1}";
        throw new ConfigurationException(MessageFormat.format(msg, args));
    }

    public final int getInteger(String key, int defaultValue) {
        Object objectValue = this.get(key);
        if (objectValue instanceof Integer) {
            return (Integer)objectValue;
        }
        if (objectValue instanceof String) {
            String stringValue = (String)objectValue;
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public final String getString(String key) {
        Object objectValue = this.get(key);
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof String) {
            return (String)objectValue;
        }
        Object[] args = new Object[]{key, objectValue};
        String msg = "Configuration value is not a string: {0}={1}";
        throw new ConfigurationException(MessageFormat.format(msg, args));
    }

    public final String getString(String key, String defaultValue) {
        Object objectValue = this.get(key);
        if (objectValue instanceof String && !"".equals(objectValue)) {
            return (String)objectValue;
        }
        return defaultValue;
    }

    public final String[] getStringArray(String key) {
        Object objectValue = this.get(key);
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof String[]) {
            return (String[])objectValue;
        }
        if (objectValue instanceof String) {
            return ((String)objectValue).split(",");
        }
        Object[] args = new Object[]{key, objectValue};
        String msg = "Configuration value is not a String[]: {0}={1}";
        throw new ConfigurationException(MessageFormat.format(msg, args));
    }

    public final Class getClass(String key, ClassLoader loader) {
        Object objectValue = this.get(key);
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Class) {
            return (Class)objectValue;
        }
        if (objectValue instanceof String) {
            String classname = (String)objectValue;
            try {
                return loader.loadClass(classname);
            }
            catch (ClassNotFoundException ex) {
                Object[] args = new Object[]{key, classname};
                String msg = "Could not find class of configuration value: {0}={1}";
                throw new ConfigurationException(MessageFormat.format(msg, args), ex);
            }
        }
        Object[] args = new Object[]{key, objectValue};
        String msg = "Configuration value is not a Class: {0}={1}";
        throw new ConfigurationException(MessageFormat.format(msg, args));
    }

    public final Class[] getClassArray(String key, ClassLoader loader) {
        Object objectValue = this.get(key);
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Class[]) {
            return (Class[])objectValue;
        }
        if (objectValue instanceof String) {
            String[] classnames = ((String)objectValue).split(",");
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                try {
                    classes[i] = loader.loadClass(classnames[i]);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    Object[] args = new Object[]{key, new Integer(i), classnames[i]};
                    String msg = "Could not find class of configuration value: {0}[{1}]={2}";
                    throw new ConfigurationException(MessageFormat.format(msg, args), ex);
                }
            }
            return classes;
        }
        Object[] args = new Object[]{key, objectValue};
        String msg = "Configuration value is not a Class[]: {0}={1}";
        throw new ConfigurationException(MessageFormat.format(msg, args));
    }

    public final Object getObject(String key) {
        return this.get(key);
    }

    public final Object[] getObjectArray(String key, ClassLoader loader) {
        Object objectValue = this.get(key);
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Object[]) {
            return (Object[])objectValue;
        }
        if (objectValue instanceof String) {
            ArrayList objects = new ArrayList();
            String[] classnames = ((String)objectValue).split(",");
            for (int i = 0; i < classnames.length; ++i) {
                String classname = classnames[i];
                try {
                    if (classname == null || "".equals(classname.trim())) continue;
                    classname = classname.trim();
                    objects.add(loader.loadClass(classname).newInstance());
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    Object[] args = new Object[]{key, new Integer(i), classname};
                    String msg = "Could not find configured class: {0}[{1}]={2}";
                    throw new ConfigurationException(MessageFormat.format(msg, args), ex);
                }
                catch (IllegalAccessException ex) {
                    Object[] args = new Object[]{key, new Integer(i), classname};
                    String msg = "Could not instantiate configured class: {0}[{1}]={2}";
                    throw new ConfigurationException(MessageFormat.format(msg, args), ex);
                }
                catch (InstantiationException ex) {
                    Object[] args = new Object[]{key, new Integer(i), classname};
                    String msg = "Could not instantiate configured class: {0}[{1}]={2}";
                    throw new ConfigurationException(MessageFormat.format(msg, args), ex);
                }
                catch (ExceptionInInitializerError ex) {
                    Object[] args = new Object[]{key, new Integer(i), classname};
                    String msg = "Could not instantiate configured class: {0}[{1}]={2}";
                    throw new ConfigurationException(MessageFormat.format(msg, args), ex);
                }
                catch (SecurityException ex) {
                    Object[] args = new Object[]{key, new Integer(i), classname};
                    String msg = "Could not instantiate configured class: {0}[{1}]={2}";
                    throw new ConfigurationException(MessageFormat.format(msg, args), ex);
                }
            }
            return objects.toArray();
        }
        Object[] args = new Object[]{key, objectValue};
        String msg = "Configuration value is not an Object[]: {0}={1}";
        throw new ConfigurationException(MessageFormat.format(msg, args));
    }
}

