/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.FacetList;

class FacetListEnumerator
implements Enumeration<Facet> {
    private int currentIdx = 0;
    private FacetList facets = null;
    private FacetListEnumerator inherited = null;
    private String mask = null;

    FacetListEnumerator(FacetList facets) {
        this.facets = facets;
    }

    FacetListEnumerator(FacetList facets, FacetListEnumerator inheritedFacets) {
        this.facets = facets;
        this.inherited = inheritedFacets;
    }

    void setMask(String name) {
        this.mask = name;
        if (this.inherited != null) {
            this.inherited.setMask(name);
        }
    }

    @Override
    public boolean hasMoreElements() {
        if (this.inherited != null && this.inherited.hasMoreElements()) {
            return true;
        }
        if (this.facets == null) {
            return false;
        }
        if (this.mask == null) {
            return this.currentIdx < this.facets.size();
        }
        while (this.currentIdx < this.facets.size()) {
            Facet facet = this.facets.get(this.currentIdx);
            if (this.mask.equals(facet.getName())) {
                return true;
            }
            ++this.currentIdx;
        }
        return false;
    }

    @Override
    public Facet nextElement() {
        if (this.inherited != null && this.inherited.hasMoreElements()) {
            return this.inherited.nextElement();
        }
        if (this.facets == null) {
            return null;
        }
        if (this.mask == null) {
            if (this.currentIdx < this.facets.size()) {
                return this.facets.get(this.currentIdx++);
            }
        } else {
            while (this.currentIdx < this.facets.size()) {
                Facet facet = this.facets.get(this.currentIdx);
                if (this.mask.equals(facet.getName())) {
                    ++this.currentIdx;
                    return facet;
                }
                ++this.currentIdx;
            }
        }
        return null;
    }
}

