/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.net.URIException;
import org.exolab.castor.net.URILocation;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaLocation;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class IncludeUnmarshaller
extends ComponentReader {
    public IncludeUnmarshaller(SchemaContext schemaContext, Schema schema, AttributeSet atts, URIResolver uriResolver, Locator locator, SchemaUnmarshallerState state) throws XMLException {
        super(schemaContext);
        this.setURIResolver(uriResolver);
        URILocation uri = null;
        String include = atts.getValue("schemaLocation");
        if (include == null) {
            throw new SchemaException("'schemaLocation' attribute missing on 'include'");
        }
        if (include.indexOf("\\") != -1) {
            String err = include + " is not a valid URI as defined by IETF RFC 2396.";
            err = err + "The URI must not contain '\\'.";
            throw new SchemaException(err);
        }
        try {
            String documentBase = locator.getSystemId();
            if (documentBase != null && !documentBase.endsWith("/")) {
                documentBase = documentBase.substring(0, documentBase.lastIndexOf("/") + 1);
            }
            uri = this.getURIResolver().resolve(include, documentBase);
        }
        catch (URIException ure) {
            throw new XMLException((Throwable)ure);
        }
        if (uri != null) {
            include = uri.getAbsoluteURI();
        }
        if (schema.includeProcessed(include)) {
            return;
        }
        if (include.equals(schema.getSchemaLocation())) {
            return;
        }
        Schema includedSchema = null;
        boolean alreadyLoaded = false;
        if (state.cacheIncludedSchemas) {
            if (uri instanceof SchemaLocation) {
                includedSchema = ((SchemaLocation)uri).getSchema();
                schema.cacheIncludedSchema(includedSchema);
                alreadyLoaded = true;
            }
            if (state.processed(include)) {
                includedSchema = state.getSchema(include);
                schema.cacheIncludedSchema(includedSchema);
                alreadyLoaded = true;
            }
        }
        if (includedSchema == null) {
            includedSchema = new Schema();
        } else {
            state.markAsProcessed(include, includedSchema);
        }
        schema.addInclude(include);
        if (alreadyLoaded) {
            return;
        }
        Parser parser = null;
        try {
            parser = this.getSchemaContext().getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (parser == null) {
            throw new SchemaException("Error failed to create parser for include");
        }
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(this.getSchemaContext(), true, state, this.getURIResolver());
        if (state.cacheIncludedSchemas) {
            schemaUnmarshaller.setSchema(includedSchema);
        } else {
            schemaUnmarshaller.setSchema(schema);
        }
        Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            InputSource source = new InputSource(uri.getReader());
            source.setSystemId(uri.getAbsoluteURI());
            parser.parse(source);
        }
        catch (IOException ioe) {
            throw new SchemaException("Error reading include file '" + include + "'");
        }
        catch (SAXException sx) {
            throw new SchemaException(sx);
        }
        if (state.cacheIncludedSchemas) {
            String ns = includedSchema.getTargetNamespace();
            if (ns == null || ns == "") {
                includedSchema.setTargetNamespace(schema.getTargetNamespace());
            } else if (!ns.equals(schema.getTargetNamespace())) {
                throw new SchemaException("The target namespace of the included components must be the same as the target namespace of the including schema");
            }
            schema.cacheIncludedSchema(includedSchema);
        }
    }

    @Override
    public String elementName() {
        return "include";
    }

    @Override
    public Object getObject() {
        return null;
    }
}

