/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.CharacterUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.IdentityConstraintUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;

public class ElementUnmarshaller
extends ComponentReader {
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ElementDecl _element = null;
    private CharacterUnmarshaller charUnmarshaller = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundIdentityConstraint = false;
    private boolean foundSimpleType = false;
    private boolean foundComplexType = false;
    private boolean foundTypeReference = false;

    public ElementUnmarshaller(SchemaContext schemaContext, Schema schema, AttributeSet atts) throws XMLException {
        super(schemaContext);
        this._schema = schema;
        this._element = new ElementDecl(schema);
        String attValue = null;
        attValue = atts.getValue("ref");
        if (attValue != null) {
            this._element.setReferenceName(attValue);
            if (atts.getValue("name") != null) {
                this.error("The attributes 'ref' and 'name' appearing on element declarations are mutually exclusive.");
            }
            ElementUnmarshaller.validateRefAtts(atts);
        } else {
            this._element.setName(atts.getValue("name"));
        }
        attValue = atts.getValue("abstract");
        if (attValue != null) {
            this._element.setAbstract(new Boolean(attValue));
        }
        this._element.setBlock(atts.getValue("block"));
        attValue = atts.getValue("default");
        if (attValue != null) {
            if (this._element.getFixedValue() != null) {
                this.error("'default' and 'fixed' must not both be present.");
            }
            this._element.setDefaultValue(attValue);
        }
        this._element.setFinal(atts.getValue("final"));
        boolean isAbstract = new Boolean(atts.getValue("abstract"));
        if (isAbstract) {
            this._element.setAbstract(isAbstract);
        }
        if ((attValue = atts.getValue("fixed")) != null) {
            if (this._element.getDefaultValue() != null) {
                throw new IllegalArgumentException("'default' and 'fixed' must not both be present.");
            }
            this._element.setFixedValue(attValue);
        }
        if ((attValue = atts.getValue("form")) != null) {
            this._element.setForm(Form.valueOf(attValue));
        }
        this._element.setId(atts.getValue("id"));
        attValue = atts.getValue("substitutionGroup");
        if (attValue != null) {
            this._element.setSubstitutionGroup(attValue);
        }
        if ((attValue = atts.getValue("type")) != null) {
            this.foundTypeReference = true;
            this._element.setTypeReference(attValue);
        }
        if ((attValue = atts.getValue("nillable")) != null) {
            if (attValue.equals("true") || attValue.equals("1")) {
                this._element.setNillable(true);
            } else if (!attValue.equals("false") && !attValue.equals("0")) {
                String err = "Invalid value for the 'nillable' attribute of an element definition: " + attValue;
                throw new IllegalArgumentException(err);
            }
        }
        attValue = atts.getValue("minOccurs");
        int minOccurs = 1;
        if (attValue != null) {
            minOccurs = ElementUnmarshaller.toInt(attValue);
            this._element.setMinOccurs(minOccurs);
        }
        if ((attValue = atts.getValue("maxOccurs")) != null) {
            if (MAX_OCCURS_WILDCARD.equals(attValue)) {
                attValue = "-1";
            }
            int maxOccurs = ElementUnmarshaller.toInt(attValue);
            this._element.setMaxOccurs(maxOccurs);
        } else if (minOccurs > 1) {
            this._element.setMaxOccurs(minOccurs);
        }
        this.charUnmarshaller = new CharacterUnmarshaller(this.getSchemaContext());
    }

    @Override
    public String elementName() {
        return "element";
    }

    public ElementDecl getElement() {
        return this._element;
    }

    @Override
    public Object getObject() {
        return this._element;
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("annotation".equals(name)) {
            if (this.foundSimpleType || this.foundIdentityConstraint || this.foundComplexType) {
                this.error("An annotation may only appear as the first child of an element definition.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) 'annotation' is allowed as a child of element definitions.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(this.getSchemaContext(), atts);
        } else if ("complexType".equals(name)) {
            if (this.foundComplexType) {
                this.error("Only one (1) 'complexType' may appear in an element definition.");
            }
            if (this.foundSimpleType) {
                this.error("Both 'simpleType' and 'complexType' cannot appear in the same element definition.");
            }
            if (this.foundTypeReference) {
                this.error("Both 'type' attribute and 'complexType' element cannot appear in the same element definition.");
            }
            if (this.foundIdentityConstraint) {
                this.error("A 'complexType' must appear before 'key', 'keyref' and 'unique' elements.");
            }
            this.foundComplexType = true;
            this.unmarshaller = new ComplexTypeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if ("simpleType".equals(name)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear in an element definition.");
            }
            if (this.foundComplexType) {
                this.error("Both 'simpleType' and 'complexType' cannot appear in the same element definition.");
            }
            if (this.foundTypeReference) {
                this.error("Both 'type' attribute and 'simpleType' element cannot appear in the same element definition.");
            }
            if (this.foundIdentityConstraint) {
                this.error("A 'simpleType' must appear before 'key', 'keyref' and 'unique' elements.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if ("key".equals(name) || "keyref".equals(name) || "unique".equals(name)) {
            this.foundIdentityConstraint = true;
            this.unmarshaller = new IdentityConstraintUnmarshaller(this.getSchemaContext(), name, atts);
        } else {
            this.illegalElement(name);
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && this.charUnmarshaller != this.unmarshaller && !name.equals(this.unmarshaller.elementName())) {
            String err = "missing end element for ";
            err = err + this.unmarshaller.elementName();
            throw new SchemaException(err);
        }
        this.unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation ann = (Annotation)this.unmarshaller.getObject();
            this._element.addAnnotation(ann);
        } else if ("complexType".equals(name)) {
            ComplexType xmlType = ((ComplexTypeUnmarshaller)this.unmarshaller).getComplexType();
            this._element.setType(xmlType);
        } else if ("simpleType".equals(name)) {
            SimpleType xmlType = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._element.setType(xmlType);
        } else if ("key".equals(name) || "keyref".equals(name) || "unique".equals(name)) {
            IdentityConstraint constraint = (IdentityConstraint)this.unmarshaller.getObject();
            this._element.addIdentityConstraint(constraint);
        }
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }

    private static void validateRefAtts(AttributeSet atts) throws XMLException {
        StringBuffer errors = null;
        for (int i = 0; i < atts.getSize(); ++i) {
            String namespace;
            String name = atts.getName(i);
            if ("ref".equals(name) || "maxOccurs".equals(name) || "minOccurs".equals(name) || "id".equals(name) || (namespace = atts.getNamespace(i)) != null && namespace.length() != 0 && !namespace.equals("http://www.w3.org/2001/XMLSchema")) continue;
            String error = "The attribute '" + name + "' must not appear on an element reference.";
            if (errors == null) {
                errors = new StringBuffer(error);
            } else {
                errors.append(error);
            }
            errors.append(System.getProperty("line.separator"));
        }
        if (errors != null) {
            throw new XMLException(errors.toString());
        }
    }
}

