/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AnyType;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.RedefineSchema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.XMLType;

public class Schema
extends Annotated {
    private static final long serialVersionUID = -8130246250710502508L;
    public static final String DEFAULT_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NULL_ARGUMENT = "A null argument was passed to " + Schema.class.getName() + "#";
    private static SimpleTypesFactory simpleTypesFactory = new SimpleTypesFactory();
    private Form _attributeFormDefault = null;
    private Map<String, AttributeGroup> _attributeGroups = new Hashtable<String, AttributeGroup>();
    private Map<String, AttributeDecl> _attributes = new Hashtable<String, AttributeDecl>();
    private BlockList _block = null;
    private Map<String, ComplexType> _complexTypes = new Hashtable<String, ComplexType>();
    private Form _elementFormDefault = null;
    private Map<String, ElementDecl> _elements = new Hashtable<String, ElementDecl>();
    private FinalList _final = null;
    private Map<String, ModelGroup> _groups = new Hashtable<String, ModelGroup>();
    private Map<String, RedefineSchema> _redefineSchemas = new Hashtable<String, RedefineSchema>();
    private String _id = null;
    private Map<String, Schema> _importedSchemas = new Hashtable<String, Schema>();
    private Map<String, Schema> _cachedincludedSchemas = new Hashtable<String, Schema>();
    private Vector<String> _includedSchemas = new Vector();
    private Namespaces _namespaces = new Namespaces();
    private String _schemaLocation = null;
    private String _schemaNamespace = null;
    private Hashtable<String, SimpleType> _simpleTypes = new Hashtable();
    private String _targetNamespace = null;
    private String _version = null;
    private Schema _masterSchema = null;

    public Schema() {
        this(null, DEFAULT_SCHEMA_NS);
    }

    public Schema(String schemaNS) {
        this(null, schemaNS);
    }

    public Schema(String prefix, String schemaNamespace) {
        this._schemaNamespace = schemaNamespace == null ? DEFAULT_SCHEMA_NS : schemaNamespace;
        if (prefix == null) {
            prefix = "";
        }
        this.addNamespace(prefix, this._schemaNamespace);
    }

    public void addAttribute(AttributeDecl attribute) throws SchemaException {
        if (attribute == null) {
            return;
        }
        String name = attribute.getName();
        if (attribute.getSchema() != this) {
            String err = "invalid attempt to add an AttributeDecl which ";
            err = err + "belongs to a different Schema; " + name;
            throw new SchemaException(err);
        }
        if (name == null && attribute.isReference()) {
            String err = "Error attempting to add a top-level AttributeDecl that is a reference. Top-level attributes can only be attribute declarations: " + attribute.getName(false);
            throw new SchemaException(err);
        }
        AttributeDecl obj = this.getAttribute(name);
        if (obj == attribute) {
            return;
        }
        if (obj != null) {
            String err = "Error attempting to add an AttributeDecl to this Schema definition, an AttributeDecl already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._attributes.put(name, attribute);
        attribute.setParent(this);
    }

    public void addAttributeGroup(AttributeGroupDecl attrGroup) throws SchemaException {
        if (attrGroup == null) {
            return;
        }
        String name = attrGroup.getName();
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String nsPrefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            String ns = this._namespaces.getNamespaceURI(nsPrefix);
            if (ns == null) {
                String err = "addAttributeGroup: ";
                err = err + "Namespace prefix not recognized '" + nsPrefix + "'";
                throw new IllegalArgumentException(err);
            }
            if (!ns.equals(this._targetNamespace)) {
                String err = "AttributeGroup has different namespace than this Schema definition.";
                throw new IllegalArgumentException(err);
            }
        }
        if (attrGroup.getSchema() != this) {
            String err = "invalid attempt to add an AttributeGroup which ";
            err = err + "belongs to a different Schema; " + name;
            throw new SchemaException(err);
        }
        AttributeGroup obj = this.getAttributeGroup(name);
        if (obj == attrGroup) {
            return;
        }
        boolean redefine = attrGroup.isRedefined();
        if (obj != null && !redefine) {
            String err = "Error attempting to add an AttributeGroup to this Schema definition, an AttributeGroup already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._attributeGroups.put(name, attrGroup);
    }

    public synchronized void addComplexType(ComplexType complexType) throws SchemaException {
        String name = complexType.getName();
        if (name == null) {
            String err = "a global ComplexType must contain a name.";
            throw new SchemaException(err);
        }
        if (complexType.getSchema() != this) {
            String err = "invalid attempt to add an ComplexType which ";
            err = err + "belongs to a different Schema; type name: " + name;
            throw new SchemaException(err);
        }
        if (this.getComplexType(name) != null && !complexType.isRedefined()) {
            String err = "a ComplexType already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._complexTypes.put(name, complexType);
        complexType.setParent(this);
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        String name = elementDecl.getName(true);
        if (name == null && elementDecl.isReference()) {
            String err = "Error attempting to add a top-level Element that is a reference. Top-level elements can only be element declarations: " + elementDecl.getName(false);
            throw new SchemaException(err);
        }
        if (name == null) {
            String err = "an element declaration must contain a name.";
            throw new SchemaException(err);
        }
        if (this.getElementDecl(name) != null) {
            String err = "an element declaration already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._elements.put(name, elementDecl);
        elementDecl.setParent(this);
    }

    public void addModelGroup(ModelGroup group) throws SchemaException {
        String name = group.getName();
        if (name == null) {
            String err = "a group declaration must contain a name.";
            throw new SchemaException(err);
        }
        if (this.getModelGroup(name) != null && !group.isRedefined()) {
            String err = "a group declaration already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._groups.put(name, group);
        group.setParent(this);
    }

    public void addRedefineSchema(RedefineSchema schema) throws SchemaException {
        String uri = schema.getSchemaLocation();
        if (uri == null && schema.hasRedefinition()) {
            String err = "A <redefine> structure with no 'schemaLocation' attribute must contain only <annotation> elements";
            throw new SchemaException(err);
        }
        if (this._redefineSchemas.get(uri) != null) {
            String err = "The redefinition for schema:" + uri + " can only be used once.";
            throw new SchemaException(err);
        }
        this._redefineSchemas.put(uri, schema);
    }

    public synchronized void addImportedSchema(Schema schema) throws SchemaException {
        String targetNamespace = schema.getTargetNamespace();
        if (targetNamespace == null) {
            targetNamespace = "";
        }
        if (this._importedSchemas.get(targetNamespace) != null) {
            String err = "a Schema has already been imported with the given namespace: ";
            throw new SchemaException(err + targetNamespace);
        }
        this._importedSchemas.put(targetNamespace, schema);
    }

    public synchronized void cacheIncludedSchema(Schema schema) throws SchemaException {
        String schemaLocation = schema.getSchemaLocation();
        if (schemaLocation == null) {
            schemaLocation = "";
        }
        if (this._cachedincludedSchemas.get(schemaLocation) != null) {
            String err = "a Schema has already been included with the given schemaLocation: ";
            throw new SchemaException(err + schemaLocation);
        }
        this._cachedincludedSchemas.put(schemaLocation, schema);
    }

    public void addNamespace(String prefix, String ns) {
        this._namespaces.addNamespace(prefix, ns);
    }

    public synchronized void addSimpleType(SimpleType simpleType) throws SchemaException {
        String name = simpleType.getName();
        if (name == null || name.length() == 0) {
            String err = "No name found for top-level SimpleType.  A top-level SimpleType must have a name.";
            throw new SchemaException(err);
        }
        if (simpleType.getSchema() != this) {
            String err = "invalid attempt to add a SimpleType which ";
            err = err + "belongs to a different Schema; type name: " + name;
            throw new SchemaException(err);
        }
        if (this.getSimpleType(name, this._targetNamespace) != null && !simpleType.isRedefined()) {
            String err = "a SimpleType already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        simpleType.setParent(this);
        this._simpleTypes.put(name, simpleType);
    }

    public ComplexType createComplexType() {
        return new ComplexType(this);
    }

    public ComplexType createComplexType(String name) {
        return new ComplexType(this, name);
    }

    public SimpleType createSimpleType(String name, String baseName, String derivation) {
        return simpleTypesFactory.createUserSimpleType(this, name, baseName, derivation, true);
    }

    public SimpleType createSimpleType(String name, SimpleType baseType) {
        return simpleTypesFactory.createUserSimpleType(this, name, baseType, "restriction");
    }

    public Form getAttributeFormDefault() {
        return this._attributeFormDefault;
    }

    public Collection<AttributeDecl> getAttributes() {
        Vector<AttributeDecl> result = new Vector<AttributeDecl>(this._attributes.size() * 2);
        result.addAll(this._attributes.values());
        Collection<Schema> cachedincluded = this._cachedincludedSchemas.values();
        for (Schema includedSchema : cachedincluded) {
            Collection<AttributeDecl> tempAtt = includedSchema.getAttributes();
            for (AttributeDecl attributeDecl : tempAtt) {
                result.add(attributeDecl);
            }
        }
        Collection<RedefineSchema> redefinition = this._redefineSchemas.values();
        for (RedefineSchema redefineSchema : redefinition) {
            Schema tempSchema = redefineSchema.getOriginalSchema();
            if (tempSchema == null) continue;
            tempSchema.setMasterSchema(this);
            Collection<AttributeDecl> tempAtt = tempSchema.getAttributes();
            for (AttributeDecl attributeDecl : tempAtt) {
                result.add(attributeDecl);
            }
        }
        return result;
    }

    public AttributeDecl getAttribute(String name) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getAttribute: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        String canonicalName = name;
        String nsprefix = "";
        String ns = this._targetNamespace;
        int colon = name.indexOf(58);
        if (colon != -1) {
            canonicalName = name.substring(colon + 1);
            nsprefix = name.substring(0, colon);
            ns = this._namespaces.getNamespaceURI(nsprefix);
            if (ns == null) {
                String err = "getAttribute: ";
                err = err + "Namespace prefix not recognized '" + name + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            AttributeDecl tempAtt = this._attributes.get(canonicalName);
            if (tempAtt == null) {
                Collection<Schema> cacheIncluded = this._cachedincludedSchemas.values();
                boolean found = false;
                for (Schema includedSchema : cacheIncluded) {
                    tempAtt = includedSchema.getAttribute(canonicalName);
                    if (tempAtt == null) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Iterator<RedefineSchema> redefinition = this._redefineSchemas.values().iterator();
                    while (redefinition.hasNext() && !found) {
                        Schema tempSchema = redefinition.next().getOriginalSchema();
                        if (tempSchema == null) continue;
                        tempSchema.setMasterSchema(this);
                        tempAtt = tempSchema.getAttribute(canonicalName);
                        if (tempAtt == null) continue;
                        found = true;
                    }
                }
            }
            return tempAtt;
        }
        Schema schema = this.getImportedSchema(ns);
        if (schema != null) {
            AttributeDecl att = schema.getAttribute(canonicalName);
            return att;
        }
        return null;
    }

    public Collection<AttributeGroup> getAttributeGroups() {
        Vector<AttributeGroup> result = new Vector<AttributeGroup>(this._attributeGroups.size() * 2);
        result.addAll(this._attributeGroups.values());
        Collection<Schema> cachedincluded = this._cachedincludedSchemas.values();
        for (Schema includedSchema : cachedincluded) {
            Collection<AttributeGroup> tempAtt = includedSchema.getAttributeGroups();
            for (AttributeGroup attributeGroup : tempAtt) {
                result.add(attributeGroup);
            }
        }
        Collection<RedefineSchema> redefinition = this._redefineSchemas.values();
        for (RedefineSchema redefineSchema : redefinition) {
            for (AttributeGroup attributeGroup : redefineSchema.enumerateAttributeGroups()) {
                result.add(attributeGroup);
            }
            Schema tempSchema = redefineSchema.getOriginalSchema();
            if (tempSchema == null) continue;
            tempSchema.setMasterSchema(this);
            for (AttributeGroup attributeGroup : tempSchema.getAttributeGroups()) {
                boolean alreadyRedefined = true;
                if (attributeGroup instanceof AttributeGroupDecl) {
                    alreadyRedefined = redefineSchema.hasAttributeGroupRedefinition(((AttributeGroupDecl)attributeGroup).getName());
                }
                if (alreadyRedefined) continue;
                result.add(attributeGroup);
            }
        }
        return result;
    }

    public AttributeGroup getAttributeGroup(String name) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getAttributeGroup: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        AttributeGroup result = null;
        String canonicalName = name;
        String nsprefix = "";
        String ns = this._targetNamespace;
        int colon = name.indexOf(58);
        if (colon != -1) {
            canonicalName = name.substring(colon + 1);
            nsprefix = name.substring(0, colon);
            ns = this._namespaces.getNamespaceURI(nsprefix);
            if (ns == null) {
                String err = "getAttributeGroup: ";
                err = err + "Namespace prefix not recognized '" + name + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            result = this._attributeGroups.get(canonicalName);
            if (result == null) {
                Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
                boolean found = false;
                while (cacheIncluded.hasNext() && !found) {
                    Schema temp = cacheIncluded.next();
                    result = temp.getAttributeGroup(canonicalName);
                    if (result == null) continue;
                    found = true;
                }
                if (!found) {
                    Iterator<RedefineSchema> redefinitions = this.getRedefineSchema().iterator();
                    while (redefinitions.hasNext() && !found) {
                        RedefineSchema redefine = redefinitions.next();
                        if (redefine.hasAttributeGroupRedefinition(canonicalName)) {
                            result = redefine.getAttributeGroup(canonicalName);
                            if (result != null) {
                                found = true;
                            }
                            break;
                        }
                        Schema schema = redefine.getOriginalSchema();
                        if (schema == null) continue;
                        schema.setMasterSchema(this);
                        result = schema.getAttributeGroup(name);
                    }
                }
            }
        } else {
            Schema schema = this.getImportedSchema(ns);
            if (schema != null) {
                result = schema.getAttributeGroup(canonicalName);
            }
        }
        return result;
    }

    public BlockList getBlockDefault() {
        return this._block;
    }

    public String getBuiltInTypeName(int builtInTypeCode) {
        return simpleTypesFactory.getBuiltInTypeName(builtInTypeCode);
    }

    public ComplexType getComplexType(String name) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getComplexType: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        ComplexType result = null;
        String canonicalName = name;
        String nsprefix = "";
        String ns = this._targetNamespace;
        int colon = name.indexOf(58);
        if (colon != -1) {
            canonicalName = name.substring(colon + 1);
            nsprefix = name.substring(0, colon);
            ns = this._namespaces.getNamespaceURI(nsprefix);
            if (ns == null) {
                String err = "getComplexType: ";
                err = err + "Namespace prefix not recognized '" + name + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            result = this._complexTypes.get(canonicalName);
            if (result == null) {
                boolean found = false;
                Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
                while (cacheIncluded.hasNext() && !found) {
                    Schema temp = cacheIncluded.next();
                    result = temp.getComplexType(canonicalName);
                    if (result == null) continue;
                    found = true;
                }
                if (!found) {
                    Iterator<RedefineSchema> redefinitions = this.getRedefineSchema().iterator();
                    while (redefinitions.hasNext() && result == null) {
                        RedefineSchema redefine = redefinitions.next();
                        if (redefine.hasComplexTypeRedefinition(canonicalName)) {
                            result = redefine.getComplexType(canonicalName);
                            if (result != null) {
                                found = true;
                            }
                            break;
                        }
                        Schema schema = redefine.getOriginalSchema();
                        if (schema == null) continue;
                        schema.setMasterSchema(this);
                        result = schema.getComplexType(canonicalName);
                    }
                }
            }
        } else {
            Schema schema = this.getImportedSchema(ns);
            if (schema != null) {
                result = schema.getComplexType(canonicalName);
            }
        }
        return result;
    }

    public Collection<ComplexType> getComplexTypes() {
        Vector<ComplexType> result = new Vector<ComplexType>(this._complexTypes.size() * 2);
        result.addAll(this._complexTypes.values());
        Collection<Schema> cachedincluded = this._cachedincludedSchemas.values();
        for (Schema includedSchema : cachedincluded) {
            Collection<ComplexType> tempEnum = includedSchema.getComplexTypes();
            for (ComplexType complexType : tempEnum) {
                result.add(complexType);
            }
        }
        Collection<RedefineSchema> redefinition = this._redefineSchemas.values();
        for (RedefineSchema redefineSchema : redefinition) {
            for (ComplexType complexType : redefineSchema.enumerateComplexTypes()) {
                result.add(complexType);
            }
            Schema tempSchema = redefineSchema.getOriginalSchema();
            if (tempSchema == null) continue;
            tempSchema.setMasterSchema(this);
            for (ComplexType tempType : tempSchema.getComplexTypes()) {
                if (redefineSchema.hasComplexTypeRedefinition(tempType.getName())) continue;
                result.add(tempType);
            }
        }
        return result;
    }

    public ElementDecl getElementDecl(String name) {
        String ns = null;
        if (name == null) {
            String err = NULL_ARGUMENT + "getElementDecl: ";
            err = err + " 'name' can not be null";
            throw new IllegalArgumentException(err);
        }
        ElementDecl result = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String nsPrefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            ns = this._namespaces.getNamespaceURI(nsPrefix);
            if (ns == null) {
                String err = "getElementDecl: ";
                err = err + "Namespace prefix not recognized '" + nsPrefix + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            result = this._elements.get(name);
            if (result == null) {
                Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
                boolean found = false;
                while (cacheIncluded.hasNext() && !found) {
                    Schema temp = cacheIncluded.next();
                    result = temp.getElementDecl(name);
                    if (result == null) continue;
                    found = true;
                }
                if (!found) {
                    Iterator<RedefineSchema> redefinition = this._redefineSchemas.values().iterator();
                    while (redefinition.hasNext() && !found) {
                        Schema schema = redefinition.next().getOriginalSchema();
                        if (schema == null) continue;
                        schema.setMasterSchema(this);
                        result = schema.getElementDecl(name);
                        if (result == null) continue;
                        found = true;
                    }
                }
            }
        } else {
            Schema schema = this.getImportedSchema(ns);
            if (schema != null) {
                result = schema.getElementDecl(name);
            }
        }
        return result;
    }

    public Collection<ElementDecl> getElementDecls() {
        Vector<ElementDecl> result = new Vector<ElementDecl>(this._elements.size() * 2);
        result.addAll(this._elements.values());
        Collection<Schema> cachedincluded = this._cachedincludedSchemas.values();
        for (Schema includedSchema : cachedincluded) {
            Collection<ElementDecl> tempEnum = includedSchema.getElementDecls();
            for (ElementDecl elementDecl : tempEnum) {
                result.add(elementDecl);
            }
        }
        Collection<RedefineSchema> redefinition = this._redefineSchemas.values();
        for (RedefineSchema redefineSchema : redefinition) {
            Schema tempSchema = redefineSchema.getOriginalSchema();
            if (tempSchema == null) continue;
            tempSchema.setMasterSchema(this);
            Collection<ElementDecl> redefinedElementDeclarations = tempSchema.getElementDecls();
            for (ElementDecl elementDecl : redefinedElementDeclarations) {
                result.add(elementDecl);
            }
        }
        return result;
    }

    public Form getElementFormDefault() {
        return this._elementFormDefault;
    }

    public FinalList getFinalDefault() {
        return this._final;
    }

    public SimpleType getSimpleType(String name) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getSimpleType: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        String nsPrefix = "";
        String ns = null;
        int colon = name.indexOf(58);
        if (colon >= 0) {
            nsPrefix = name.substring(0, colon);
            name = name.substring(colon + 1);
            ns = this._namespaces.getNamespaceURI(nsPrefix);
            if (ns == null) {
                String err = "getSimpleType: ";
                err = err + "Namespace prefix not recognised '" + nsPrefix + "'";
                err = err + "for simpleType:" + name;
                throw new IllegalArgumentException(err);
            }
        } else {
            ns = this._namespaces.getNamespaceURI(nsPrefix);
        }
        if (ns == null) {
            ns = this._targetNamespace;
        }
        return this.getSimpleType(name, ns);
    }

    public SimpleType getSimpleType(String name, String namespace) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getSimpleType: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        boolean isDefaultNS = false;
        if (namespace == null) {
            namespace = this._namespaces.getNamespaceURI("");
            isDefaultNS = true;
        }
        SimpleType result = null;
        if (namespace == null || isDefaultNS) {
            result = this._simpleTypes.get(name);
            if (result != null) {
                if (result.getType() != result && result.getType() != null) {
                    result = (SimpleType)result.getType();
                    result.setParent(this);
                    this._simpleTypes.put(name, result);
                }
            } else {
                result = simpleTypesFactory.getBuiltInType(name);
                if (result != null && !this._schemaNamespace.equals(namespace)) {
                    String err = "getSimpleType: the simple type '" + name + "' has not been declared in XML Schema namespace.";
                    throw new IllegalArgumentException(err);
                }
            }
        } else if (namespace.equals(this._schemaNamespace)) {
            result = simpleTypesFactory.getBuiltInType(name);
            if (result == null) {
                String err = "getSimpleType: the simple type '" + name + "' is not a built-in type as defined in XML Schema specification.";
                throw new IllegalArgumentException(err);
            }
        } else if (namespace.equals(this._targetNamespace)) {
            result = this._simpleTypes.get(name);
            if (result != null && result.getType() != result && result.getType() != null) {
                result = (SimpleType)result.getType();
                result.setParent(this);
                this._simpleTypes.put(name, result);
            }
            if (result == null) {
                Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
                boolean found = false;
                while (cacheIncluded.hasNext() && !found) {
                    Schema temp = cacheIncluded.next();
                    result = temp.getSimpleType(name, namespace);
                    if (result == null) continue;
                    found = true;
                }
                if (!found) {
                    Iterator<RedefineSchema> redefinitions = this.getRedefineSchema().iterator();
                    while (redefinitions.hasNext() && result == null) {
                        RedefineSchema redefine = redefinitions.next();
                        if (redefine.hasSimpleTypeRedefinition(name)) {
                            result = redefine.getSimpleType(name);
                            if (result != null) {
                                found = true;
                            }
                            break;
                        }
                        Schema schema = redefine.getOriginalSchema();
                        if (schema == null) continue;
                        schema.setMasterSchema(this);
                        result = schema.getSimpleType(name, namespace);
                    }
                }
            }
        } else {
            Schema schema = this.getImportedSchema(namespace);
            if (schema != null) {
                result = schema.getSimpleType(name, namespace);
            }
        }
        if (result != null) {
            result = (SimpleType)result.getType();
        }
        return result;
    }

    public Collection<SimpleType> getSimpleTypes() {
        Enumeration<SimpleType> enumeration = this._simpleTypes.elements();
        while (enumeration.hasMoreElements()) {
            SimpleType type = enumeration.nextElement();
            if (type == type.getType() || type.getType() == null) continue;
            String name = type.getName();
            type = (SimpleType)type.getType();
            type.setParent(this);
            this._simpleTypes.put(name, type);
        }
        Vector<SimpleType> result = new Vector<SimpleType>(this._simpleTypes.size() * 2);
        result.addAll(this._simpleTypes.values());
        Collection<Schema> cachedincluded = this._cachedincludedSchemas.values();
        for (Schema includedSchema : cachedincluded) {
            Collection<SimpleType> tempEnum = includedSchema.getSimpleTypes();
            for (SimpleType simpleType : tempEnum) {
                result.add(simpleType);
            }
        }
        Collection<RedefineSchema> redefinition = this._redefineSchemas.values();
        for (RedefineSchema redefineSchema : redefinition) {
            for (SimpleType simpleType : redefineSchema.enumerateSimpleTypes()) {
                result.add(simpleType);
            }
            Schema tempSchema = redefineSchema.getOriginalSchema();
            if (tempSchema == null) continue;
            tempSchema.setMasterSchema(this);
            Collection<SimpleType> tempEnum = tempSchema.getSimpleTypes();
            for (SimpleType simpleType : tempEnum) {
                if (redefineSchema.hasSimpleTypeRedefinition(simpleType.getName())) continue;
                result.add(simpleType);
            }
        }
        return result;
    }

    public String getSchemaLocation() {
        return this._schemaLocation;
    }

    public ModelGroup getModelGroup(String name) {
        String ns = null;
        if (name == null) {
            String err = NULL_ARGUMENT + "getModelGroup: ";
            err = err + " 'name' can not be null";
            throw new IllegalArgumentException(err);
        }
        ModelGroup result = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String nsPrefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            ns = this._namespaces.getNamespaceURI(nsPrefix);
            if (ns == null) {
                String err = "getModelGroup: ";
                err = err + "Namespace prefix not recognized '" + nsPrefix + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            result = this._groups.get(name);
            if (result == null) {
                Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
                boolean found = false;
                while (cacheIncluded.hasNext() && !found) {
                    Schema temp = cacheIncluded.next();
                    result = temp.getModelGroup(name);
                    if (result == null) continue;
                    found = true;
                }
                if (!found) {
                    Iterator<RedefineSchema> redefinitions = this.getRedefineSchema().iterator();
                    while (redefinitions.hasNext() && result == null) {
                        RedefineSchema redefine = redefinitions.next();
                        if (redefine.hasGroupRedefinition(name)) {
                            result = redefine.getModelGroup(name);
                            if (result != null) {
                                found = true;
                            }
                            break;
                        }
                        Schema schema = redefine.getOriginalSchema();
                        if (schema == null) continue;
                        schema.setMasterSchema(this);
                        result = schema.getModelGroup(name);
                    }
                }
            }
        } else {
            Schema schema = this.getImportedSchema(ns);
            if (schema != null) {
                result = schema.getModelGroup(name);
            }
        }
        return result;
    }

    public Collection<ModelGroup> getModelGroups() {
        Vector<ModelGroup> result = new Vector<ModelGroup>(this._groups.size() * 2);
        result.addAll(this._groups.values());
        Collection<Schema> cachedincluded = this._cachedincludedSchemas.values();
        for (Schema includedSchema : cachedincluded) {
            Collection<ModelGroup> tempEnum = includedSchema.getModelGroups();
            for (ModelGroup modelGroup : tempEnum) {
                result.add(modelGroup);
            }
        }
        Collection<RedefineSchema> redefinition = this._redefineSchemas.values();
        for (RedefineSchema redefineSchema : redefinition) {
            for (ModelGroup modelGroup : redefineSchema.enumerateGroups()) {
                result.add(modelGroup);
            }
            Schema tempSchema = redefineSchema.getOriginalSchema();
            if (tempSchema == null) continue;
            tempSchema.setMasterSchema(this);
            for (ModelGroup modelGroup : tempSchema.getModelGroups()) {
                if (redefineSchema.hasGroupRedefinition(modelGroup.getName())) continue;
                result.add(modelGroup);
            }
        }
        return result;
    }

    public String getId() {
        return this._id;
    }

    public Collection<Schema> getImportedSchema() {
        return this._importedSchemas.values();
    }

    public Schema getImportedSchema(String ns) {
        return this.getImportedSchema(ns, null);
    }

    public Collection<RedefineSchema> getRedefineSchema() {
        return this._redefineSchemas.values();
    }

    public RedefineSchema getRedefineSchema(String schemaLocation) {
        RedefineSchema result = this._redefineSchemas.get(schemaLocation);
        return result;
    }

    public Schema getCachedIncludedSchema(String schemaLocation) {
        return this._cachedincludedSchemas.get(schemaLocation);
    }

    public Collection<Schema> getCachedIncludedSchemas() {
        return this._cachedincludedSchemas.values();
    }

    public Schema getImportedSchema(String ns, boolean localOnly) {
        if (localOnly) {
            return this._importedSchemas.get(ns);
        }
        return this.getImportedSchema(ns, null);
    }

    private Schema getImportedSchema(String ns, Schema caller) {
        Schema result;
        block3: {
            Schema temp;
            if (caller == this) {
                return null;
            }
            if (caller == null) {
                caller = this;
            }
            if ((result = this._importedSchemas.get(ns)) != null) break block3;
            Iterator<Schema> schemas = this._importedSchemas.values().iterator();
            while (schemas.hasNext() && (result = (temp = schemas.next()).getImportedSchema(ns, caller)) == null) {
            }
        }
        return result;
    }

    public final String getNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return this._namespaces.getNamespaceURI(prefix);
    }

    public Namespaces getNamespaces() {
        return this._namespaces;
    }

    public void addInclude(String include) {
        this._includedSchemas.addElement(include);
    }

    public boolean includeProcessed(String includeFile) {
        return this._includedSchemas.contains(includeFile);
    }

    public String getSchemaNamespace() {
        return this._schemaNamespace;
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isKnownNamespace(String namespaceURL) {
        return this._namespaces.getNamespacePrefix(namespaceURL) != null;
    }

    public boolean removeComplexType(ComplexType complexType) {
        boolean result = false;
        if (complexType.isTopLevel()) {
            if (this._complexTypes.containsValue(complexType)) {
                this._complexTypes.remove(complexType.getName());
                complexType.setParent(null);
                result = true;
            }
            if (!result) {
                Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
                while (cacheIncluded.hasNext() && !result) {
                    Schema temp = cacheIncluded.next();
                    result = temp.removeComplexType(complexType);
                }
                if (!result) {
                    Iterator<RedefineSchema> redefinitions = this.getRedefineSchema().iterator();
                    while (redefinitions.hasNext() && !result) {
                        RedefineSchema redefine = redefinitions.next();
                        result = redefine.removeComplexType(complexType);
                    }
                }
            }
        }
        return result;
    }

    public boolean removeElement(ElementDecl element) {
        boolean result = false;
        if (this._elements.containsValue(element)) {
            this._elements.remove(element.getName());
            result = true;
        }
        if (!result) {
            Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
            while (cacheIncluded.hasNext() && !result) {
                Schema temp = cacheIncluded.next();
                result = temp.removeElement(element);
            }
        }
        return result;
    }

    public boolean removeAttribute(AttributeDecl attribute) {
        boolean result = false;
        if (this._attributes.containsValue(attribute)) {
            this._attributes.remove(attribute.getName());
            result = true;
        }
        if (!result) {
            Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
            while (cacheIncluded.hasNext() && !result) {
                Schema temp = cacheIncluded.next();
                result = temp.removeAttribute(attribute);
            }
        }
        return false;
    }

    public boolean removeGroup(ModelGroup group) {
        boolean result = false;
        if (this._groups.containsValue(group)) {
            this._groups.remove(group.getName());
            result = true;
        }
        if (!result) {
            Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
            while (cacheIncluded.hasNext() && !result) {
                Schema temp = cacheIncluded.next();
                result = temp.removeGroup(group);
            }
            if (!result) {
                Iterator<RedefineSchema> redefinitions = this.getRedefineSchema().iterator();
                while (redefinitions.hasNext() && !result) {
                    RedefineSchema redefine = redefinitions.next();
                    result = redefine.removeGroup(group);
                }
            }
        }
        return result;
    }

    public boolean removeAttributeGroup(AttributeGroupDecl group) {
        boolean result = false;
        if (this._attributeGroups.containsValue(group)) {
            this._attributeGroups.remove(group.getName());
            result = true;
        }
        if (!result) {
            Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
            while (cacheIncluded.hasNext() && !result) {
                Schema temp = cacheIncluded.next();
                result = temp.removeAttributeGroup(group);
            }
            if (!result) {
                Iterator<RedefineSchema> redefinitions = this.getRedefineSchema().iterator();
                while (redefinitions.hasNext() && !result) {
                    RedefineSchema redefine = redefinitions.next();
                    result = redefine.removeAttributeGroup(group);
                }
            }
        }
        return result;
    }

    public synchronized boolean removeCachedIncludedSchema(Schema schema) {
        if (schema == null) {
            return false;
        }
        String schemaLocation = schema.getSchemaLocation();
        Schema tmp = this._cachedincludedSchemas.get(schemaLocation);
        if (schema.equals(tmp)) {
            this._cachedincludedSchemas.remove(schemaLocation);
            return true;
        }
        return false;
    }

    public synchronized boolean removeImportedSchema(Schema schema) {
        Schema tmp;
        if (schema == null) {
            return false;
        }
        String targetNamespace = schema.getTargetNamespace();
        if (targetNamespace == null) {
            targetNamespace = "";
        }
        if (schema.equals(tmp = this._importedSchemas.get(targetNamespace))) {
            this._importedSchemas.remove(targetNamespace);
            return true;
        }
        return false;
    }

    public boolean removeNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return this._namespaces.removeNamespace(prefix);
    }

    public synchronized boolean removeRedefineSchema(RedefineSchema schema) {
        if (schema == null) {
            return false;
        }
        String schemaLocation = schema.getSchemaLocation();
        RedefineSchema tmp = this._redefineSchemas.get(schemaLocation);
        if (schema.equals(tmp)) {
            this._redefineSchemas.remove(schemaLocation);
            return true;
        }
        return false;
    }

    public boolean removeSimpleType(SimpleType simpleType) {
        boolean result = false;
        if (this._simpleTypes.containsValue(simpleType)) {
            this._simpleTypes.remove(simpleType.getName());
            result = true;
        }
        if (!result) {
            Iterator<Schema> cacheIncluded = this._cachedincludedSchemas.values().iterator();
            while (cacheIncluded.hasNext() && !result) {
                Schema temp = cacheIncluded.next();
                result = temp.removeSimpleType(simpleType);
            }
            if (!result) {
                Iterator<RedefineSchema> redefinitions = this.getRedefineSchema().iterator();
                while (redefinitions.hasNext() && !result) {
                    RedefineSchema redefine = redefinitions.next();
                    result = redefine.removeSimpleType(simpleType);
                }
            }
        }
        return result;
    }

    public void setAttributeFormDefault(Form attributeFormDefault) {
        this._attributeFormDefault = attributeFormDefault;
    }

    public void setBlockDefault(BlockList block) {
        this._block = block;
    }

    public void setBlockDefault(String block) {
        this._block = new BlockList(block);
    }

    public void setElementFormDefault(Form elementFormDefault) {
        this._elementFormDefault = elementFormDefault;
    }

    public void setFinalDefault(FinalList finalList) {
        this._final = finalList;
    }

    public void setFinalDefault(String finalValues) {
        this._final = new FinalList(finalValues);
    }

    public void setSchemaLocation(String schemaLocation) {
        this._schemaLocation = schemaLocation;
    }

    public XMLType getType(String typeName) {
        if (typeName == null) {
            String err = NULL_ARGUMENT + "Schema#getType: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        XMLType result = null;
        String localName = typeName;
        String prefix = "";
        String ns = null;
        int colon = typeName.indexOf(58);
        if (colon >= 0) {
            localName = typeName.substring(colon + 1);
            prefix = typeName.substring(0, colon);
            ns = this._namespaces.getNamespaceURI(prefix);
            if (ns == null) {
                String err = "Schema#getType: ";
                err = err + "Namespace prefix not recognised '" + typeName + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null) {
            ns = this._namespaces.getNamespaceURI(prefix);
        }
        if (ns == null) {
            ns = this._targetNamespace;
        }
        if (localName.equals("anyType") && ns.equals(DEFAULT_SCHEMA_NS)) {
            result = new AnyType(this);
        }
        IllegalArgumentException exception = null;
        if (result == null) {
            try {
                result = this.getSimpleType(localName, ns);
            }
            catch (IllegalArgumentException iox) {
                exception = iox;
            }
        }
        if (result == null) {
            try {
                result = this.getComplexType(typeName);
            }
            catch (IllegalArgumentException iox) {
                exception = iox;
            }
        }
        if (result == null && exception != null) {
            throw exception;
        }
        return result;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setTargetNamespace(String targetNamespace) {
        if (targetNamespace != null && (targetNamespace = targetNamespace.trim()).length() == 0) {
            throw new IllegalStateException("an empty string is not a valid namespace.");
        }
        this._targetNamespace = targetNamespace;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    static SimpleTypesFactory getTypeFactory() {
        return simpleTypesFactory;
    }

    @Override
    public short getStructureType() {
        return 19;
    }

    @Override
    public void validate() throws ValidationException {
        for (ComplexType complexType : this._complexTypes.values()) {
            complexType.validate();
        }
        for (SimpleType simpleType : this._simpleTypes.values()) {
            simpleType.validate();
        }
        for (ElementDecl element : this._elements.values()) {
            element.validate();
        }
        for (AttributeDecl attribute : this._attributes.values()) {
            attribute.validate();
        }
        for (ModelGroup group : this._groups.values()) {
            group.validate();
        }
    }

    public String getNamespacePrefix(String namespace) {
        return this._namespaces.getNamespacePrefix(namespace);
    }

    protected Schema getMasterSchema() {
        return this._masterSchema;
    }

    protected void setMasterSchema(Schema masterSchema) {
        this._masterSchema = masterSchema;
    }
}

