/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;

public class ModelGroup
extends Group {
    private static final long serialVersionUID = -2057934322265672413L;
    private String _groupRef = null;
    private Vector _modelDefs;
    private boolean _redefinition = false;
    private Schema _schema = null;

    public ModelGroup() {
        this((Schema)null);
    }

    public ModelGroup(Schema schema) {
        this(null, schema);
    }

    public ModelGroup(String name, Schema schema) {
        super(name);
        this._schema = schema;
        this._modelDefs = new Vector();
    }

    public void addModelGroup(ModelGroup modelGroup) {
        if (!this._modelDefs.contains(modelGroup)) {
            this._modelDefs.addElement(modelGroup);
        }
    }

    @Override
    public Enumeration enumerate() {
        return this.getContentModelGroup().enumerate();
    }

    public Enumeration getDeclarations() {
        return this._modelDefs.elements();
    }

    @Override
    public ContentModelGroup getContentModelGroup() {
        if (this._groupRef != null) {
            return this.getReference().getContentModelGroup();
        }
        return super.getContentModelGroup();
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean ignoreRef) {
        if (!ignoreRef && this._groupRef != null) {
            String localName = this._groupRef;
            int idx = localName.indexOf(58);
            if (idx > 0) {
                localName = localName.substring(idx + 1);
            }
            return localName;
        }
        return super.getName();
    }

    public boolean isReference() {
        return this._groupRef != null;
    }

    public void setRedefined() {
        this._redefinition = true;
    }

    public boolean isRedefined() {
        return this._redefinition;
    }

    public void setReference(String reference) {
        this._groupRef = reference;
    }

    @Override
    public short getStructureType() {
        return 16;
    }

    @Override
    public String getReferenceId() {
        if (this.getName() != null) {
            return "group:" + this.getName();
        }
        return null;
    }

    public ModelGroup getReference() {
        ModelGroup result = null;
        if (this._groupRef != null) {
            ModelGroup temp;
            result = this._schema.getModelGroup(this._groupRef);
            if (this._schema.getMasterSchema() != null && (temp = this._schema.getMasterSchema().getModelGroup(this._groupRef)) != null) {
                result = temp;
            }
            if (result == null) {
                String err = "Unable to find group referenced :\" ";
                err = err + this.getName();
                err = err + "\"";
                throw new IllegalStateException(err);
            }
        }
        return result;
    }

    public boolean hasReference() {
        return this._groupRef != null ? this._groupRef.length() != 0 : false;
    }

    @Override
    public void validate() throws ValidationException {
        if (this.getParent() != null && this.getParent().getStructureType() != 19 && this.getName(true) != null) {
            String err = "Only top-level model group definition (<group>) can be named.";
            err = err + this.getName() + "is not a valid model group definition.";
            throw new ValidationException(err);
        }
        if (this.getContentModelGroup() == null) {
            String err = "<group> should contains :\" ";
            err = err + " 'all' or 'sequence' or 'choice'";
            err = err + "\"";
            throw new ValidationException(err);
        }
        block3: for (int i = 0; i < this.getParticleCount(); ++i) {
            Particle temp = this.getParticle(i);
            switch (temp.getStructureType()) {
                case 16: {
                    ModelGroup tempGroup = (ModelGroup)temp;
                    String name = null;
                    if (tempGroup.getReference() != null) {
                        name = tempGroup.getReference().getName();
                    }
                    if (name != null && name.equals(this.getName())) {
                        if (this.isRedefined()) {
                            if (this.getMaxOccurs() != 1 || this.getMinOccurs() != 1) {
                                String err = "in the redefined <group> named:" + this.getName();
                                err = err + "\nThe particle information (minOccurs, maxOccurs) of a circular group must be set to 1.\n";
                                throw new ValidationException(err);
                            }
                        } else {
                            String err = "in <group> named:" + this.getName();
                            err = err + "\nCircular groups are disallowed.\n";
                            err = err + "That is, within the {particles} of a group there must not be at any depth a particle whose {term} is the group itself.\n";
                            throw new ValidationException(err);
                        }
                    }
                    tempGroup = tempGroup.getReference();
                    for (int j = 0; j < tempGroup.getParticleCount(); ++j) {
                        ModelGroup referencedGroup;
                        if (tempGroup.getParticle(j).getStructureType() != 16 || (referencedGroup = ((ModelGroup)tempGroup.getParticle(j)).getReference()) == null || !referencedGroup.equals(this)) continue;
                        if (this.isRedefined()) {
                            if (this.getMaxOccurs() == 1 && this.getMinOccurs() == 1) continue;
                            String err = "in the redefined <group> named:" + this.getName();
                            err = err + "\nThe particle information (minOccurs, maxOccurs) of a circular group must be set to 1.\n";
                            throw new ValidationException(err);
                        }
                        String err = "Cross reference between <group>:" + this.getName() + " and <group>:" + tempGroup.getName();
                        err = err + "\nCircular groups are disallowed.\n";
                        err = err + "That is, within the {particles} of a group there must not be at any depth a particle whose {term} is the group itself.\n";
                        throw new ValidationException(err);
                    }
                    continue block3;
                }
            }
        }
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }
}

