/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentModelGroupImpl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;

public class Group
extends Particle
implements ContentModelGroup,
Referable {
    private static final long serialVersionUID = 3133443973681261845L;
    private ContentModelGroup _contentModel = null;
    private String _name = null;
    private Order _order = Order.sequence;
    private String _id = null;
    private boolean _isModelGroupDefinition = false;
    private Structure _parent = null;

    public Group() {
        this(null);
    }

    public Group(String name) {
        this._name = name;
        this._contentModel = new ContentModelGroupImpl();
    }

    @Override
    public void addWildcard(Wildcard wildcard) throws SchemaException {
        if (wildcard.isAttributeWildcard()) {
            throw new SchemaException("only <any> should be add in a group.");
        }
        this._contentModel.addWildcard(wildcard);
    }

    @Override
    public boolean removeWildcard(Wildcard wildcard) {
        if (wildcard == null) {
            return false;
        }
        return this._contentModel.removeWildcard(wildcard);
    }

    public ContentModelGroup getContentModelGroup() {
        return this._contentModel;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public Order getOrder() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 10 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getOrder();
        }
        return this._order;
    }

    public Structure getParent() {
        return this._parent;
    }

    public void setIsModelGroupDefinition(boolean isModelGroupDefinition) {
        this._isModelGroupDefinition = isModelGroupDefinition;
    }

    public boolean isModelGroupDefinition() {
        return this._isModelGroupDefinition;
    }

    @Override
    public String getReferenceId() {
        if (this._name != null) {
            return "group:" + this._name;
        }
        return null;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setOrder(Order order) {
        this._order = order == null ? Order.all : order;
    }

    @Override
    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        this._contentModel.addElementDecl(elementDecl);
        elementDecl.setParent(this);
    }

    @Override
    public boolean removeElementDecl(ElementDecl element) {
        return this._contentModel.removeElementDecl(element);
    }

    @Override
    public void addGroup(Group group) throws SchemaException {
        this._contentModel.addGroup(group);
        group.setParent(this);
    }

    @Override
    public boolean removeGroup(Group group) {
        boolean result = this._contentModel.removeGroup(group);
        group.setParent(null);
        return result;
    }

    @Override
    public void addGroup(ModelGroup group) throws SchemaException {
        this._contentModel.addGroup(group);
        group.setParent(this);
    }

    @Override
    public boolean removeGroup(ModelGroup group) {
        boolean result = this._contentModel.removeGroup(group);
        group.setParent(null);
        return result;
    }

    @Override
    public Enumeration<Annotated> enumerate() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 10) {
            Group temp = (Group)particle;
            if (this.getMinOccurs() == 1 && this.getMaxOccurs() == 1 && temp.getMinOccurs() == 1 && temp.getMaxOccurs() == 1) {
                return temp.enumerate();
            }
        }
        return this._contentModel.enumerate();
    }

    @Override
    public ElementDecl getElementDecl(String name) {
        return this._contentModel.getElementDecl(name);
    }

    @Override
    public Particle getParticle(int index) {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 10 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getParticle(index);
        }
        return this._contentModel.getParticle(index);
    }

    @Override
    public int getParticleCount() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 10 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getParticleCount();
        }
        return this._contentModel.getParticleCount();
    }

    @Override
    public short getStructureType() {
        return 10;
    }

    public boolean hasAny() {
        boolean result = false;
        Enumeration enumeration = this._contentModel.enumerate();
        while (enumeration.hasMoreElements() && !result) {
            Structure struct = (Structure)enumeration.nextElement();
            switch (struct.getStructureType()) {
                case 8: {
                    break;
                }
                case 10: 
                case 16: {
                    result = ((Group)struct).hasAny();
                    break;
                }
                case 24: {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public void validate() throws ValidationException {
        if (this._order == Order.all) {
            if (this.getMaxOccurs() != 1) {
                String err = "Wrong maxOccurs value for a <all>:" + this.getMaxOccurs();
                err = err + "\n1 is the only possible value.";
                throw new ValidationException(err);
            }
            if (this.getMinOccurs() > 1) {
                String err = "Wrong minOccurs value for a <all>:" + this.getMinOccurs();
                err = err + "\n0 or 1 are the only possible values.";
                throw new ValidationException(err);
            }
        }
        Enumeration enumeration = this._contentModel.enumerate();
        while (enumeration.hasMoreElements()) {
            ((Structure)enumeration.nextElement()).validate();
        }
    }

    protected void setParent(Structure parent) {
        if (parent != null) {
            switch (parent.getStructureType()) {
                case 6: 
                case 10: 
                case 16: 
                case 19: {
                    break;
                }
                default: {
                    String error = "Invalid parent for group";
                    throw new IllegalArgumentException(error);
                }
            }
        }
        this._parent = parent;
    }

    @Override
    public boolean isEmptiable() {
        if (this.getMinOccurs() == 0) {
            return true;
        }
        boolean result = false;
        block0 : switch (this.getOrder()) {
            case choice: {
                result = false;
                Enumeration<Annotated> enumerate = this.enumerate();
                while (enumerate.hasMoreElements()) {
                    Particle p = (Particle)enumerate.nextElement();
                    if (!p.isEmptiable()) continue;
                    result = true;
                    break block0;
                }
                break;
            }
            case all: 
            case sequence: {
                result = true;
                Enumeration<Annotated> enumerate = this.enumerate();
                while (enumerate.hasMoreElements()) {
                    Particle p = (Particle)enumerate.nextElement();
                    if (p.isEmptiable()) continue;
                    result = false;
                    break block0;
                }
                break;
            }
        }
        return result;
    }
}

