/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.dtd;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.dtd.Attribute;
import org.exolab.castor.xml.dtd.ContentParticle;
import org.exolab.castor.xml.dtd.DTDException;
import org.exolab.castor.xml.dtd.DTDdocument;
import org.exolab.castor.xml.dtd.Element;
import org.exolab.castor.xml.dtd.GeneralEntity;
import org.exolab.castor.xml.dtd.parser.DTDInitialParser;
import org.exolab.castor.xml.dtd.parser.DTDParser;
import org.exolab.castor.xml.dtd.parser.InputCharStream;
import org.exolab.castor.xml.dtd.parser.ParseException;
import org.exolab.castor.xml.dtd.parser.TokenMgrError;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.FacetFactory;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.writer.SchemaWriter;
import org.xml.sax.SAXException;

public class Converter {
    private static final Log log = LogFactory.getLog(Converter.class);
    public static final String NAME_SPACE_PREFIX_KEY = "nameSpacePrefixKey";
    public static final String NAME_SPACE_KEY = "nameSpaceKey";
    public static final String DEFAULT_NAME_SPACE_PREFIX = "tns";
    public static final String DEFAULT_NAME_SPACE = "generated.castor.org";

    public static void main(String[] args) throws IOException, DTDException, SchemaException, SAXException {
        Map<String, String> nameSpaceMapTemp;
        StringBuffer header = new StringBuffer();
        header.append("\n");
        header.append("Converts a DTD to an XML schema.\n\n");
        header.append("   <DTD>: Name of the input DTD file.\n");
        header.append("   <XSD>: Name of the output XML schema file.\n");
        header.append("\n");
        header.append("Options:");
        Options options = new Options();
        OptionBuilder.withDescription((String)"target namespace of the XML schema generated");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"targetNamespace");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"[prefix:]uri");
        Option targetNamespace = OptionBuilder.create((String)DEFAULT_NAME_SPACE_PREFIX);
        OptionBuilder.withDescription((String)"xml namespace declarations");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withArgName((String)"[[prefix:]uri]*");
        Option xmlns = OptionBuilder.create((String)"xmlns");
        options.addOption(targetNamespace);
        options.addOption(xmlns);
        options.addOption("h", "help", false, "prints usage information");
        options.addOption("e", "encoding", false, "character encoding");
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (org.apache.commons.cli.ParseException e) {
            System.err.println("Parsing failed.  Reason: " + e.getMessage());
        }
        if (args.length < 2 || line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("org.exolab.castor.xml.dtd.Converter <DTD> <XSD>", header.toString(), options, "");
            return;
        }
        String encoding = "US-ASCII";
        String targetNameSpace = DEFAULT_NAME_SPACE;
        HashMap<String, String> nameSpaceMap = new HashMap<String, String>();
        if (line.hasOption(DEFAULT_NAME_SPACE_PREFIX)) {
            log.info((Object)"Found option -tns ...");
            nameSpaceMapTemp = Converter.parseNamespace(line.getOptionValue(DEFAULT_NAME_SPACE_PREFIX));
            targetNameSpace = nameSpaceMapTemp.get(NAME_SPACE_KEY);
            nameSpaceMap.put(nameSpaceMapTemp.get(NAME_SPACE_PREFIX_KEY), targetNameSpace);
        }
        if (line.hasOption("xmlns")) {
            log.info((Object)"Found option -xmlns ...");
            nameSpaceMapTemp = Converter.parseNamespace(line.getOptionValue("xmlns"));
            nameSpaceMap.put(nameSpaceMapTemp.get(NAME_SPACE_PREFIX_KEY), nameSpaceMapTemp.get(NAME_SPACE_KEY));
        }
        if (line.hasOption("encoding")) {
            log.info((Object)"Found option -encoding ...");
            String encodingValue = line.getOptionValue("encoding");
            encoding = encodingValue.equalsIgnoreCase("ascii") || args[2].equalsIgnoreCase("us-ascii") ? "US-ASCII" : (encodingValue.equalsIgnoreCase("utf-8") ? "UTF-8" : (encodingValue.equalsIgnoreCase("utf-16") ? "UTF-16" : encodingValue.toUpperCase()));
        }
        String inFile = args[0];
        String outFile = args[1];
        Converter convertor = new Converter();
        convertor.process(inFile, outFile, encoding, targetNameSpace, nameSpaceMap);
    }

    public void process(String dtdFile, String schemaFile, String encoding, String targetNamespace, Map<String, String> namespaces) throws SchemaException, DTDException, IOException, SAXException {
        FileInputStream inputStream = new FileInputStream(dtdFile);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encoding);
        FileOutputStream outputStream = new FileOutputStream(schemaFile);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, encoding);
        this.process(reader, writer, encoding, targetNamespace, namespaces);
    }

    public void process(Reader in, Writer out, String encoding, String targetNamespace, Map<String, String> namespaces) throws SchemaException, DTDException, IOException, SAXException {
        this.convertDTDtoSchema(in, out, targetNamespace, namespaces);
        in.close();
        out.close();
    }

    protected static Map<String, String> parseNamespace(String nameSpaceArg) {
        HashMap<String, String> nameSpaceMap = new HashMap<String, String>();
        if ("".equals(nameSpaceArg.substring("-tns=".length()))) {
            throw new RuntimeException("name space argument is emty, Spaces after '='? ");
        }
        String[] tnsToken = nameSpaceArg.substring("-tns=".length()).split(":", 2);
        if (Converter.isNameSpacePrefix(tnsToken[0])) {
            nameSpaceMap.put(NAME_SPACE_PREFIX_KEY, tnsToken[0]);
            nameSpaceMap.put(NAME_SPACE_KEY, tnsToken[1]);
        } else {
            nameSpaceMap.put(NAME_SPACE_KEY, nameSpaceArg.substring("-tns=".length()));
            nameSpaceMap.put(NAME_SPACE_PREFIX_KEY, DEFAULT_NAME_SPACE_PREFIX);
        }
        return nameSpaceMap;
    }

    protected static boolean isNameSpacePrefix(String nameSpacePrefix2test) {
        if (!nameSpacePrefix2test.matches("[a-z]*")) {
            return false;
        }
        return !nameSpacePrefix2test.matches("https?");
    }

    public void convertDTDtoSchema(Reader reader, Writer writer, String targetNameSpace, Map<String, String> nameSpaceMap) throws DTDException, SchemaException, IOException, SAXException {
        DTDdocument dtd = this.parseDTD(reader);
        Schema schema = this.convertDTDObjectToSchemaObject(dtd, targetNameSpace, nameSpaceMap);
        this.marshalSchema(schema, writer);
    }

    public void convertDTDtoSchema(Reader reader, Writer writer) throws DTDException, SchemaException, IOException, SAXException {
        String targetNameSpace = DEFAULT_NAME_SPACE;
        HashMap<String, String> nameSpaceMap = new HashMap<String, String>();
        this.convertDTDtoSchema(reader, writer, targetNameSpace, nameSpaceMap);
    }

    public DTDdocument parseDTD(Reader reader) throws DTDException {
        try {
            InputCharStream charStream = new InputCharStream(reader);
            DTDInitialParser initialParser = new DTDInitialParser(charStream);
            String intermedResult = initialParser.Input();
            StringReader strReader = new StringReader(intermedResult);
            charStream = new InputCharStream(strReader);
            DTDParser parser = new DTDParser(charStream);
            DTDdocument dtd = parser.Input();
            strReader.close();
            return dtd;
        }
        catch (TokenMgrError tme) {
            String msg = tme.getMessage();
            throw new DTDException("TokenMgrError" + (msg == null ? "" : ": " + msg));
        }
        catch (ParseException pe) {
            String msg = pe.getMessage();
            throw new DTDException("ParseException" + (msg == null ? "" : ": " + msg));
        }
    }

    public Schema convertDTDObjectToSchemaObject(DTDdocument dtd, String targetNamespace, Map nameSpaceMap) throws DTDException, SchemaException {
        Schema schema = new Schema();
        String name = dtd.getName();
        if (name != null && !name.equals("")) {
            schema.setId(name);
        }
        schema.setTargetNamespace(targetNamespace);
        for (String xmlns : nameSpaceMap.keySet()) {
            schema.addNamespace(xmlns, (String)nameSpaceMap.get(xmlns));
        }
        Enumeration dtdNotations = dtd.getNotations();
        while (dtdNotations.hasMoreElements()) {
            dtdNotations.nextElement();
        }
        Enumeration dtdGeneralEntities = dtd.getGeneralEntities();
        if (dtdGeneralEntities.hasMoreElements()) {
            Annotation annotation = new Annotation();
            while (dtdGeneralEntities.hasMoreElements()) {
                GeneralEntity ge = (GeneralEntity)dtdGeneralEntities.nextElement();
                Documentation documentation = new Documentation();
                String text = "General Entity Declaration";
                documentation.add(text);
                documentation.add(ge);
                annotation.addDocumentation(documentation);
            }
            schema.addAnnotation(annotation);
        }
        Enumeration dtdElements = dtd.getElements();
        while (dtdElements.hasMoreElements()) {
            Element dtdElement = (Element)dtdElements.nextElement();
            ElementDecl schemaElement = this.convertDTDElementToSchemaElement(dtdElement, schema);
            schema.addElementDecl(schemaElement);
        }
        return schema;
    }

    public ElementDecl convertDTDElementToSchemaElement(Element dtdElement, Schema schema) throws DTDException, SchemaException {
        String name = dtdElement.getName();
        if (name == null || name.equals("")) {
            String err = "DTD to Schema converter: a DTD element has no name.";
            throw new DTDException(err);
        }
        ElementDecl schemaElement = new ElementDecl(schema, name);
        ComplexType complexType = schema.createComplexType();
        ContentType contentType = null;
        Group group = null;
        Iterator mixedChildrenIterator = null;
        String elementRef = null;
        ElementDecl elem = null;
        if (dtdElement.isEmptyContent()) {
            contentType = ContentType.elemOnly;
        } else if (dtdElement.isAnyContent()) {
            contentType = ContentType.mixed;
            group = new Group();
            group.setOrder(Order.sequence);
            group.setMinOccurs(0);
            group.setMaxOccurs(-1);
            Wildcard any = new Wildcard(group);
            group.addWildcard(any);
            complexType.addGroup(group);
        } else if (dtdElement.isElemOnlyContent()) {
            contentType = ContentType.elemOnly;
            ContentParticle dtdContent = dtdElement.getContent();
            if (dtdContent == null) {
                String err = "DTD to Schema converter: element \"" + dtdElement.getName();
                err = err + "\" has no content.";
                throw new DTDException(err);
            }
            Particle content = null;
            try {
                content = this.convertContentParticle(dtdContent, schema);
            }
            catch (DTDException e) {
                String err = "DTD to Schema converter: content of DTD element \"" + dtdElement.getName();
                err = err + "\", represented by a Content Particle, is malformed.";
                throw new DTDException(err);
            }
            if (content instanceof ElementDecl) {
                group = new Group();
                group.setOrder(Order.sequence);
                group.addElementDecl((ElementDecl)content);
                complexType.addGroup(group);
            } else {
                complexType.addGroup((Group)content);
            }
        } else if (dtdElement.isMixedContent()) {
            contentType = ContentType.mixed;
            mixedChildrenIterator = dtdElement.getMixedContentChildren();
            if (mixedChildrenIterator != null && mixedChildrenIterator.hasNext()) {
                group = new Group();
                group.setOrder(Order.choice);
                group.setMinOccurs(0);
                group.setMaxOccurs(-1);
                while (mixedChildrenIterator.hasNext()) {
                    elementRef = (String)mixedChildrenIterator.next();
                    elem = new ElementDecl(schema);
                    elem.setReferenceName(elementRef);
                    group.addElementDecl(elem);
                }
                complexType.addGroup(group);
            }
        } else {
            String err = "DTD to Schema converter: content type of DTD element \"" + dtdElement.getName();
            err = err + "\" has not been specified.";
            throw new DTDException(err);
        }
        complexType.setContentType(contentType);
        Enumeration dtdAttributes = dtdElement.getAttributes();
        while (dtdAttributes.hasMoreElements()) {
            Attribute dtdAttribute = (Attribute)dtdAttributes.nextElement();
            AttributeDecl schemaAttribute = this.convertAttribute(dtdAttribute, schema);
            complexType.addAttributeDecl(schemaAttribute);
        }
        schemaElement.setType(complexType);
        return schemaElement;
    }

    public Particle convertContentParticle(ContentParticle dtdContent, Schema schema) throws DTDException, SchemaException {
        Particle returnValue;
        if (dtdContent.isReferenceType()) {
            ElementDecl elem = new ElementDecl(schema);
            elem.setReferenceName(dtdContent.getReference());
            returnValue = elem;
        } else if (dtdContent.isSeqType() || dtdContent.isChoiceType()) {
            Group group = new Group();
            if (dtdContent.isSeqType()) {
                group.setOrder(Order.sequence);
            } else {
                group.setOrder(Order.choice);
            }
            Enumeration children = dtdContent.getChildren();
            while (children.hasMoreElements()) {
                ContentParticle child = (ContentParticle)children.nextElement();
                Particle contentParticle = this.convertContentParticle(child, schema);
                if (contentParticle instanceof ElementDecl) {
                    group.addElementDecl((ElementDecl)contentParticle);
                    continue;
                }
                group.addGroup((Group)contentParticle);
            }
            returnValue = group;
        } else {
            throw new DTDException();
        }
        if (dtdContent.isOneOccurance()) {
            returnValue.setMinOccurs(1);
            returnValue.setMaxOccurs(1);
        } else if (dtdContent.isOneOrMoreOccurances()) {
            returnValue.setMinOccurs(1);
            returnValue.setMaxOccurs(-1);
        } else if (dtdContent.isZeroOrMoreOccurances()) {
            returnValue.setMinOccurs(0);
            returnValue.setMaxOccurs(-1);
        } else if (dtdContent.isZeroOrOneOccurance()) {
            returnValue.setMinOccurs(0);
            returnValue.setMaxOccurs(1);
        }
        return returnValue;
    }

    public AttributeDecl convertAttribute(Attribute dtdAttribute, Schema schema) throws DTDException {
        AttributeDecl schemaAttribute = new AttributeDecl(schema, dtdAttribute.getName());
        SimpleType type = null;
        if (dtdAttribute.isStringType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(1));
        } else if (dtdAttribute.isIDType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(25));
        } else if (dtdAttribute.isIDREFType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(26));
        } else if (dtdAttribute.isIDREFSType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(27));
        } else if (dtdAttribute.isENTITYType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(28));
        } else if (dtdAttribute.isENTITIESType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(29));
        } else if (dtdAttribute.isNMTOKENType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(30));
        } else if (dtdAttribute.isNMTOKENSType()) {
            type = schema.getSimpleType(schema.getBuiltInTypeName(31));
        } else if (dtdAttribute.isNOTATIONType()) {
            type = schema.createSimpleType(null, schema.getBuiltInTypeName(19), "restriction");
            Iterator values = dtdAttribute.getValues();
            FacetFactory facetFactory = FacetFactory.getInstance();
            while (values.hasNext()) {
                Facet facet = facetFactory.createFacet("enumeration", (String)values.next());
                facet.setOwningType(type);
                type.addFacet(facet);
            }
        } else if (dtdAttribute.isEnumerationType()) {
            type = schema.createSimpleType(null, schema.getBuiltInTypeName(30), "restriction");
            Iterator values = dtdAttribute.getValues();
            FacetFactory facetFactory = FacetFactory.getInstance();
            while (values.hasNext()) {
                Facet facet = facetFactory.createFacet("enumeration", (String)values.next());
                facet.setOwningType(type);
                type.addFacet(facet);
            }
        } else {
            String err = "DTD to Schema converter: DTD attribute \"" + dtdAttribute.getName();
            err = err + "\" has unspecified type.";
            throw new DTDException(err);
        }
        schemaAttribute.setSimpleType(type);
        if (dtdAttribute.isREQUIRED()) {
            schemaAttribute.setUse("required");
        } else if (dtdAttribute.isIMPLIED()) {
            schemaAttribute.setUse("optional");
        } else if (!dtdAttribute.isFIXED()) {
            schemaAttribute.setDefaultValue(dtdAttribute.getDefaultValue());
        }
        return schemaAttribute;
    }

    public void marshalSchema(Schema schema, Writer writer) throws IOException, SAXException {
        SchemaWriter sw = new SchemaWriter(writer);
        sw.write(schema);
    }
}

