/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.FacetList;
import org.exolab.castor.xml.schema.FacetListEnumerator;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleTypeReference;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleType
extends XMLType
implements Referable {
    public static final String FINAL_ALL = "#all";
    public static final String FINAL_LIST = "list";
    public static final String FINAL_UNION = "union";
    public static final String FINAL_RESTRICTION = "restriction";
    private FacetList _facets = new FacetList();
    private String _final = null;
    private Structure _parent = null;
    private int _typeCode = -1;
    private boolean _redefinition = false;

    public void addFacet(Facet facet) {
        if (facet == null) {
            return;
        }
        String name = facet.getName();
        if (name == null) {
            return;
        }
        this._facets.add(facet);
    }

    public Facet getFacet(String name) {
        Enumeration<Facet> facets = this.getFacets(name);
        if (facets == null) {
            return null;
        }
        return facets.nextElement();
    }

    public Enumeration<Facet> getFacets(String name) {
        FacetListEnumerator fle = null;
        SimpleType datatype = (SimpleType)this.getBaseType();
        if (datatype != null) {
            fle = (FacetListEnumerator)datatype.getFacets(name);
        }
        fle = new FacetListEnumerator(this._facets, fle);
        fle.setMask(name);
        return fle;
    }

    public Enumeration getFacets() {
        FacetListEnumerator fle = null;
        SimpleType datatype = (SimpleType)this.getBaseType();
        if (datatype != null) {
            fle = (FacetListEnumerator)datatype.getFacets();
        }
        fle = new FacetListEnumerator(this._facets, fle);
        return fle;
    }

    public String getFinal() {
        return this._final;
    }

    public Enumeration getLocalFacets() {
        if (this._facets == null) {
            return null;
        }
        return this._facets.enumerate();
    }

    public Enumeration getEffectiveFacets() {
        Enumeration localFacets = this.getLocalFacets();
        SimpleType baseType = (SimpleType)this.getBaseType();
        if (baseType == null) {
            return localFacets;
        }
        Enumeration effectiveBaseFacets = baseType.getEffectiveFacets();
        if (localFacets == null) {
            return effectiveBaseFacets;
        }
        FacetList filteredBaseFacets = new FacetList();
        block0: while (effectiveBaseFacets.hasMoreElements()) {
            Facet baseFacet = (Facet)effectiveBaseFacets.nextElement();
            for (int i = 0; i < this._facets.size(); ++i) {
                Facet localFacet = this._facets.get(i);
                if (localFacet.overridesBase(baseFacet)) continue block0;
            }
            filteredBaseFacets.add(baseFacet);
        }
        return new FacetListEnumerator(this._facets, (FacetListEnumerator)filteredBaseFacets.enumerate());
    }

    public SimpleType getBuiltInBaseType() {
        SimpleType base;
        for (base = this; base != null && !SimpleTypesFactory.isBuiltInType(base.getTypeCode()); base = (SimpleType)base.getBaseType()) {
        }
        return base;
    }

    public Structure getParent() {
        return this._parent;
    }

    @Override
    public String getReferenceId() {
        return "datatype:" + this.getName();
    }

    public boolean hasFacet(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this._facets.size(); ++i) {
            Facet facet = this._facets.get(i);
            if (!name.equals(facet.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isBuiltInType() {
        return SimpleTypesFactory.isBuiltInType(this._typeCode);
    }

    public boolean isNumericType() {
        if (!this.isBuiltInType()) {
            return ((SimpleType)this.getBaseType()).isNumericType();
        }
        return false;
    }

    public boolean isDateTimeType() {
        return SimpleTypesFactory.isDateTimeType(this._typeCode);
    }

    public boolean isRedefined() {
        return this._redefinition;
    }

    public void setRedefined() {
        this._redefinition = true;
    }

    public int getTypeCode() {
        return this._typeCode;
    }

    void setTypeCode(int code) {
        this._typeCode = code;
    }

    public Long getLength() {
        Facet lengthFacet = this.getFacet("length");
        if (lengthFacet == null) {
            return null;
        }
        try {
            return new Long(lengthFacet.toLong());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getMinLength() {
        Facet minLengthFacet = this.getFacet("minLength");
        if (minLengthFacet == null) {
            return null;
        }
        try {
            return new Long(minLengthFacet.toLong());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getMaxLength() {
        Facet maxLengthFacet = this.getFacet("maxLength");
        if (maxLengthFacet == null) {
            return null;
        }
        try {
            return new Long(maxLengthFacet.toLong());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean removeFacet(Facet facet) {
        if (facet == null) {
            return false;
        }
        return this._facets.remove(facet);
    }

    public boolean removeFacet(String name) {
        if (name == null) {
            return false;
        }
        for (int i = this._facets.size() - 1; i > 0; --i) {
            Facet facet = this._facets.get(i);
            if (!name.equals(facet.getName())) continue;
            this._facets.remove(i);
            return true;
        }
        return false;
    }

    public void setFinal(String finalValue) {
        if (!(finalValue == null || finalValue.equals(FINAL_ALL) || finalValue.equals(FINAL_UNION) || finalValue.equals(FINAL_LIST) || finalValue.equals(FINAL_RESTRICTION))) {
            String err = "The value '" + finalValue + "' is not a valid" + "value of the final property.";
            throw new IllegalArgumentException(err);
        }
        this._final = finalValue;
    }

    @Override
    public short getStructureType() {
        return 21;
    }

    @Override
    public void validate() throws ValidationException {
        Enumeration localFacets = this.getLocalFacets();
        SimpleType datatype = (SimpleType)this.getBaseType();
        if (localFacets != null) {
            while (localFacets.hasMoreElements()) {
                Facet facet = (Facet)localFacets.nextElement();
                Enumeration baseFacets = null;
                if (datatype != null) {
                    baseFacets = datatype.getFacets();
                }
                try {
                    facet.checkConstraints(this.getLocalFacets(), baseFacets);
                }
                catch (SchemaException e) {
                    throw new ValidationException("Facet validation failed for type '" + this.getName() + "'", (Throwable)((Object)e));
                }
            }
        }
    }

    protected SimpleType createReference(String name) {
        return new SimpleTypeReference(this.getSchema(), name);
    }

    protected static SimpleType resolveReference(SimpleType simpleType) {
        return (SimpleType)simpleType.getType();
    }

    @Override
    protected void setParent(Structure parent) {
        this._parent = parent;
    }

    protected void copyFacets(SimpleType target) {
        target._facets.add(this._facets);
    }

    public int getNumberOfFacets(String name) {
        int counter = 0;
        Enumeration enumerator = this.getFacets();
        while (enumerator.hasMoreElements()) {
            Facet facet = (Facet)enumerator.nextElement();
            if (!facet.getName().equals(name)) continue;
            ++counter;
        }
        return counter;
    }
}

