/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xmlctf.xmldiff.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.castor.xmlctf.xmldiff.xml.Location;
import org.castor.xmlctf.xmldiff.xml.nodes.Attribute;
import org.castor.xmlctf.xmldiff.xml.nodes.Element;
import org.castor.xmlctf.xmldiff.xml.nodes.Namespace;
import org.castor.xmlctf.xmldiff.xml.nodes.ParentNode;
import org.castor.xmlctf.xmldiff.xml.nodes.ProcessingInstruction;
import org.castor.xmlctf.xmldiff.xml.nodes.Root;
import org.castor.xmlctf.xmldiff.xml.nodes.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLContentHandler
implements ContentHandler {
    private final Stack _nodeStack = new Stack();
    private final Root _root = new Root();
    private Locator _locator = null;
    private ParentNode _currentNode = null;
    private Map _prefixes = new HashMap();

    public XMLContentHandler() {
        this._nodeStack.push(this._root);
        this._currentNode = this._root;
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this._currentNode.addChild(new Text(new String(chars, start, length)));
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        String uriOfElement;
        String localName = name;
        int idx = qName.indexOf(58);
        String prefix = idx >= 0 ? qName.substring(0, idx) : "";
        String uriOfPrefix = this._currentNode.getNamespaceURI(prefix);
        if (uriOfPrefix == null ^ (uriOfElement = this._currentNode.getNamespaceURI()) == null || uriOfPrefix != null && !uriOfPrefix.equals(uriOfElement)) {
            throw new SAXException("In Element " + qName + ", URI of prefix " + uriOfPrefix + " does not match URI of Element " + uriOfElement);
        }
        String cName = this._currentNode.getLocalName();
        if (!cName.equals(localName)) {
            String err = "Element end tag mismatch:  expecting </" + cName + "> but recieved </" + localName + ">";
            throw new SAXException(err);
        }
        this._nodeStack.pop();
        this._currentNode = (ParentNode)this._nodeStack.peek();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this._prefixes.remove(prefix);
    }

    public Root getRoot() {
        return this._root;
    }

    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction pi = new ProcessingInstruction(target, data);
        this._currentNode.addChild(pi);
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void skippedEntity(String name) {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        String namespace;
        String localName;
        String prefix;
        if (qName == null) {
            throw new SAXException("No Element name given");
        }
        int idx = qName.indexOf(58);
        if (idx >= 0) {
            prefix = qName.substring(0, idx);
            localName = qName.substring(idx + 1);
        } else {
            prefix = "";
            localName = qName;
        }
        Element element = new Element(null, localName);
        if (this._locator != null) {
            element.setLocation(new Location(this._locator));
        }
        this._currentNode.addChild(element);
        for (Map.Entry me : this._prefixes.entrySet()) {
            element.addNamespace(new Namespace((String)me.getKey(), (String)me.getValue()));
        }
        if (atts != null && atts.getLength() > 0) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getQName(i);
                String ns = null;
                idx = attName.indexOf(58);
                if (idx > 0) {
                    ns = element.getNamespaceURI(attName.substring(0, idx));
                    attName = attName.substring(idx + 1);
                }
                element.addAttribute(new Attribute(ns, attName, atts.getValue(i)));
            }
        }
        if (prefix != null && prefix.length() > 0) {
            namespace = element.getNamespaceURI(prefix);
            element.setNamespace(namespace);
        } else {
            namespace = element.getNamespaceURI("");
            if (namespace != null) {
                element.setNamespace(namespace);
            }
        }
        this._nodeStack.push(element);
        this._currentNode = element;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this._prefixes.put(prefix, uri);
    }
}

