/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xmlctf.xmldiff;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.castor.xmlctf.xmldiff.xml.XMLFileReader;
import org.castor.xmlctf.xmldiff.xml.nodes.Attribute;
import org.castor.xmlctf.xmldiff.xml.nodes.Element;
import org.castor.xmlctf.xmldiff.xml.nodes.ParentNode;
import org.castor.xmlctf.xmldiff.xml.nodes.Root;
import org.castor.xmlctf.xmldiff.xml.nodes.XMLNode;

public class XMLDiff {
    private static final String XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private final String _file1;
    private final String _file2;
    private final PrintWriter _pw = new PrintWriter(System.out, true);
    private boolean _strictChildOrder = false;
    private boolean _print = true;
    private boolean _header = true;

    public XMLDiff(String file1, String file2) {
        if (file1 == null) {
            String err = "The argument 'file1' may not be null.";
            throw new IllegalArgumentException(err);
        }
        if (file2 == null) {
            String err = "The argument 'file2' may not be null.";
            throw new IllegalArgumentException(err);
        }
        this._file1 = file1;
        this._file2 = file2;
    }

    public int compare() throws IOException {
        XMLFileReader reader1 = new XMLFileReader(this._file1);
        XMLNode node1 = reader1.read();
        XMLFileReader reader2 = new XMLFileReader(this._file2);
        XMLNode node2 = reader2.read();
        return this.compareNodes(node1, node2);
    }

    private int compareNodes(XMLNode node1, XMLNode node2) {
        String ns2;
        if (!this.hasSameType(node1, node2)) {
            if (this._print) {
                this._pw.println("Types differ: <" + node1.getLocalName() + "> and <" + node2.getLocalName() + "> for" + node1.getNodeLocation());
            }
            return 1;
        }
        int diffCount = 0;
        String ns1 = node1.getNamespaceURI();
        if (!this.compareTextNullEqualsEmpty(ns1, ns2 = node2.getNamespaceURI())) {
            if (this._print) {
                this._pw.println("Namespaces differ: ('" + ns1 + "' != '" + ns2 + "') for " + node1.getNodeLocation());
            }
            ++diffCount;
        }
        String name1 = node1.getLocalName();
        String name2 = node2.getLocalName();
        if (name1 == null && name2 != null) {
            if (this._print) {
                this._pw.println("Names differ: null vs. <" + name2 + "> for " + node1.getNodeLocation());
            }
            return ++diffCount;
        }
        if (name2 == null && name1 != null) {
            if (this._print) {
                this._pw.println("Names differ: <" + name1 + "> vs null for " + node1.getNodeLocation());
            }
            return ++diffCount;
        }
        if (name1 != null && !name1.equals(name2)) {
            if (this._print) {
                this._pw.println("Names differ: <" + name1 + "> != <" + name2 + "> for " + node1.getNodeLocation());
            }
            return ++diffCount;
        }
        switch (node1.getNodeType()) {
            case 1: {
                diffCount += this.compareElementsStrictOrder((Root)node1, (Root)node2);
                break;
            }
            case 2: {
                diffCount += this.compareElements((Element)node1, (Element)node2);
                break;
            }
            case 3: {
                diffCount += this.compareStringValues(node1, node2);
                break;
            }
            case 4: {
                diffCount += this.compareStringValues(node1, node2);
                break;
            }
            case 5: {
                break;
            }
            default: {
                System.out.println("Unexpected node type in XMLDiff: " + node1.getNodeType());
            }
        }
        return diffCount;
    }

    private int compareStringValues(XMLNode node1, XMLNode node2) {
        if (this.compareText(node1.getStringValue(), node2.getStringValue())) {
            return 0;
        }
        if (this._print) {
            this._pw.println();
            this.printLocationInfo(node1, node2);
            this.printText("- ", node1.getStringValue());
            this._pw.println();
            this.printText("+ ", node2.getStringValue());
        }
        return 1;
    }

    private int compareAttributes(Element node1, Element node2) {
        int diffCount = 0;
        Iterator i = node1.getAttributeIterator();
        while (i.hasNext()) {
            Attribute attr1 = (Attribute)i.next();
            String attValue2 = node2.getAttribute(attr1.getNamespaceURI(), attr1.getLocalName());
            if (attValue2 == null) {
                if (this.missingattributeIsIgnorable(attr1)) continue;
                this.printElementChangeBlock(node1, node2, "Attribute '" + attr1.getNodeLocation() + "' does not exist in the second document.");
                ++diffCount;
                continue;
            }
            String attValue1 = attr1.getStringValue();
            if (this.compareTextLikeQName(node1, node2, attValue1, attValue2)) continue;
            this.printElementChangeBlock(node1, node2, "Attribute '" + attr1.getNodeLocation() + "' values are different.");
            ++diffCount;
        }
        i = node2.getAttributeIterator();
        while (i.hasNext()) {
            Attribute attr2 = (Attribute)i.next();
            if (node1.getAttribute(attr2.getNamespaceURI(), attr2.getLocalName()) != null || this.missingattributeIsIgnorable(attr2)) continue;
            this.printElementChangeBlock(node1, node2, "Attribute '" + attr2.getNodeLocation() + "' does not exist in the first document.");
            ++diffCount;
        }
        return diffCount;
    }

    private boolean missingattributeIsIgnorable(Attribute attr) {
        String name = attr.getLocalName();
        String ns = attr.getNamespaceURI();
        if (ns == null) {
            ns = "";
        }
        if (name.equals("noNamespaceSchemaLocation") && ns.equals(XMLSCHEMA_INSTANCE)) {
            return true;
        }
        return name.equals("schemaLocation") && ns.equals(XMLSCHEMA_INSTANCE);
    }

    private boolean compareTextLikeQName(XMLNode node1, XMLNode node2, String attValue1, String attValue2) {
        String prefix2;
        String value2;
        String prefix1;
        String value1;
        if (this.compareText(attValue1, attValue2)) {
            return true;
        }
        int idx1 = attValue1.indexOf(58);
        int idx2 = attValue2.indexOf(58);
        if (idx1 < 0 && idx2 < 0) {
            return false;
        }
        if (idx1 >= 0) {
            value1 = attValue1.substring(idx1 + 1);
            prefix1 = attValue1.substring(0, idx1);
        } else {
            value1 = attValue1;
            prefix1 = "";
        }
        if (idx2 >= 0) {
            value2 = attValue2.substring(idx2 + 1);
            prefix2 = attValue2.substring(0, idx2);
        } else {
            value2 = attValue2;
            prefix2 = "";
        }
        return this.compareText(value1, value2) && this.compareTextNullEqualsEmpty(node1.getNamespaceURI(prefix1), node2.getNamespaceURI(prefix2));
    }

    private int compareElements(Element node1, Element node2) {
        int diffCount = this.compareAttributes(node1, node2);
        diffCount = this._strictChildOrder ? (diffCount += this.compareElementsStrictOrder(node1, node2)) : (diffCount += this.compareElementsLooseOrder(node1, node2));
        return diffCount;
    }

    private int compareElementsStrictOrder(ParentNode node1, ParentNode node2) {
        XMLNode child1;
        int diffCount = 0;
        Iterator i1 = node1.getChildIterator();
        Iterator i2 = node2.getChildIterator();
        if (i1.hasNext() && i2.hasNext()) {
            child1 = (XMLNode)i1.next();
            XMLNode child2 = (XMLNode)i2.next();
            while (child1 != null && child2 != null) {
                if (this.nodeIsIgnorableText(child1)) {
                    if (!i1.hasNext()) break;
                    child1 = (XMLNode)i1.next();
                    continue;
                }
                if (this.nodeIsIgnorableText(child2)) {
                    if (!i2.hasNext()) break;
                    child2 = (XMLNode)i2.next();
                    continue;
                }
                diffCount += this.compareNodes(child1, child2);
                if (!i1.hasNext() || !i2.hasNext()) break;
                child1 = (XMLNode)i1.next();
                child2 = (XMLNode)i2.next();
            }
        }
        while (i1.hasNext()) {
            child1 = (XMLNode)i1.next();
            if (this.nodeIsIgnorableText(child1)) continue;
            if (this._print) {
                this.printLocationInfo(child1, null);
                this._pw.println("- ");
            }
            ++diffCount;
        }
        while (i2.hasNext()) {
            XMLNode child2 = (XMLNode)i2.next();
            if (this.nodeIsIgnorableText(child2)) continue;
            if (this._print) {
                this.printLocationInfo(child2, null);
                this._pw.println("- ");
            }
            ++diffCount;
        }
        return diffCount;
    }

    private int compareElementsLooseOrder(Element node1, Element node2) {
        int diffCount = 0;
        LinkedList used = new LinkedList();
        Iterator i1 = node1.getChildIterator();
        while (i1.hasNext()) {
            XMLNode child1 = (XMLNode)i1.next();
            if (this.nodeIsIgnorableText(child1) || this.foundExactMatch(node2, child1, used)) continue;
            if (this._print) {
                diffCount += this.closestMatchDifference(node2, child1, used);
                continue;
            }
            ++diffCount;
        }
        Iterator i2 = node2.getChildIterator();
        while (i2.hasNext()) {
            XMLNode child2 = (XMLNode)i2.next();
            if (this.nodeIsIgnorableText(child2) || used.contains(child2)) continue;
            if (this._print) {
                this._pw.println("Extra child node: " + child2.getNodeLocation());
            }
            ++diffCount;
        }
        return diffCount;
    }

    private boolean foundExactMatch(Element parent, XMLNode target, List usedList) {
        boolean previousPrint = this._print;
        this._print = false;
        boolean found = false;
        Iterator i2 = parent.getChildIterator();
        while (i2.hasNext()) {
            XMLNode child2 = (XMLNode)i2.next();
            if (usedList.contains(child2) || this.compareNodes(target, child2) != 0) continue;
            usedList.add(child2);
            found = true;
            break;
        }
        this._print = previousPrint;
        return found;
    }

    private int closestMatchDifference(Element parent, XMLNode target, List usedList) {
        Iterator i2 = parent.getChildIterator();
        while (i2.hasNext()) {
            XMLNode child2 = (XMLNode)i2.next();
            if (usedList.contains(child2) || !this.hasSameType(target, child2) || !this.hasSameName(target, child2)) continue;
            usedList.add(child2);
            return this.compareNodes(target, child2);
        }
        this._pw.println("Missing child node: " + target.getNodeLocation() + " for " + target.getNodeLocation());
        return 1;
    }

    private boolean nodeIsIgnorableText(XMLNode child) {
        return child.getNodeType() == 4 && this.compareText(child.getStringValue(), "");
    }

    private boolean compareText(String s1, String s2) {
        if (s1.equals(s2)) {
            return true;
        }
        StringTokenizer st1 = new StringTokenizer(s1);
        StringTokenizer st2 = new StringTokenizer(s2);
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            if (st1.nextToken().equals(st2.nextToken())) continue;
            return false;
        }
        return !st1.hasMoreTokens() && !st2.hasMoreTokens();
    }

    private boolean compareTextNullEqualsEmpty(String one, String two) {
        String text1 = one == null ? "" : one;
        String text2 = two == null ? "" : two;
        return text1.equals(text2);
    }

    private boolean hasSameName(XMLNode node1, XMLNode node2) {
        String name1 = node1.getLocalName();
        String name2 = node2.getLocalName();
        if (name1 == null) {
            return name2 == null;
        }
        return name1.equals(name2);
    }

    private boolean hasSameType(XMLNode node1, XMLNode node2) {
        return node1.getNodeType() == node2.getNodeType();
    }

    private void printLocationInfo(XMLNode node1, XMLNode node2) {
        if (this._header) {
            this._header = false;
            this._pw.println("--- " + this._file1);
            this._pw.println("+++ " + this._file2);
        }
        this._pw.print("@@ -");
        this._pw.print(node1.getNodeLocation());
        this._pw.print(" +");
        this._pw.print(node2.getNodeLocation());
        this._pw.println(" @@");
    }

    private void printElementChangeBlock(Element node1, Element node2, String msg) {
        if (this._print) {
            this._pw.print("- ");
            this.printElement(node1);
            this._pw.print("+ ");
            this.printElement(node2);
            if (msg != null) {
                this._pw.println(msg);
            }
        }
    }

    private void printElement(Element node) {
        this._pw.print('<' + node.getLocalName());
        Iterator i = node.getAttributeIterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            this._pw.print(' ');
            this._pw.print(attr.getLocalName());
            this._pw.print("=\"");
            this._pw.print(attr.getStringValue());
            this._pw.print("\"");
        }
        this._pw.println('>');
    }

    private void printText(String prefix, String text) {
        if (text == null) {
            this._pw.println(prefix);
            return;
        }
        int idx = 0;
        while ((idx = text.indexOf(10)) >= 0) {
            this._pw.print(prefix);
            this._pw.println(text.substring(0, idx));
            text = text.substring(idx + 1);
        }
        this._pw.print(prefix);
        this._pw.println(text);
    }
}

