/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.castor.maven.xmlctf;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Test;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.castor.xmlctf.TestCaseAggregator;

public abstract class AbstractTestSuiteMojo
extends AbstractMojo {
    private static final String TEST_ROOT_PROPERTY = "castor.xmlctf.root";
    private String outputRoot;
    private String testRoot;
    private String pathToTools;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] classpathEntries;
        boolean skipMavenTests = Boolean.getBoolean("maven.test.skip");
        skipMavenTests |= Boolean.getBoolean("skipTests");
        if (skipMavenTests |= Boolean.getBoolean("skipITs")) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Skipping XML CTF tests as per configuration.");
            }
            return;
        }
        this.getLog().info((CharSequence)"Starting Castor Mastertestsuite");
        String testRootToUse = System.getProperty(TEST_ROOT_PROPERTY);
        if (testRootToUse == null) {
            testRootToUse = this.testRoot;
        }
        if (testRootToUse == null) {
            throw new MojoExecutionException("No testroot found, please specify property -Dcastor.xmlctf.root");
        }
        if (testRootToUse.equals(".") || testRootToUse.equals("..")) {
            File tmp = new File(testRootToUse);
            try {
                testRootToUse = tmp.getCanonicalPath();
            }
            catch (IOException iox) {}
        } else if (testRootToUse.startsWith("./") || testRootToUse.startsWith(".\\")) {
            this.testRoot = this.testRoot.substring(2);
        }
        File testRootFile = new File(testRootToUse);
        this.getLog().info((CharSequence)("using testRoot: " + testRootFile.getAbsolutePath()));
        if (!testRootFile.exists()) {
            throw new MojoExecutionException("Root not found:" + this.testRoot);
        }
        String dirSeparator = System.getProperty("file.separator");
        String classpath = "";
        Iterator iter = this.project.getArtifacts().iterator();
        while (iter.hasNext()) {
            classpath = classpath + ((Artifact)iter.next()).getFile().getAbsolutePath();
            classpath = classpath + System.getProperty("path.separator");
        }
        classpath = classpath + this.project.getBuild().getTestOutputDirectory();
        classpath = classpath + System.getProperty("path.separator");
        if (this.pathToTools != null) {
            classpath = classpath + this.pathToTools + System.getProperty("path.separator");
        } else {
            classpath = classpath + System.getProperty("java.home") + dirSeparator + "lib" + dirSeparator + "tools.jar";
            classpath = classpath + System.getProperty("path.separator");
            classpath = classpath + System.getProperty("java.home") + dirSeparator + ".." + dirSeparator + "lib" + dirSeparator + "tools.jar";
            classpath = classpath + System.getProperty("path.separator");
        }
        System.setProperty("xmlctf.classpath.override", classpath);
        if (this.getLog().isDebugEnabled()) {
            System.setProperty("org.exolab.castor.tests.Verbose", "true");
            System.setProperty("org.exolab.castor.tests.printStack", "true");
        }
        this.getLog().info((CharSequence)("classpath for sourcegenerator is: " + classpath));
        for (String classpathEntry : classpathEntries = classpath.split(";")) {
            this.getLog().info((CharSequence)classpathEntry);
        }
        TestCaseAggregator aggregator = new TestCaseAggregator(testRootFile, this.outputRoot);
        this.runJUnit(aggregator.suite());
    }

    public abstract void runJUnit(Test var1) throws MojoExecutionException;
}

