/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import org.apache.commons.lang.StringUtils;
import org.castor.xml.JavaNaming;
import org.exolab.castor.builder.AnnotationBuilder;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.factory.FieldMemberAndAccessorFactory;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.builder.types.XSType;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JCollectionType;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class CollectionMemberAndAccessorFactory
extends FieldMemberAndAccessorFactory {
    public CollectionMemberAndAccessorFactory(JavaNaming naming) {
        super(naming);
    }

    @Override
    public void generateInitializerCode(FieldInfo fieldInfo, JSourceCode sourceCode) {
        CollectionInfo collectionInfo = (CollectionInfo)fieldInfo;
        sourceCode.add("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(" = new ");
        JType jType = collectionInfo.getXSList().getJType();
        sourceCode.append(((JCollectionType)jType).getInstanceName());
        sourceCode.append("();");
        if (!StringUtils.isEmpty((String)fieldInfo.getDefaultValue())) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(fieldInfo.getName());
            buffer.append(".add(");
            buffer.append(fieldInfo.getDefaultValue());
            buffer.append(");");
            sourceCode.add(buffer.toString());
        }
    }

    @Override
    public final void createAccessMethods(FieldInfo fieldInfo, JClass jClass, boolean useJava50, AnnotationBuilder[] annotationBuilders) {
        CollectionInfo collectionInfo = (CollectionInfo)fieldInfo;
        this.createAddAndRemoveMethods(collectionInfo, jClass);
        this.createGetAndSetMethods(collectionInfo, jClass, useJava50, annotationBuilders);
        this.createGetCountMethod(collectionInfo, jClass);
        this.createCollectionIterationMethods(collectionInfo, jClass, useJava50);
    }

    protected void createAddMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod(fieldInfo.getWriteMethodName());
        method.addException(SGTypes.INDEX_OUT_OF_BOUNDS_EXCEPTION, "if the index given is outside the bounds of the collection");
        JParameter parameter = new JParameter(fieldInfo.getContentType().getJType(), fieldInfo.getContentName());
        method.addParameter(parameter);
        JSourceCode sourceCode = method.getSourceCode();
        this.addMaxSizeCheck(fieldInfo, method.getName(), sourceCode);
        sourceCode.add("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".addElement(");
        sourceCode.append(fieldInfo.getContentType().createToJavaObjectCode(parameter.getName()));
        sourceCode.append(");");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createBoundPropertyCode(CollectionInfo fieldInfo, JSourceCode sourceCode) {
        sourceCode.add("notifyPropertyChangeListeners(\"");
        String fieldName = fieldInfo.getName();
        if (fieldName.startsWith("_")) {
            sourceCode.append(fieldName.substring(1));
        } else {
            sourceCode.append(fieldName);
        }
        sourceCode.append("\", null, ");
        sourceCode.append(fieldName);
        sourceCode.append(");");
    }

    protected void createEnumerateMethod(CollectionInfo fieldInfo, JClass jClass, boolean useJava50) {
        JMethod method = new JMethod("enumerate" + fieldInfo.getMethodSuffix(), SGTypes.createEnumeration(fieldInfo.getContentType().getJType(), useJava50, true), "an Enumeration over all " + fieldInfo.getContentType().getJType() + " elements");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("return this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".elements();");
        jClass.addMethod(method);
    }

    private boolean createExtraMethods(CollectionInfo fieldInfo) {
        return fieldInfo.isExtraMethods();
    }

    private void createGetAsArrayMethod(CollectionInfo fieldInfo, JClass jClass, boolean useJava50, AnnotationBuilder[] annotationBuilders) {
        JType baseType = fieldInfo.getContentType().getJType();
        JArrayType arrayType = new JArrayType(baseType, useJava50);
        JMethod method = new JMethod(fieldInfo.getReadMethodName(), arrayType, "this collection as an Array");
        JSourceCode sourceCode = method.getSourceCode();
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Returns the contents of the collection in an Array.  ");
        if (!baseType.isPrimitive()) {
            comment.appendComment("<p>");
            comment.appendComment("Note:  Just in case the collection contents are changing in ");
            comment.appendComment("another thread, we pass a 0-length Array of the correct type ");
            comment.appendComment("into the API call.  This way we <i>know</i> that the Array ");
            comment.appendComment("returned is of exactly the correct length.");
            String baseTypeName = baseType.toString();
            if (baseType.isArray()) {
                sourceCode.add(String.valueOf(((Object)arrayType).toString()) + " array = new ");
                sourceCode.append(String.valueOf(baseTypeName.substring(0, baseTypeName.length() - 2)) + "[0][];");
            } else {
                sourceCode.add(String.valueOf(((Object)arrayType).toString()) + " array = new ");
                sourceCode.append(String.valueOf(baseTypeName) + "[0];");
            }
            sourceCode.add("return ");
            if (!useJava50) {
                sourceCode.add("(");
                sourceCode.add(((Object)arrayType).toString());
                sourceCode.add(") ");
            }
            sourceCode.append("this." + fieldInfo.getName() + ".toArray(array);");
        } else {
            sourceCode.add("int size = this.");
            sourceCode.append(fieldInfo.getName());
            sourceCode.append(".size();");
            sourceCode.add(((Object)arrayType).toString());
            sourceCode.append(" array = new ");
            int brackets = ((Object)arrayType).toString().indexOf("[]");
            sourceCode.append(((Object)arrayType).toString().substring(0, brackets));
            sourceCode.append("[size]");
            sourceCode.append(";");
            sourceCode.add("java.util.Iterator iter = " + fieldInfo.getName() + ".iterator();");
            String value = "iter.next()";
            sourceCode.add("for (int index = 0; index < size; index++) {");
            sourceCode.indent();
            sourceCode.add("array[index] = ");
            if (fieldInfo.getContentType().getType() == 0) {
                sourceCode.append("(");
                sourceCode.append(arrayType.getName());
                sourceCode.append(") ");
                sourceCode.append(value);
            } else {
                sourceCode.append(fieldInfo.getContentType().createFromJavaObjectCode(value));
            }
            sourceCode.append(";");
            sourceCode.unindent();
            sourceCode.add("}");
            sourceCode.add("return array;");
        }
        int i = 0;
        while (i < annotationBuilders.length) {
            AnnotationBuilder annotationBuilder = annotationBuilders[i];
            annotationBuilder.addFieldGetterAnnotations(fieldInfo, method);
            ++i;
        }
        jClass.addMethod(method);
    }

    private void createGetAsReferenceMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod(String.valueOf(fieldInfo.getReadMethodName()) + fieldInfo.getReferenceMethodSuffix(), fieldInfo.getXSList().getJType(), "a reference to the Vector backing this class");
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Returns a reference to '");
        comment.appendComment(fieldInfo.getName());
        comment.appendComment("'. No type checking is performed on any ");
        comment.appendComment("modifications to the Vector.");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("return this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(";");
        jClass.addMethod(method);
    }

    protected void createGetByIndexMethod(CollectionInfo fieldInfo, JClass jClass, boolean useJava50) {
        XSType contentType = fieldInfo.getContentType();
        JMethod method = new JMethod(fieldInfo.getReadMethodName(), contentType.getJType(), "the value of the " + contentType.getJType().toString() + " at the given index");
        method.addException(SGTypes.INDEX_OUT_OF_BOUNDS_EXCEPTION, "if the index given is outside the bounds of the collection");
        method.addParameter(new JParameter(JType.INT, "index"));
        JSourceCode sourceCode = method.getSourceCode();
        this.addIndexCheck(fieldInfo, sourceCode, method.getName());
        String value = String.valueOf(fieldInfo.getName()) + ".get(index)";
        sourceCode.add("return ");
        if (contentType.getType() == 0) {
            if (!useJava50) {
                sourceCode.append("(");
                sourceCode.append(method.getReturnType().toString());
                sourceCode.append(") ");
            }
            sourceCode.append(value);
        } else {
            sourceCode.append(contentType.createFromJavaObjectCode(value));
        }
        sourceCode.append(";");
        jClass.addMethod(method);
    }

    private void createAddAndRemoveMethods(CollectionInfo fieldInfo, JClass jClass) {
        this.createAddMethod(fieldInfo, jClass);
        this.createAddByIndexMethod(fieldInfo, jClass);
        this.createRemoveObjectMethod(fieldInfo, jClass);
        this.createRemoveByIndexMethod(fieldInfo, jClass);
        this.createRemoveAllMethod(fieldInfo, jClass);
    }

    private void createGetAndSetMethods(CollectionInfo fieldInfo, JClass jClass, boolean useJava50, AnnotationBuilder[] annotationBuilders) {
        this.createGetByIndexMethod(fieldInfo, jClass, useJava50);
        this.createGetAsArrayMethod(fieldInfo, jClass, useJava50, annotationBuilders);
        if (this.createExtraMethods(fieldInfo)) {
            this.createGetAsReferenceMethod(fieldInfo, jClass);
        }
        this.createSetByIndexMethod(fieldInfo, jClass);
        this.createSetAsArrayMethod(fieldInfo, jClass, useJava50);
        if (this.createExtraMethods(fieldInfo)) {
            this.createSetAsCopyMethod(fieldInfo, jClass);
            this.createSetAsReferenceMethod(fieldInfo, jClass, useJava50);
        }
    }

    private void createGetCountMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod(String.valueOf(fieldInfo.getReadMethodName()) + "Count", JType.INT, "the size of this collection");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("return this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".size();");
        jClass.addMethod(method);
    }

    protected void createCollectionIterationMethods(CollectionInfo fieldInfo, JClass jClass, boolean useJava50) {
        this.createEnumerateMethod(fieldInfo, jClass, useJava50);
    }

    protected void createAddByIndexMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod(fieldInfo.getWriteMethodName());
        method.addException(SGTypes.INDEX_OUT_OF_BOUNDS_EXCEPTION, "if the index given is outside the bounds of the collection");
        method.addParameter(new JParameter(JType.INT, "index"));
        JParameter parameter = new JParameter(fieldInfo.getContentType().getJType(), fieldInfo.getContentName());
        method.addParameter(parameter);
        JSourceCode sourceCode = method.getSourceCode();
        this.addMaxSizeCheck(fieldInfo, method.getName(), sourceCode);
        sourceCode.add("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".add(index, ");
        sourceCode.append(fieldInfo.getContentType().createToJavaObjectCode(parameter.getName()));
        sourceCode.append(");");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createIteratorMethod(CollectionInfo fieldInfo, JClass jClass, boolean useJava50) {
        JMethod method = new JMethod("iterate" + fieldInfo.getMethodSuffix(), SGTypes.createIterator(fieldInfo.getContentType().getJType(), useJava50, true), "an Iterator over all possible elements in this collection");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("return this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".iterator();");
        jClass.addMethod(method);
    }

    private void createRemoveAllMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod("removeAll" + fieldInfo.getMethodSuffix());
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".clear();");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createRemoveByIndexMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod("remove" + fieldInfo.getMethodSuffix() + "At", fieldInfo.getContentType().getJType(), "the element removed from the collection");
        method.addParameter(new JParameter(JType.INT, "index"));
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("java.lang.Object obj = this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".remove(index);");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        sourceCode.add("return ");
        if (fieldInfo.getContentType().getType() == 0) {
            sourceCode.append("(");
            sourceCode.append(method.getReturnType().getName());
            sourceCode.append(") obj;");
        } else {
            sourceCode.append(fieldInfo.getContentType().createFromJavaObjectCode("obj"));
            sourceCode.append(";");
        }
        jClass.addMethod(method);
    }

    private void createRemoveObjectMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod("remove" + fieldInfo.getMethodSuffix(), JType.BOOLEAN, "true if the object was removed from the collection.");
        JParameter parameter = new JParameter(fieldInfo.getContentType().getJType(), fieldInfo.getContentName());
        method.addParameter(parameter);
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("boolean removed = ");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".remove(");
        sourceCode.append(fieldInfo.getContentType().createToJavaObjectCode(parameter.getName()));
        sourceCode.append(");");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        sourceCode.add("return removed;");
        jClass.addMethod(method);
    }

    private void createSetAsArrayMethod(CollectionInfo fieldInfo, JClass jClass, boolean useJava50) {
        JMethod method = new JMethod("set" + fieldInfo.getMethodSuffix());
        JParameter parameter = new JParameter(new JArrayType(fieldInfo.getContentType().getJType(), useJava50), String.valueOf(fieldInfo.getContentName()) + "Array");
        method.addParameter(parameter);
        JSourceCode sourceCode = method.getSourceCode();
        String index = "i";
        if (parameter.getName().equals(index)) {
            index = "j";
        }
        sourceCode.add("//-- copy array");
        sourceCode.add(fieldInfo.getName());
        sourceCode.append(".clear();");
        sourceCode.add("");
        sourceCode.add("for (int ");
        sourceCode.append(index);
        sourceCode.append(" = 0; ");
        sourceCode.append(index);
        sourceCode.append(" < ");
        sourceCode.append(parameter.getName());
        sourceCode.append(".length; ");
        sourceCode.append(index);
        sourceCode.append("++) {");
        sourceCode.indent();
        sourceCode.addIndented("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".add(");
        sourceCode.append(fieldInfo.getContentType().createToJavaObjectCode(String.valueOf(parameter.getName()) + "[" + index + "]"));
        sourceCode.append(");");
        sourceCode.unindent();
        sourceCode.add("}");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        jClass.addMethod(method);
    }

    private void createSetAsCopyMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod("set" + fieldInfo.getMethodSuffix());
        JParameter parameter = new JParameter(fieldInfo.getXSList().getJType(), String.valueOf(fieldInfo.getContentName()) + "List");
        method.addParameter(parameter);
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Sets the value of '");
        comment.appendComment(fieldInfo.getName());
        comment.appendComment("' by copying the given Vector. All elements will be checked for type safety.");
        JDocDescriptor jDesc = comment.getParamDescriptor(parameter.getName());
        jDesc.setDescription("the Vector to copy.");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("// copy vector");
        sourceCode.add("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".clear();");
        sourceCode.add("");
        sourceCode.add("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".addAll(");
        sourceCode.append(parameter.getName());
        sourceCode.append(");");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        jClass.addMethod(method);
    }

    private void createSetAsReferenceMethod(CollectionInfo fieldInfo, JClass jClass, boolean useJava50) {
        JMethod method = new JMethod("set" + fieldInfo.getMethodSuffix() + fieldInfo.getReferenceSuffix());
        JType collectionJType = new XMLInfoNature(fieldInfo).getSchemaType().getJType();
        JParameter parameter = new JParameter(collectionJType, String.valueOf(fieldInfo.getParameterPrefix()) + collectionJType.getLocalName());
        method.addParameter(parameter);
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Sets the value of '");
        comment.appendComment(fieldInfo.getName());
        comment.appendComment("' by setting it to the given Vector.");
        comment.appendComment(" No type checking is performed.");
        comment.appendComment("\n@deprecated");
        JDocDescriptor jDesc = comment.getParamDescriptor(parameter.getName());
        jDesc.setDescription("the Vector to set.");
        JSourceCode sourceCode = method.getSourceCode();
        sourceCode.add("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(" = ");
        sourceCode.append(parameter.getName());
        sourceCode.append(";");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void createSetByIndexMethod(CollectionInfo fieldInfo, JClass jClass) {
        JMethod method = new JMethod("set" + fieldInfo.getMethodSuffix());
        method.addException(SGTypes.INDEX_OUT_OF_BOUNDS_EXCEPTION, "if the index given is outside the bounds of the collection");
        method.addParameter(new JParameter(JType.INT, "index"));
        method.addParameter(new JParameter(fieldInfo.getContentType().getJType(), fieldInfo.getContentName()));
        JSourceCode sourceCode = method.getSourceCode();
        this.addIndexCheck(fieldInfo, sourceCode, method.getName());
        sourceCode.add("this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".set(index, ");
        sourceCode.append(fieldInfo.getContentType().createToJavaObjectCode(fieldInfo.getContentName()));
        sourceCode.append(");");
        if (fieldInfo.isBound()) {
            this.createBoundPropertyCode(fieldInfo, sourceCode);
        }
        jClass.addMethod(method);
    }

    protected void addMaxSizeCheck(CollectionInfo fieldInfo, String methodName, JSourceCode sourceCode) {
        if (fieldInfo.getXSList().getMaximumSize() > 0) {
            String size = Integer.toString(fieldInfo.getXSList().getMaximumSize());
            sourceCode.add("// check for the maximum size");
            sourceCode.add("if (this.");
            sourceCode.append(fieldInfo.getName());
            sourceCode.append(".size() >= ");
            sourceCode.append(size);
            sourceCode.append(") {");
            sourceCode.indent();
            sourceCode.add("throw new IndexOutOfBoundsException(\"");
            sourceCode.append(methodName);
            sourceCode.append(" has a maximum of ");
            sourceCode.append(size);
            sourceCode.append("\");");
            sourceCode.unindent();
            sourceCode.add("}");
            sourceCode.add("");
        }
    }

    private void addIndexCheck(CollectionInfo fieldInfo, JSourceCode sourceCode, String methodName) {
        sourceCode.add("// check bounds for index");
        sourceCode.add("if (index < 0 || index >= this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".size()) {");
        sourceCode.indent();
        sourceCode.add("throw new IndexOutOfBoundsException(\"");
        sourceCode.append(methodName);
        sourceCode.append(": Index value '\" + index + \"' not in range [0..\" + (this.");
        sourceCode.append(fieldInfo.getName());
        sourceCode.append(".size() - 1) + \"]\");");
        sourceCode.unindent();
        sourceCode.add("}");
        sourceCode.add("");
    }
}

