/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.xml.JavaNaming;
import org.castor.xml.JavaNamingImpl;
import org.castor.xml.XMLProperties;
import org.exolab.castor.builder.AnnotationBuilder;
import org.exolab.castor.builder.SourceGenerator;

public class BuilderConfiguration {
    private static final Log LOG = LogFactory.getLog(BuilderConfiguration.class);
    private static final String SELF_DIRECTORY = "./";
    private static final int SELF_DIRECTORY_LENGTH = "./".length();
    private static final String PARENT_DIRECTORY = "../";
    private static final int PARENT_DIRECTORY_LENGTH = "../".length();
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String ELEMENT_VALUE = "element";
    private static final String TYPE_VALUE = "type";
    private Properties _defaultProps = null;
    private Properties _localProps = null;
    private Hashtable<String, String> _nspackages = new Hashtable();
    private Hashtable<String, String> _locpackages = new Hashtable();
    private JavaNaming _javaNaming;
    private List<AnnotationBuilder> _annotationBuilders = new ArrayList<AnnotationBuilder>();

    public BuilderConfiguration() {
        this.getDefault();
        this._localProps = new Properties(this._defaultProps);
    }

    public final synchronized Properties getDefault() {
        if (this._defaultProps == null) {
            this.load();
        }
        return this._defaultProps;
    }

    public final String getProperty(String name, String defValue) {
        return this._localProps.getProperty(name, defValue);
    }

    public final boolean boundPropertiesEnabled() {
        return TRUE.equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.boundproperties"));
    }

    public final boolean equalsMethod() {
        return TRUE.equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.equalsmethod"));
    }

    public final void setEqualsMethod(boolean equals) {
        String value = equals ? TRUE : FALSE;
        this._localProps.setProperty("org.exolab.castor.builder.equalsmethod", value);
    }

    public final boolean classDescFieldNames() {
        return this._localProps.getProperty("org.exolab.castor.builder.classdescfieldnames", "").equalsIgnoreCase(TRUE);
    }

    public final boolean generateExtraCollectionMethods() {
        return this._localProps.getProperty("org.exolab.castor.builder.extraCollectionMethods", "").equalsIgnoreCase(TRUE);
    }

    public final void setClassDescFieldNames(boolean classDescFieldNames) {
        String value = classDescFieldNames ? TRUE : FALSE;
        this._localProps.setProperty("org.exolab.castor.builder.classdescfieldnames", value);
    }

    public final boolean usePrimitiveWrapper() {
        return this._localProps.getProperty("org.exolab.castor.builder.primitivetowrapper", "").equalsIgnoreCase(TRUE);
    }

    public final void setPrimitiveWrapper(boolean wrapper) {
        String value = wrapper ? TRUE : FALSE;
        this._localProps.setProperty("org.exolab.castor.builder.primitivetowrapper", value);
    }

    public final boolean useEnumeratedTypeInterface() {
        return TRUE.equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.enumTypeAccessInterface"));
    }

    public final boolean useJava50() {
        return "5.0".equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.javaVersion", "1.4"));
    }

    public final boolean useJava5Enums() {
        return this.useJava50() && FALSE.equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.forceJava4Enums", FALSE));
    }

    public final void forceUseJava50() {
        this._localProps.setProperty("org.exolab.castor.builder.javaVersion", "5.0");
    }

    public final boolean generateExtraDocumentationMethods() {
        String extraDocumentationMethods = this._localProps.getProperty("org.exolab.castor.builder.extraDocumentationMethods", FALSE);
        return new Boolean(extraDocumentationMethods);
    }

    public final boolean useCycleBreaker() {
        return Boolean.valueOf(this._localProps.getProperty("org.exolab.castor.builder.useCycleBreaker", TRUE));
    }

    public final int getMaximumNumberOfConstants() {
        String property = this._localProps.getProperty("org.exolab.castor.builder.maxNumberOfConstants", "1000");
        return Integer.valueOf(property);
    }

    public final void setUseEnumeratedTypeInterface(boolean flag) {
        String value = flag ? TRUE : FALSE;
        this._localProps.setProperty("org.exolab.castor.builder.enumTypeAccessInterface", value);
    }

    public boolean mappingSchemaElement2Java() {
        String value = this._localProps.getProperty("org.exolab.castor.builder.javaclassmapping", "");
        return ELEMENT_VALUE.equalsIgnoreCase(value);
    }

    public boolean mappingSchemaType2Java() {
        String value = this._localProps.getProperty("org.exolab.castor.builder.javaclassmapping", "");
        return TYPE_VALUE.equalsIgnoreCase(value);
    }

    public final void setDefaultProperties(Properties properties) {
        Properties defaults = null;
        if (properties == null) {
            defaults = this._defaultProps;
        } else {
            defaults = new Properties(this._defaultProps);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                defaults.setProperty(name, properties.getProperty(name));
            }
        }
        this._localProps = new Properties(defaults);
        this.processNamespacePackageMappings(this._localProps.getProperty("org.exolab.castor.builder.nspackages", ""));
        this.processNamespacePackageMappings(this._localProps.getProperty("org.exolab.castor.xml.nspackages", ""));
    }

    public final void setNamespacePackageMapping(String ns, String packageName) {
        this._nspackages.put(ns, packageName);
    }

    public final void setLocationPackageMapping(String schemaLocation, String packageName) {
        this._locpackages.put(schemaLocation, packageName);
    }

    public final String getJClassPrinterFactories() {
        return this._localProps.getProperty("org.exolab.castor.builder.jclassPrinterFactories");
    }

    protected final synchronized void load() {
        if (this._defaultProps == null) {
            this._defaultProps = BuilderConfiguration.loadProperties("/org/exolab/castor/builder/castorbuilder.properties", "castorbuilder.properties");
            boolean found = false;
            try {
                InputStream is = SourceGenerator.class.getResourceAsStream("/castorbuilder.properties");
                if (is != null) {
                    found = true;
                    this._defaultProps.load(is);
                    is.close();
                }
            }
            catch (Exception is) {
                // empty catch block
            }
            if (!found) {
                try {
                    File file = new File("castorbuilder.properties");
                    if (file.exists() && file.canRead()) {
                        FileInputStream is = new FileInputStream(file);
                        this._defaultProps.load(is);
                        ((InputStream)is).close();
                    }
                }
                catch (Exception file) {
                    // empty catch block
                }
            }
        }
        AbstractProperties rtconf = XMLProperties.newInstance();
        this.processNamespacePackageMappings(rtconf.getString("org.exolab.castor.builder.nspackages", ""));
        this.processNamespacePackageMappings(rtconf.getString("org.exolab.castor.xml.nspackages", ""));
        this.processNamespacePackageMappings(this._defaultProps.getProperty("org.exolab.castor.builder.nspackages", ""));
        this.processNamespacePackageMappings(this._defaultProps.getProperty("org.exolab.castor.xml.nspackages", ""));
        String prop = this._defaultProps.getProperty("org.exolab.castor.xml.JavaNaming.upperCaseAfterUnderscore", null);
        if (prop != null) {
            JavaNamingImpl._upperCaseAfterUnderscore = Boolean.valueOf(prop);
        }
    }

    public final String lookupPackageByNamespace(String nsURL) {
        String namespaceURL = nsURL == null ? "" : nsURL;
        String javaPackage = this._nspackages.get(namespaceURL);
        if (javaPackage == null) {
            return "";
        }
        return javaPackage;
    }

    public final String lookupPackageByLocation(String schemaLocation) {
        if (schemaLocation == null) {
            return "";
        }
        String javaPackage = this._locpackages.get(schemaLocation);
        if (javaPackage == null) {
            String cleanedSchemaLocation = schemaLocation;
            while (schemaLocation.startsWith(".")) {
                if (schemaLocation.startsWith(SELF_DIRECTORY)) {
                    cleanedSchemaLocation = schemaLocation.substring(SELF_DIRECTORY_LENGTH);
                    continue;
                }
                if (!schemaLocation.startsWith(PARENT_DIRECTORY)) continue;
                cleanedSchemaLocation = schemaLocation.substring(PARENT_DIRECTORY_LENGTH);
            }
            Enumeration<String> keys = this._locpackages.keys();
            boolean found = false;
            while (keys.hasMoreElements() && !found) {
                String key = keys.nextElement();
                if (!cleanedSchemaLocation.endsWith(key)) continue;
                javaPackage = this._locpackages.get(key);
                found = true;
            }
            if (javaPackage == null) {
                javaPackage = "";
            }
        }
        return javaPackage;
    }

    protected final void processNamespacePackageMappings(String mappings) {
        if (mappings == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(mappings, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int sepIdx = token.indexOf(61);
            if (sepIdx < 0) continue;
            String ns = token.substring(0, sepIdx).trim();
            String javaPackage = token.substring(sepIdx + 1).trim();
            this._nspackages.put(ns, javaPackage);
        }
    }

    public boolean isAutomaticConflictResolution() {
        String automaticConflictResolutionProperty = this._localProps.getProperty("org.exolab.castor.builder.automaticConflictResolution", FALSE);
        return TRUE.equalsIgnoreCase(automaticConflictResolutionProperty);
    }

    public String getAutomaticConflictResolutionTypeSuffix() {
        return this._localProps.getProperty("org.exolab.castor.builder.automaticConflictResolutionTypeSuffix", "");
    }

    public void setJavaNaming(JavaNaming javaNaming) {
        this._javaNaming = javaNaming;
    }

    public JavaNaming getJavaNaming() {
        return this._javaNaming;
    }

    public void addAnnotationBuilder(AnnotationBuilder annotationBuilder) {
        this._annotationBuilders.add(annotationBuilder);
    }

    public AnnotationBuilder[] getAnnotationBuilders() {
        return this._annotationBuilders.toArray(new AnnotationBuilder[this._annotationBuilders.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String resourceName, String fileName) {
        Properties properties = new Properties();
        boolean found = false;
        InputStream resourceStream = null;
        try {
            resourceStream = AbstractProperties.class.getResourceAsStream(resourceName);
            properties.load(resourceStream);
            found = true;
        }
        catch (Exception e) {
        }
        finally {
            if (resourceStream != null) {
                try {
                    resourceStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Problem closing stream for " + resourceName));
                }
            }
        }
        String javaHome = null;
        try {
            javaHome = System.getProperty("java.home");
        }
        catch (SecurityException e) {
            LOG.warn((Object)Messages.format((String)"conf.privilegesError", (Object)e));
        }
        catch (Exception e) {
            LOG.warn((Object)Messages.format((String)"conf.nonCriticalError", (Object)e));
        }
        if (javaHome != null) {
            InputStream fileStream = null;
            try {
                File file = new File(javaHome, "lib");
                file = new File(file, fileName);
                if (file.exists()) {
                    properties = new Properties(properties);
                    fileStream = new FileInputStream(file);
                    properties.load(fileStream);
                    found = true;
                }
            }
            catch (SecurityException e) {
                LOG.warn((Object)Messages.format((String)"conf.privilegesError", (Object)e));
            }
            catch (IOException e) {
                LOG.warn((Object)Messages.format((String)"conf.nonCriticalError", (Object)e));
            }
            finally {
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Problem closing stream for " + fileName));
                    }
                }
            }
        }
        if (!found) {
            throw new RuntimeException(Messages.format((String)"conf.noDefaultConfigurationFile", (Object)fileName));
        }
        return properties;
    }

    public boolean useOldFieldNaming() {
        return TRUE.equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.field-naming.old", FALSE));
    }

    public static class Property {
        public static final String BOUND_PROPERTIES = "org.exolab.castor.builder.boundproperties";
        public static final String ENUM_TYPE_ACCESS_INTERFACE = "org.exolab.castor.builder.enumTypeAccessInterface";
        public static final String EXTRA_COLLECTION_METHODS = "org.exolab.castor.builder.extraCollectionMethods";
        public static final String SUPER_CLASS = "org.exolab.castor.builder.superclass";
        public static final String JAVA_CLASS_MAPPING = "org.exolab.castor.builder.javaclassmapping";
        public static final String NAMESPACE_PACKAGES_OLD = "org.exolab.castor.builder.nspackages";
        public static final String NAMESPACE_PACKAGES = "org.exolab.castor.xml.nspackages";
        public static final String EQUALS_METHOD = "org.exolab.castor.builder.equalsmethod";
        public static final String WRAPPER = "org.exolab.castor.builder.primitivetowrapper";
        public static final String CLASS_DESC_FIELD_NAMES = "org.exolab.castor.builder.classdescfieldnames";
        public static final String JAVA_VERSION = "org.exolab.castor.builder.javaVersion";
        public static final String FORCE_JAVA4_ENUMS = "org.exolab.castor.builder.forceJava4Enums";
        public static final String CONFIG_FILENAME_PROPERTY = "castorbuilder.properties";
        public static final String MAX_CONSTANTS_PROPERTY = "org.exolab.castor.builder.maxNumberOfConstants";
        static final String RESOURCE_NAME = "/org/exolab/castor/builder/castorbuilder.properties";
        public static final String NAME_CONFLICT_STRATEGIES = "org.exolab.castor.builder.nameConflictStrategies";
        public static final String AUTOMATIC_CONFLICT_RESOLUTION = "org.exolab.castor.builder.automaticConflictResolution";
        public static final String AUTOMATIC_CONFLICT_RESOLUTION_TYPE_SUFFIX = "org.exolab.castor.builder.automaticConflictResolutionTypeSuffix";
        public static final String JCLASSPRINTER_FACTORIES = "org.exolab.castor.builder.jclassPrinterFactories";
        public static final String EXTRA_DOCUMENTATION_METHODS = "org.exolab.castor.builder.extraDocumentationMethods";
        public static final String USE_CYCLE_BREAKER = "org.exolab.castor.builder.useCycleBreaker";
        public static final String USE_OLD_FIELD_NAMING = "org.exolab.castor.builder.field-naming.old";
    }
}

