/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.AbstractJClass;
import org.exolab.javasource.JAnnotatedElementHelper;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public final class JConstructor
extends JAnnotatedElementHelper {
    private JModifiers _modifiers;
    private JNamedMap _params;
    private AbstractJClass _declaringClass;
    private JSourceCode _sourceCode;
    private Vector _exceptions;

    protected JConstructor(AbstractJClass declaringClass) {
        this._declaringClass = declaringClass;
        this._modifiers = new JModifiers();
        this._params = new JNamedMap();
        this._sourceCode = new JSourceCode();
        this._exceptions = new Vector(1);
    }

    public JClass[] getExceptions() {
        Object[] jclasses = new JClass[this._exceptions.size()];
        this._exceptions.copyInto(jclasses);
        return jclasses;
    }

    public void addException(JClass exp) {
        if (exp == null) {
            return;
        }
        String expClassName = exp.getName();
        for (int i = 0; i < this._exceptions.size(); ++i) {
            JClass jClass = (JClass)this._exceptions.elementAt(i);
            if (!expClassName.equals(jClass.getName())) continue;
            return;
        }
        this._exceptions.addElement(exp);
    }

    public JParameter[] getParameters() {
        JParameter[] jpArray = new JParameter[this._params.size()];
        for (int i = 0; i < jpArray.length; ++i) {
            jpArray[i] = (JParameter)this._params.get(i);
        }
        return jpArray;
    }

    public int getParameterCount() {
        return this._params.size();
    }

    public void addParameter(JParameter parameter) {
        JType jType;
        if (parameter == null) {
            return;
        }
        if (this._params.get(parameter.getName()) != null) {
            StringBuilder err = new StringBuilder(64);
            err.append("A parameter already exists for the constructor, ");
            err.append(this._declaringClass.getName());
            err.append(", with the name: ");
            err.append(parameter.getName());
            throw new IllegalArgumentException(err.toString());
        }
        this._params.put(parameter.getName(), parameter);
        if (this._declaringClass != null && !(jType = parameter.getType()).isPrimitive()) {
            this._declaringClass.addImport(jType.getName());
        }
    }

    public AbstractJClass getDeclaringClass() {
        return this._declaringClass;
    }

    public JModifiers getModifiers() {
        return this._modifiers;
    }

    public void setModifiers(JModifiers modifiers) {
        this._modifiers = modifiers.copy();
        this._modifiers.setFinal(false);
    }

    public JSourceCode getSourceCode() {
        return this._sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this._sourceCode = new JSourceCode(sourceCode);
    }

    public void setSourceCode(JSourceCode sourceCode) {
        this._sourceCode = sourceCode;
    }

    public void print(JSourceWriter jsw) {
        JParameter jParameter;
        int i;
        this.printAnnotations(jsw);
        if (this._modifiers.isPrivate()) {
            jsw.write("private");
        } else if (this._modifiers.isProtected()) {
            jsw.write("protected");
        } else {
            jsw.write("public");
        }
        jsw.write(32);
        jsw.write(this._declaringClass.getLocalName());
        jsw.write(40);
        boolean parameterAnnotations = false;
        for (i = 0; i < this._params.size(); ++i) {
            jParameter = (JParameter)this._params.get(i);
            if (!jParameter.hasAnnotations()) continue;
            parameterAnnotations = true;
            break;
        }
        if (parameterAnnotations) {
            jsw.indent();
        }
        for (i = 0; i < this._params.size(); ++i) {
            if (i > 0) {
                jsw.write(", ");
            }
            if (parameterAnnotations) {
                jsw.writeln();
            }
            jParameter = (JParameter)this._params.get(i);
            jParameter.printAnnotations(jsw);
            String typeAndName = jParameter.toString();
            jsw.write(typeAndName);
        }
        if (parameterAnnotations) {
            jsw.unindent();
        }
        jsw.write(")");
        if (this._exceptions.size() > 0) {
            jsw.writeln();
            jsw.write("throws ");
            for (i = 0; i < this._exceptions.size(); ++i) {
                if (i > 0) {
                    jsw.write(", ");
                }
                JClass jClass = (JClass)this._exceptions.elementAt(i);
                jsw.write(jClass.getName());
            }
        }
        jsw.writeln(" {");
        this._sourceCode.print(jsw);
        if (!jsw.isNewline()) {
            jsw.writeln();
        }
        jsw.writeln("}");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this._declaringClass.getName());
        sb.append('(');
        for (int i = 0; i < this._params.size(); ++i) {
            JParameter jp = (JParameter)this._params.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(jp.getType().getName());
        }
        sb.append(')');
        return sb.toString();
    }
}

