/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Enumeration;
import org.exolab.javasource.AbstractJClass;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JTypeName;

public class JClass
extends AbstractJClass {
    private JTypeName _superClass = null;

    public JClass(String name) {
        super(name);
    }

    public final void addImport(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        JTypeName jtName = new JTypeName(className);
        String cls = jtName.getLocalName();
        String pkg = jtName.getPackageName();
        if (this._superClass != null && this._superClass.getLocalName().equals(cls) && this._superClass.getPackageName() == null && pkg != null) {
            return;
        }
        this.addImportInternal(className);
    }

    public void addMember(JMember jMember) {
        if (jMember instanceof JField) {
            this.addField((JField)jMember);
        } else if (jMember instanceof JMethod) {
            this.addMethod((JMethod)jMember);
        } else {
            String error = null;
            error = jMember == null ? "the argument 'jMember' must not be null." : "Cannot add JMember '" + jMember.getClass().getName() + "' to JClass, unrecognized type.";
            throw new IllegalArgumentException(error);
        }
    }

    public final JTypeName getSuperClass() {
        return this._superClass;
    }

    public final String getSuperClassQualifiedName() {
        if (this._superClass == null) {
            return null;
        }
        return this._superClass.getQualifiedName();
    }

    public final void setSuperClass(String superClass) {
        this._superClass = superClass == null ? null : new JTypeName(superClass);
    }

    public void print(JSourceWriter jsw, boolean classOnly) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        if (!classOnly) {
            this.printClassHeaders(jsw);
        }
        this.getJDocComment().print(jsw);
        this.printClassDefinitionLine(jsw);
        jsw.writeln();
        jsw.indent();
        this.printMemberVariables(jsw);
        this.printStaticInitializers(jsw);
        this.printConstructors(jsw);
        this.printMethods(jsw);
        this.printInnerClasses(jsw);
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }

    private void printClassDefinitionLine(JSourceWriter jsw) {
        StringBuilder buffer = new StringBuilder(32);
        this.getAnnotatedElementHelper().printAnnotations(jsw);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        if (modifiers.isFinal()) {
            buffer.append("final ");
        }
        if (modifiers.isAbstract()) {
            buffer.append("abstract ");
        }
        buffer.append("class ");
        buffer.append(this.getLocalName());
        buffer.append(' ');
        if (this._superClass != null) {
            buffer.append("extends ");
            buffer.append(this._superClass);
            buffer.append(' ');
        }
        if (this.getInterfaceCount() > 0) {
            boolean endl = false;
            if (this.getInterfaceCount() > 1 || this._superClass != null) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
                endl = true;
            }
            buffer.append("implements ");
            Enumeration enumeration = this.getInterfaces();
            while (enumeration.hasMoreElements()) {
                buffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                buffer.append(", ");
            }
            if (endl) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
            } else {
                buffer.append(' ');
            }
        }
        buffer.append('{');
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
    }

    public void changeLocalName(String localName) {
        String packageName = this.getPackageName();
        if (packageName != null) {
            this.setName(packageName + "." + localName);
        } else {
            this.setName(localName);
        }
    }
}

