/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import org.exolab.castor.util.OrderedHashMap;
import org.exolab.javasource.JAnnotatedElement;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JSourceWriter;

public class JAnnotatedElementHelper
implements JAnnotatedElement {
    private OrderedHashMap _annotations;

    public final JAnnotation getAnnotation(JAnnotationType annotationType) {
        if (this._annotations == null) {
            return null;
        }
        return (JAnnotation)this._annotations.get((Object)annotationType.getName());
    }

    public final JAnnotation[] getAnnotations() {
        if (this._annotations == null) {
            return new JAnnotation[0];
        }
        return this._annotations.values().toArray(new JAnnotation[this._annotations.size()]);
    }

    public final boolean isAnnotationPresent(JAnnotationType annotationType) {
        if (this._annotations != null) {
            return this._annotations.containsKey((Object)annotationType.getName());
        }
        return false;
    }

    public final void addAnnotation(JAnnotation annotation) {
        if (this.isAnnotationPresent(annotation.getAnnotationType())) {
            throw new IllegalArgumentException("Annotation for '" + annotation.getAnnotationType().getName() + "' already added.");
        }
        String annotationType = annotation.getAnnotationType().getName();
        if (this._annotations == null) {
            this._annotations = new OrderedHashMap();
        }
        this._annotations.put((Object)annotationType, (Object)annotation);
    }

    public final JAnnotation removeAnnotation(JAnnotationType annotationType) {
        if (!this.isAnnotationPresent(annotationType)) {
            throw new IllegalArgumentException("Annotation for '" + annotationType.getName() + "' not present.");
        }
        return (JAnnotation)this._annotations.remove((Object)annotationType.getName());
    }

    public final boolean hasAnnotations() {
        if (this._annotations != null) {
            return this._annotations.size() > 0;
        }
        return false;
    }

    public final boolean printAnnotations(JSourceWriter jsw) {
        boolean printed = false;
        if (this._annotations != null) {
            for (JAnnotation annotation : this._annotations.values()) {
                annotation.print(jsw);
                jsw.writeln();
                printed = true;
            }
        }
        return printed;
    }
}

