/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.printing;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.exolab.castor.builder.printing.JClassPrinter;

public class JClassPrinterFactory {
    private static Map _printers = new HashMap();
    private static String _default;

    public static void init(String typeString) {
        StringTokenizer tokenizer = new StringTokenizer(typeString, ",");
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken();
            try {
                Class<?> c = Class.forName(classname);
                JClassPrinter classPrinter = (JClassPrinter)c.newInstance();
                _printers.put(classname, classPrinter);
                if (_default != null) continue;
                _default = classname;
            }
            catch (Exception e) {
                IllegalArgumentException exception = new IllegalArgumentException("JClassPrinter class not found: " + classname);
                exception.initCause(e);
                throw exception;
            }
        }
    }

    public static String getDefaultType() {
        return _default;
    }

    public static JClassPrinter getJClassPrinter(String classname) {
        return (JClassPrinter)_printers.get(classname);
    }
}

