/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.PrintWriter;
import java.util.Properties;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.binding.BindingException;
import org.exolab.castor.builder.binding.BindingLoader;
import org.exolab.castor.builder.factory.FieldInfoFactory;
import org.exolab.castor.util.CommandLineOptions;
import org.xml.sax.InputSource;

public final class SourceGeneratorMain {
    private static final String ARGUMENT_BINDING_FILENAME = "binding-file";
    private static final String ARGUMENT_CASE_INSENSITIVE = "case-insensitive";
    private static final String ARGUMENT_DESTINATION_DIR = "dest";
    private static final String ARGUMENT_DISABLE_DESCRIPTORS = "nodesc";
    private static final String ARGUMENT_FORCE = "f";
    private static final String ARGUMENT_GENERATE_IMPORTED_SCHEMAS = "generateImportedSchemas";
    private static final String ARGUMENT_GENERATE_MAPPING = "gen-mapping";
    private static final String ARGUMENT_HELP = "h";
    private static final String ARGUMENT_INPUT = "i";
    private static final String ARGUMENT_INPUT_SOURCE = "is";
    private static final String ARGUMENT_LINE_SEPARATOR = "line-separator";
    private static final String ARGUMENT_NOMARSHALL = "nomarshall";
    private static final String ARGUMENT_PACKAGE = "package";
    private static final String ARGUMENT_SAX1 = "sax1";
    private static final String ARGUMENT_TESTABLE = "testable";
    private static final String ARGUMENT_TYPES = "types";
    private static final String ARGUMENT_TYPES_DEPRECATED = "type-factory";
    private static final String ARGUMENT_TYPES_JAVA2 = "j2";
    private static final String ARGUMENT_VERBOSE = "verbose";
    private static final String ARGUMENT_FAIL_ON_ERROR = "fail";
    private static final String ARGUMENT_NAME_CONFLICT_STRATEGY = "nameConflictStrategy";
    private static final String ARGUMENT_NAME_JCLASSPRINTER = "classPrinter";
    private static final String ARG_VALUE_LINE_SEPARATION_MAC = "mac";
    private static final String ARG_VALUE_LINE_SEPARATION_UNIX = "unix";
    private static final String ARG_VALUE_LINE_SEPARATION_WIN = "win";
    private static final String DISABLE_DESCRIPTORS_MSG = "Disabling generation of Class descriptors.";
    private static final String DISABLE_MARSHALL_MSG = "Disabling generation of Marshaling framework methods (marshal, unmarshal, validate).";
    private static final String CASTOR_TESTABLE_MSG = "The generated classes will implement org.castor.xmlctf.CastorTestable.";
    private static final String SAX1_MSG = "The generated classes will use SAX 1.";
    private static final String GENERATE_IMPORT_MSG = "Imported XML Schemas will be processed automatically.";
    private static final String CASE_INSENSITIVE_MSG = "The generated classes will use a case insensitive method for looking up enumerated type values.";
    private static final String TYPE_FACTORY_ARG_MSG = "The argument '-type-factory' is deprecated; please use '-types' in its place.";
    private static final String SUPPRESS_NON_FATAL_WARN_MSG = "Suppressing non fatal warnings.";
    private static final String GENERATING_MAPPING_FILE_MSG = "Generating mapping file: ";
    private static final String BINDING_FILE_ERROR1_MSG = "Unable to load binding file ";
    private static final String BINDING_FILE_ERROR2_MSG = " due to the following Exception:";
    private static final String BINDING_FILE_ERROR3_MSG = "No binding file will be used.";
    private static final String INVALID_TYPES_OPTION_MSG = "Invalid option for '-types': ";
    private static final String DEFAULT_FIELD_INFO_MSG = "Using default source generator types.";
    private static final String LINE_SEPARATION_WIN_MSG = "Using Windows style line separation.";
    private static final String LINE_SEPARATION_UNIX_MSG = "Using UNIX style line separation.";
    private static final String LINE_SEPARATION_MAC_MSG = "Using Macintosh style line separation.";
    private static final String DEFAULT_LINE_SEPARATOR_MSG = "Using default line separator for this platform";
    private static final String INVALID_LINE_SEPARATOR_MSG = "Invalid option for line-separator: ";
    private static final String NAME_CONFLICT_STRATEGY_MSG = "Using name conflict strategy ";
    private static final CommandLineOptions ALL_OPTIONS = SourceGeneratorMain.setupCommandLineOptions();

    private SourceGeneratorMain() {
    }

    public static void main(String[] args) {
        String bindingFilename;
        String jClassPrinterType;
        String nameConflictStrategy;
        String mappingFilename;
        Properties options = ALL_OPTIONS.getOptions(args);
        if (options.getProperty(ARGUMENT_HELP) != null) {
            PrintWriter pw = new PrintWriter(System.out, true);
            ALL_OPTIONS.printHelp(pw);
            return;
        }
        String schemaFilename = options.getProperty(ARGUMENT_INPUT);
        String schemaURL = options.getProperty(ARGUMENT_INPUT_SOURCE);
        if (schemaFilename == null && schemaURL == null) {
            System.out.println("Castor");
            ALL_OPTIONS.printUsage(new PrintWriter(System.out));
            return;
        }
        FieldInfoFactory factory = SourceGeneratorMain.getTypeFactory(options);
        SourceGenerator sgen = factory == null ? new SourceGenerator() : new SourceGenerator(factory);
        sgen.setLineSeparator(SourceGeneratorMain.getLineSeparator(options.getProperty(ARGUMENT_LINE_SEPARATOR)));
        sgen.setDestDir(options.getProperty(ARGUMENT_DESTINATION_DIR));
        sgen.setVerbose(options.getProperty(ARGUMENT_VERBOSE) != null);
        sgen.setFailOnFirstError(options.getProperty(ARGUMENT_FAIL_ON_ERROR) != null);
        boolean force = options.getProperty(ARGUMENT_FORCE) != null;
        sgen.setSuppressNonFatalWarnings(force);
        if (force) {
            System.out.print("-- ");
            System.out.println(SUPPRESS_NON_FATAL_WARN_MSG);
        }
        if (options.getProperty(ARGUMENT_DISABLE_DESCRIPTORS) != null) {
            sgen.setDescriptorCreation(false);
            System.out.print("-- ");
            System.out.println(DISABLE_DESCRIPTORS_MSG);
        }
        if ((mappingFilename = options.getProperty(ARGUMENT_GENERATE_MAPPING)) != null) {
            sgen.setGenerateMappingFile(true);
            if (mappingFilename.length() > 0) {
                sgen.setMappingFilename(mappingFilename);
            }
            System.out.print("-- ");
            System.out.println("Generating mapping file: '" + mappingFilename + "'");
        }
        if (options.getProperty(ARGUMENT_NOMARSHALL) != null) {
            sgen.setCreateMarshalMethods(false);
            System.out.print("-- ");
            System.out.println(DISABLE_MARSHALL_MSG);
        }
        if (options.getProperty(ARGUMENT_TESTABLE) != null) {
            sgen.setTestable(true);
            System.out.print("-- ");
            System.out.println(CASTOR_TESTABLE_MSG);
        }
        if (options.getProperty(ARGUMENT_SAX1) != null) {
            sgen.setSAX1(true);
            System.out.print("-- ");
            System.out.println(SAX1_MSG);
        }
        if (options.getProperty(ARGUMENT_CASE_INSENSITIVE) != null) {
            sgen.setCaseInsensitive(true);
            System.out.print("-- ");
            System.out.println(CASE_INSENSITIVE_MSG);
        }
        if ((nameConflictStrategy = options.getProperty(ARGUMENT_NAME_CONFLICT_STRATEGY)) != null) {
            sgen.setNameConflictStrategy(nameConflictStrategy);
            System.out.print("-- ");
            System.out.println(CASE_INSENSITIVE_MSG + nameConflictStrategy);
        }
        if ((jClassPrinterType = options.getProperty(ARGUMENT_NAME_JCLASSPRINTER)) != null) {
            sgen.setJClassPrinter(jClassPrinterType);
            System.out.print("-- ");
            System.out.println(CASE_INSENSITIVE_MSG + jClassPrinterType);
        }
        if ((bindingFilename = options.getProperty(ARGUMENT_BINDING_FILENAME)) != null) {
            try {
                sgen.setBinding(BindingLoader.createBinding(bindingFilename));
            }
            catch (BindingException e) {
                System.out.print("--");
                System.out.println("Unable to load binding file '" + bindingFilename + "'" + BINDING_FILE_ERROR2_MSG);
                e.printStackTrace();
                System.out.print("--");
                System.out.println(BINDING_FILE_ERROR3_MSG);
            }
        }
        if (options.getProperty(ARGUMENT_GENERATE_IMPORTED_SCHEMAS) != null) {
            sgen.setGenerateImportedSchemas(true);
            System.out.print("-- ");
            System.out.println(GENERATE_IMPORT_MSG);
        }
        try {
            if (schemaFilename != null) {
                sgen.generateSource(schemaFilename, options.getProperty(ARGUMENT_PACKAGE));
            } else if (schemaURL != null) {
                sgen.generateSource(new InputSource(schemaURL), options.getProperty(ARGUMENT_PACKAGE));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static FieldInfoFactory getTypeFactory(Properties options) {
        String typeFactory = options.getProperty(ARGUMENT_TYPES);
        if (typeFactory == null && (typeFactory = options.getProperty(ARGUMENT_TYPES_DEPRECATED)) != null) {
            System.out.print("-- ");
            System.out.println(TYPE_FACTORY_ARG_MSG);
        }
        if (typeFactory != null && typeFactory.equals(ARGUMENT_TYPES_JAVA2)) {
            typeFactory = "arraylist";
        }
        if (typeFactory == null) {
            return null;
        }
        FieldInfoFactory factory = null;
        try {
            factory = new FieldInfoFactory(typeFactory);
        }
        catch (IllegalArgumentException e) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                factory = (FieldInfoFactory)classLoader.loadClass(typeFactory).newInstance();
            }
            catch (Exception e2) {
                System.out.println("-- Invalid option for '-types': " + typeFactory);
                System.out.println("-- " + e.getMessage());
                System.out.println("-- Using default source generator types.");
            }
        }
        return factory;
    }

    private static String getLineSeparator(String lineSepStyle) {
        String lineSep = System.getProperty("line.separator");
        if (lineSepStyle != null) {
            if (ARG_VALUE_LINE_SEPARATION_WIN.equals(lineSepStyle)) {
                System.out.println("-- Using Windows style line separation.");
                lineSep = "\r\n";
            } else if (ARG_VALUE_LINE_SEPARATION_UNIX.equals(lineSepStyle)) {
                System.out.println("-- Using UNIX style line separation.");
                lineSep = "\n";
            } else if (ARG_VALUE_LINE_SEPARATION_MAC.equals(lineSepStyle)) {
                System.out.println("-- Using Macintosh style line separation.");
                lineSep = "\r";
            } else {
                System.out.println("-- Invalid option for line-separator: '" + lineSepStyle + "'");
                System.out.println("-- Using default line separator for this platform");
            }
        }
        return lineSep;
    }

    private static CommandLineOptions setupCommandLineOptions() {
        CommandLineOptions allOptions = new CommandLineOptions();
        String desc = "Sets the filename for the schema used as input.";
        allOptions.addFlag(ARGUMENT_INPUT, "schema filename", desc);
        desc = "Sets the input source for the schema used as input.";
        allOptions.addFlag(ARGUMENT_INPUT_SOURCE, "input source for XML schema", desc);
        desc = "Sets the package name for generated code.";
        allOptions.addFlag(ARGUMENT_PACKAGE, "package name", desc, true);
        desc = "Sets the destination output directory.";
        allOptions.addFlag(ARGUMENT_DESTINATION_DIR, "destination directory", desc, true);
        desc = "Sets the line separator style for the desired platform.";
        allOptions.addFlag(ARGUMENT_LINE_SEPARATOR, "(unix | mac | win)", desc, true);
        desc = "Suppresses non fatal warnings, such as overwriting files.";
        allOptions.addFlag(ARGUMENT_FORCE, "", desc, true);
        desc = "Displays this help screen.";
        allOptions.addFlag(ARGUMENT_HELP, "", desc, true);
        desc = "Prints out additional messages when creating source.";
        allOptions.addFlag(ARGUMENT_VERBOSE, "", desc, true);
        desc = "Causes source generation to fail on the first error encountered.";
        allOptions.addFlag(ARGUMENT_FAIL_ON_ERROR, "", desc, true);
        desc = "Disables the generation of the Class descriptors.";
        allOptions.addFlag(ARGUMENT_DISABLE_DESCRIPTORS, "", desc, true);
        desc = "Indicates that a mapping file should be generated.";
        allOptions.addFlag(ARGUMENT_GENERATE_MAPPING, "mapping filename", desc, true);
        desc = "Sets the source generator types name (SGTypeFactory).";
        allOptions.addFlag(ARGUMENT_TYPES, ARGUMENT_TYPES, desc, true);
        desc = "";
        allOptions.addFlag(ARGUMENT_TYPES_DEPRECATED, "collections class name", desc, true);
        desc = "Disables the generation of the methods specific to the XML marshaling framework.";
        allOptions.addFlag(ARGUMENT_NOMARSHALL, "", desc, true);
        desc = "Implements some specific methods to allow the generated classes to be used with Castor Testing Framework.";
        allOptions.addFlag(ARGUMENT_TESTABLE, "", desc, true);
        desc = "Uses SAX 1 in the generated code.";
        allOptions.addFlag(ARGUMENT_SAX1, "", desc, true);
        desc = "Sets the Source Generator Binding File name.";
        allOptions.addFlag(ARGUMENT_BINDING_FILENAME, "filename", desc, true);
        desc = "Generates sources for imported XML schemas.";
        allOptions.addFlag(ARGUMENT_GENERATE_IMPORTED_SCHEMAS, "", desc, true);
        desc = "Sets enumerated types to use a case insensitive lookup.";
        allOptions.addFlag(ARGUMENT_CASE_INSENSITIVE, "", desc);
        desc = "Sets name conflict strategy to use (possible values are 'informViaLog', 'warnViaConsoleDialog').";
        allOptions.addFlag(ARGUMENT_NAME_CONFLICT_STRATEGY, "", desc);
        return allOptions;
    }
}

