/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.JClassRegistry;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SingleClassGenerator;
import org.exolab.castor.builder.SourceGeneratorMain;
import org.exolab.castor.builder.binding.BindingException;
import org.exolab.castor.builder.binding.BindingLoader;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.binding.XPathHelper;
import org.exolab.castor.builder.binding.xml.PackageType;
import org.exolab.castor.builder.binding.xml.PackageTypeChoice;
import org.exolab.castor.builder.binding.xml.types.BindingType;
import org.exolab.castor.builder.conflict.strategy.ClassNameConflictResolver;
import org.exolab.castor.builder.conflict.strategy.TypeClassNameConflictResolver;
import org.exolab.castor.builder.conflict.strategy.XPATHClassNameConflictResolver;
import org.exolab.castor.builder.factory.FieldInfoFactory;
import org.exolab.castor.builder.factory.SourceFactory;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.core.exceptions.CastorRuntimeException;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.util.dialog.ConsoleDialog;
import org.exolab.castor.util.dialog.Dialog;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.javasource.JClass;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SourceGenerator
extends BuilderConfiguration {
    private static final Log LOG = LogFactory.getLog((Class)SourceGenerator.class);
    static final String APP_NAME = "Castor";
    static final String APP_DESC = "XML data binder for Java";
    static final String VERSION = "1.1.2";
    static final String APP_URI = "http://www.castor.org";
    private static final String IMPORT_WARNING = "Warning: Do not forget to generate source code for the following imported schema: ";
    private final Configuration _config;
    private final XMLBindingComponent _bindingComponent;
    private final SingleClassGenerator _singleClassGenerator;
    private final FieldInfoFactory _infoFactory;
    private final ConsoleDialog _dialog;
    private final Vector _schemasProcessed = new Vector(7);
    private boolean _suppressNonFatalWarnings = false;
    private boolean _verbose = false;
    private boolean _createDescriptors = true;
    private boolean _generateImported = false;
    private SourceFactory _sourceFactory = null;
    private boolean _generateMapping = false;
    private String _mappingFilename = "mapping.xml";
    private boolean _createMarshalMethods = true;
    private boolean _testable = false;
    private boolean _sax1 = false;
    private boolean _caseInsensitive = false;
    private boolean _failOnFirstError = false;
    private GroupNaming _groupNaming = null;
    private String _nameConflictStrategy = "warnViaConsoleDialog";
    private JClassRegistry _xmlInfoRegistry;
    private ClassNameConflictResolver _conflictResolver = new XPATHClassNameConflictResolver();

    public SourceGenerator() {
        this(null);
        this._groupNaming = new GroupNaming();
    }

    public SourceGenerator(FieldInfoFactory infoFactory) {
        this(infoFactory, null);
        this._groupNaming = new GroupNaming();
    }

    public SourceGenerator(FieldInfoFactory infoFactory, ExtendedBinding binding) {
        this._config = LocalConfiguration.getInstance();
        this._dialog = new ConsoleDialog();
        this._infoFactory = infoFactory == null ? new FieldInfoFactory() : infoFactory;
        this._groupNaming = new GroupNaming();
        this._singleClassGenerator = new SingleClassGenerator(this._dialog, this, this._nameConflictStrategy);
        this._bindingComponent = new XMLBindingComponent(this, this._groupNaming);
        this.setBinding(binding);
        this._conflictResolver.setSourceGenerator(this);
        this._xmlInfoRegistry = new JClassRegistry(this._conflictResolver);
    }

    public final void setMappingFilename(String filename) {
        this._mappingFilename = filename;
    }

    public final void setNameConflictStrategy(String nameConflictStrategy) {
        this._nameConflictStrategy = nameConflictStrategy;
        this._singleClassGenerator.setNameConflictStrategy(nameConflictStrategy);
    }

    public static String getVersion() {
        return VERSION;
    }

    public final void setSAX1(boolean sax1) {
        this._sax1 = sax1;
    }

    public final void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public final void setFailOnFirstError(boolean failOnFirstError) {
        this._failOnFirstError = failOnFirstError;
    }

    public final void setSuppressNonFatalWarnings(boolean suppress) {
        this._singleClassGenerator.setPromptForOverwrite(!suppress);
        this._suppressNonFatalWarnings = suppress;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public void setClassNameConflictResolver(String resolverName) {
        if (resolverName.equals("type")) {
            this._conflictResolver = new TypeClassNameConflictResolver();
            this._conflictResolver.setSourceGenerator(this);
        } else if (!resolverName.equals("xpath")) {
            throw new IllegalArgumentException("Invalid resolver type.");
        }
        this._xmlInfoRegistry.setClassNameConflictResolver(this._conflictResolver);
    }

    public final void setDescriptorCreation(boolean createDescriptors) {
        this._createDescriptors = createDescriptors;
        this._singleClassGenerator.setDescriptorCreation(createDescriptors);
    }

    public final void setDestDir(String destDir) {
        this._singleClassGenerator.setDestDir(destDir);
    }

    public final void setCreateMarshalMethods(boolean createMarshalMethods) {
        this._createMarshalMethods = createMarshalMethods;
    }

    public final void setGenerateImportedSchemas(boolean generate) {
        this._generateImported = generate;
    }

    public final void setGenerateMappingFile(boolean generateMapping) {
        this._generateMapping = generateMapping;
    }

    public final void setTestable(boolean testable) {
        this._testable = testable;
    }

    public final void setBinding(ExtendedBinding binding) {
        if (binding != null) {
            this.processNamespaces(binding.getPackage());
        }
        this._bindingComponent.setBinding(binding);
    }

    public final void setBinding(String fileName) {
        try {
            ExtendedBinding binding = BindingLoader.createBinding(fileName);
            this.setBinding(binding);
        }
        catch (BindingException e) {
            String err = "Unable to load a binding file due to the following:\n" + e.getMessage() + "\nThe Source Generator will continue with no binding file.";
            this._dialog.notify(err);
        }
    }

    public final void setBinding(InputSource source) {
        try {
            ExtendedBinding binding = BindingLoader.createBinding(source);
            this.setBinding(binding);
        }
        catch (BindingException e) {
            String err = "unable to load a binding file due to the following:\n" + e.getMessage() + "\nThe Source Generator will continue with no binding file.";
            this._dialog.notify(err);
        }
    }

    public final void setLineSeparator(String lineSeparator) {
        this._singleClassGenerator.setLineSeparator(lineSeparator);
    }

    public final boolean mappingSchemaElement2Java() {
        BindingType type;
        ExtendedBinding binding;
        if (this._bindingComponent != null && (binding = this._bindingComponent.getBinding()) != null && (type = binding.getDefaultBindingType()) != null) {
            return type.getType() == 0;
        }
        return super.mappingSchemaElement2Java();
    }

    public final boolean mappingSchemaType2Java() {
        BindingType type;
        ExtendedBinding binding;
        if (this._bindingComponent != null && (binding = this._bindingComponent.getBinding()) != null && (type = binding.getDefaultBindingType()) != null) {
            return type.getType() == 1;
        }
        return super.mappingSchemaType2Java();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateSource(String filename, String packageName) throws IOException {
        File schemaFile = filename.startsWith("./") ? new File(filename.substring(2)) : new File(filename);
        FileReader reader = new FileReader(schemaFile);
        try {
            InputSource source = new InputSource(reader);
            source.setSystemId(SourceGenerator.toURIRepresentation(schemaFile.getAbsolutePath()));
            this.generateSource(source, packageName);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iox) {}
        }
    }

    public final void generateSource(Reader reader, String packageName) throws IOException {
        InputSource source = new InputSource(reader);
        this.generateSource(source, packageName);
    }

    public void generateSource(InputSource source, String packageName) throws IOException {
        Parser parser = null;
        try {
            parser = this._config.getParser();
        }
        catch (RuntimeException rte) {
            // empty catch block
        }
        if (parser == null) {
            this._dialog.notify("fatal error: unable to create SAX parser.");
            return;
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            schemaUnmarshaller = new SchemaUnmarshaller();
        }
        catch (XMLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Sax2ComponentReader handler = new Sax2ComponentReader((ComponentReader)schemaUnmarshaller);
        parser.setDocumentHandler((DocumentHandler)handler);
        parser.setErrorHandler((ErrorHandler)handler);
        try {
            parser.parse(source);
        }
        catch (IOException ioe) {
            this._dialog.notify("error reading XML Schema file");
            if (this._failOnFirstError) {
                throw ioe;
            }
            return;
        }
        catch (SAXException sx) {
            Exception except = sx.getException();
            if (except == null) {
                except = sx;
            }
            if (except instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)except;
                this._dialog.notify("SAXParseException: " + spe);
                this._dialog.notify(" - occured at line ");
                this._dialog.notify(Integer.toString(spe.getLineNumber()));
                this._dialog.notify(", column ");
                this._dialog.notify(Integer.toString(spe.getColumnNumber()));
            } else {
                except.printStackTrace();
            }
            if (this._failOnFirstError) {
                String msg = "Source Generator: schema parser threw an Exception";
                throw new CastorRuntimeException(msg, (Throwable)sx);
            }
            return;
        }
        Schema schema = schemaUnmarshaller.getSchema();
        try {
            schema.validate();
        }
        catch (ValidationException vx) {
            throw new NestedIOException((Exception)((Object)vx));
        }
        this.generateSource(schema, packageName);
    }

    public final void generateSource(Schema schema, String packageName) throws IOException {
        if (schema == null) {
            throw new IllegalArgumentException("The argument 'schema' must not be null.");
        }
        try {
            schema.validate();
        }
        catch (ValidationException ve) {
            String err = "The schema: " + schema.getSchemaLocation() + " is not valid.\n" + ve.getMessage();
            throw new IllegalArgumentException(err);
        }
        if (this._sourceFactory == null) {
            this._sourceFactory = new SourceFactory(this, this._infoFactory, this._groupNaming, this);
            this._sourceFactory.setCreateMarshalMethods(this._createMarshalMethods);
            this._sourceFactory.setTestable(this._testable);
            this._sourceFactory.setSAX1(this._sax1);
            this._sourceFactory.setCaseInsensitive(this._caseInsensitive);
        }
        SGStateInfo sInfo = new SGStateInfo(schema, this);
        sInfo.setPackageName(packageName);
        sInfo.setDialog((Dialog)this._dialog);
        sInfo.setVerbose(this._verbose);
        sInfo.setSuppressNonFatalWarnings(this._suppressNonFatalWarnings);
        if (packageName != null) {
            super.setLocationPackageMapping(schema.getSchemaLocation(), packageName);
        }
        this._schemasProcessed.clear();
        this.generateAllClassFiles(schema, sInfo);
        if (!this._createDescriptors && this._generateMapping) {
            this.generateMappingFile(packageName, sInfo);
        }
        if (this.isAutomaticConflictResolution()) {
            this._xmlInfoRegistry.printStatistics(this._bindingComponent);
        }
    }

    private void generateAllClassFiles(Schema schema, SGStateInfo sInfo) throws IOException {
        if (this._generateImported) {
            this.processImportedSchemas(schema, sInfo);
        }
        Enumeration structures = schema.getElementDecls();
        while (structures.hasMoreElements()) {
            ElementDecl element = (ElementDecl)structures.nextElement();
            this._xmlInfoRegistry.prebindGlobalElement(XPathHelper.getSchemaLocation((Structure)element));
        }
        structures = schema.getModelGroups();
        while (structures.hasMoreElements()) {
            ModelGroup modelGroup = (ModelGroup)structures.nextElement();
            this._xmlInfoRegistry.prebindGlobalElement(XPathHelper.getSchemaLocation((Structure)modelGroup));
        }
        structures = schema.getElementDecls();
        while (structures.hasMoreElements()) {
            this.createClasses((ElementDecl)structures.nextElement(), sInfo);
        }
        structures = schema.getComplexTypes();
        while (structures.hasMoreElements()) {
            this.processComplexType((ComplexType)structures.nextElement(), sInfo);
        }
        structures = schema.getSimpleTypes();
        while (structures.hasMoreElements()) {
            this.processSimpleType((SimpleType)structures.nextElement(), sInfo);
        }
        structures = schema.getModelGroups();
        while (structures.hasMoreElements()) {
            this.createClasses((Group)((ModelGroup)structures.nextElement()), sInfo);
        }
        this._singleClassGenerator.processIfNotAlreadyProcessed(sInfo.keys(), sInfo);
        Enumeration cdrFiles = sInfo.getCDRFilenames();
        while (cdrFiles.hasMoreElements()) {
            String filename = (String)cdrFiles.nextElement();
            Properties props = sInfo.getCDRFile(filename);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(filename));
            props.store(fileOutputStream, null);
            fileOutputStream.close();
        }
    }

    private void processImportedSchemas(Schema schema, SGStateInfo sInfo) throws IOException {
        Enumeration enumeration = schema.getImportedSchema();
        while (enumeration.hasMoreElements()) {
            Schema importedSchema = (Schema)enumeration.nextElement();
            if (!this._generateImported) {
                LOG.warn((Object)(IMPORT_WARNING + importedSchema.getSchemaLocation()));
                continue;
            }
            this._schemasProcessed.add(schema);
            if (this._schemasProcessed.contains(importedSchema)) continue;
            SGStateInfo importedSInfo = new SGStateInfo(importedSchema, this);
            String packageName = sInfo.getPackageName();
            importedSInfo.setPackageName(packageName);
            if (packageName != null) {
                this.setLocationPackageMapping(importedSchema.getSchemaLocation(), packageName);
            }
            this.generateAllClassFiles(importedSchema, importedSInfo);
            sInfo.storeImportedSourcesByName(importedSInfo.getSourcesByName());
            sInfo.storeImportedSourcesByName(importedSInfo.getImportedSourcesByName());
            importedSInfo = null;
        }
    }

    private void generateMappingFile(String packageName, SGStateInfo sInfo) throws IOException {
        String pkg = packageName != null ? packageName : "";
        MappingRoot mapping = sInfo.getMapping(pkg);
        if (mapping == null) {
            return;
        }
        FileWriter writer = new FileWriter(this._mappingFilename);
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setSuppressNamespaces(true);
            marshaller.marshal((Object)mapping);
        }
        catch (Exception ex) {
            throw new NestedIOException(ex);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void createClasses(ElementDecl elementDecl, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || elementDecl == null) {
            return;
        }
        XMLType xmlType = elementDecl.getType();
        if (this.mappingSchemaType2Java() && (elementDecl.isReference() || xmlType != null && xmlType.getName() != null)) {
            return;
        }
        this._bindingComponent.setView((Annotated)elementDecl);
        ClassInfo cInfo = sInfo.resolve(elementDecl);
        if (cInfo != null && cInfo.getJClass() != null) {
            JClass jClass = cInfo.getJClass();
            if (sInfo.processed(jClass)) {
                return;
            }
            jClass = null;
        }
        if (xmlType == null) {
            if (sInfo.verbose()) {
                String msg = "No type found for element: " + elementDecl.getName();
                sInfo.getDialog().notify(msg);
            }
            return;
        }
        if (xmlType.isComplexType()) {
            JClass[] classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo);
            if (!this._singleClassGenerator.process(classes, sInfo)) {
                return;
            }
            if (xmlType.getSchema() == this._bindingComponent.getSchema()) {
                this.processComplexType((ComplexType)xmlType, sInfo);
            }
        } else if (xmlType.isSimpleType()) {
            this.processSimpleType((SimpleType)xmlType, sInfo);
        }
    }

    private void createClasses(Group group, SGStateInfo sInfo) throws IOException {
        if (group == null) {
            return;
        }
        if (group.getParticleCount() == 0) {
            if (group instanceof ModelGroup) {
                ModelGroup mg = (ModelGroup)group;
                if (mg.isReference() && (mg = mg.getReference()).getParticleCount() == 0) {
                    return;
                }
            } else {
                return;
            }
        }
        this._bindingComponent.setView((Annotated)group);
        JClass[] classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo);
        this.processContentModel((ContentModelGroup)group, sInfo);
        this._singleClassGenerator.process(classes, sInfo);
    }

    private void processComplexType(ComplexType complexType, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || complexType == null) {
            return;
        }
        this._bindingComponent.setView((Annotated)complexType);
        ClassInfo classInfo = sInfo.resolve(complexType);
        if (classInfo == null) {
            JClass[] classes;
            if (complexType.isTopLevel() && !this._singleClassGenerator.process(classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo), sInfo)) {
                return;
            }
            this.processAttributes(complexType, sInfo);
            ContentType temp = complexType.getContentType();
            if (temp.getType() == 4) {
                this.processSimpleType(((SimpleContent)temp).getSimpleType(), sInfo);
            }
            this.processContentModel((ContentModelGroup)complexType, sInfo);
        } else {
            JClass jClass = classInfo.getJClass();
            if (!sInfo.processed(jClass)) {
                this.processAttributes(complexType, sInfo);
                this.processContentModel((ContentModelGroup)complexType, sInfo);
                this._singleClassGenerator.process(jClass, sInfo);
            }
        }
    }

    private void processAttributes(ComplexType complexType, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || complexType == null) {
            return;
        }
        Enumeration enumeration = complexType.getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            AttributeDecl attribute = (AttributeDecl)enumeration.nextElement();
            this.processSimpleType(attribute.getSimpleType(), sInfo);
        }
    }

    private void processContentModel(ContentModelGroup cmGroup, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || cmGroup == null) {
            return;
        }
        Enumeration enumeration = cmGroup.enumerate();
        while (enumeration.hasMoreElements()) {
            Structure struct = (Structure)enumeration.nextElement();
            switch (struct.getStructureType()) {
                case 8: {
                    ElementDecl eDecl = (ElementDecl)struct;
                    if (eDecl.isReference()) break;
                    this.createClasses(eDecl, sInfo);
                    break;
                }
                case 10: {
                    this.processContentModel((ContentModelGroup)((Group)struct), sInfo);
                    if (cmGroup instanceof ComplexType || cmGroup instanceof ModelGroup) break;
                    this.createClasses((Group)struct, sInfo);
                    break;
                }
            }
        }
    }

    private void processSimpleType(SimpleType simpleType, SGStateInfo sInfo) throws IOException {
        if (sInfo.getStatusCode() == 1 || simpleType == null || simpleType.getSchema() != sInfo.getSchema()) {
            return;
        }
        if (simpleType.hasFacet("enumeration")) {
            ClassInfo classInfo = sInfo.resolve(simpleType);
            if (classInfo == null) {
                JClass jClass = this._sourceFactory.createSourceCode(this._bindingComponent.getBinding(), simpleType, sInfo);
                this._singleClassGenerator.process(jClass, sInfo);
            } else {
                JClass jClass = classInfo.getJClass();
                this._singleClassGenerator.process(jClass, sInfo);
            }
        }
    }

    private void processNamespaces(PackageType[] packages) {
        if (packages.length == 0) {
            return;
        }
        for (int i = 0; i < packages.length; ++i) {
            PackageType temp = packages[i];
            PackageTypeChoice choice = temp.getPackageTypeChoice();
            if (choice.getNamespace() != null) {
                super.setNamespacePackageMapping(choice.getNamespace(), temp.getName());
                continue;
            }
            if (choice.getSchemaLocation() == null) continue;
            String tempLocation = choice.getSchemaLocation();
            String currentDir = System.getProperty("user.dir");
            currentDir = currentDir.replace('\\', '/');
            if (tempLocation.startsWith("./")) {
                tempLocation = tempLocation.substring(1);
                tempLocation = currentDir + tempLocation;
            } else if (tempLocation.startsWith("../")) {
                tempLocation = tempLocation.substring("../".length());
                int lastDir = currentDir.lastIndexOf(47);
                currentDir = currentDir.substring(0, lastDir + 1);
                tempLocation = currentDir + tempLocation;
            }
            super.setLocationPackageMapping(tempLocation, temp.getName());
            currentDir = null;
            tempLocation = null;
        }
    }

    public static String toURIRepresentation(String path) {
        String result = path;
        if (!new File(result).isAbsolute()) {
            throw new IllegalArgumentException("The parameter must represent an absolute path.");
        }
        if (File.separatorChar != '/') {
            result = result.replace(File.separatorChar, '/');
        }
        result = result.startsWith("/") ? "file://" + result : "file:///" + result;
        return result;
    }

    public static void main(String[] args) {
        LOG.info((Object)"org.exolab.castor.builder.SourceGenerator.main() is deprecated. Please use org.exolab.castor.builder.SourceGeneratorMain#main() instead.");
        SourceGeneratorMain.main(args);
    }

    public JClassRegistry getXMLInfoRegistry() {
        return this._xmlInfoRegistry;
    }
}

