/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.descriptors;

import java.util.Iterator;
import java.util.List;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.descriptors.DescriptorJClass;
import org.exolab.castor.builder.factory.XMLFieldHandlerFactory;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.types.XSListType;
import org.exolab.castor.builder.types.XSType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JPrimitiveType;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class DescriptorSourceFactory {
    private static final JClass GENERALIZED_FIELD_HANDLER_CLASS = new JClass("org.exolab.castor.mapping.GeneralizedFieldHandler");
    private static final String FIELD_VALIDATOR_NAME = "fieldValidator";
    private final BuilderConfiguration _config;
    private XMLFieldHandlerFactory _xmlFieldHandlerFactory;

    public DescriptorSourceFactory(BuilderConfiguration config) {
        if (config == null) {
            String err = "The argument 'config' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._config = config;
        this._xmlFieldHandlerFactory = new XMLFieldHandlerFactory(config);
    }

    public JClass createSource(ClassInfo classInfo) {
        String xmlName;
        String nsURI;
        JClass jClass = classInfo.getJClass();
        String localClassName = jClass.getLocalName();
        String descriptorClassName = this.getQualifiedDescriptorClassName(jClass.getName());
        DescriptorJClass classDesc = new DescriptorJClass(this._config, descriptorClassName, jClass);
        JConstructor cons = classDesc.getConstructor(0);
        JSourceCode jsc = cons.getSourceCode();
        String nsPrefix = classInfo.getNamespacePrefix();
        if (nsPrefix != null && nsPrefix.length() > 0) {
            jsc.add("_nsPrefix = \"");
            jsc.append(nsPrefix);
            jsc.append("\";");
        }
        if ((nsURI = classInfo.getNamespaceURI()) != null && nsURI.length() > 0) {
            jsc.add("_nsURI = \"");
            jsc.append(nsURI);
            jsc.append("\";");
        }
        if ((xmlName = classInfo.getNodeName()) != null) {
            jsc.add("_xmlName = \"");
            jsc.append(xmlName);
            jsc.append("\";");
        }
        boolean elementDefinition = classInfo.isElementDefinition();
        jsc.add("_elementDefinition = ");
        jsc.append(new Boolean(elementDefinition).toString());
        jsc.append(";");
        if (classInfo.isChoice()) {
            jsc.add("");
            jsc.add("//-- set grouping compositor");
            jsc.add("setCompositorAsChoice();");
        } else if (classInfo.isSequence()) {
            jsc.add("");
            jsc.add("//-- set grouping compositor");
            jsc.add("setCompositorAsSequence();");
        }
        List substitutionGroups = classInfo.getSubstitutionGroups();
        if (!substitutionGroups.isEmpty()) {
            jsc.add("java.util.List substitutionGroupes = new java.util.ArrayList();");
            Iterator substitutionGroupIter = substitutionGroups.iterator();
            while (substitutionGroupIter.hasNext()) {
                String substitutionGroup = (String)substitutionGroupIter.next();
                jsc.add("substitutionGroupes.add(\"");
                jsc.append(substitutionGroup);
                jsc.append("\");");
            }
            jsc.add("setSubstitutes(substitutionGroupes);");
        }
        if (classInfo.getFieldCount() == 0) {
            return classDesc;
        }
        jsc.add("org.exolab.castor.xml.util.XMLFieldDescriptorImpl  desc           = null;");
        jsc.add("org.exolab.castor.mapping.FieldHandler             handler        = null;");
        jsc.add("org.exolab.castor.xml.FieldValidator               fieldValidator = null;");
        if (classInfo.allowContent()) {
            this.createDescriptor(classDesc, classInfo.getTextField(), localClassName, null, jsc);
        }
        ClassInfo base = classInfo.getBaseClass();
        FieldInfo[] atts = classInfo.getAttributeFields();
        jsc.add("//-- initialize attribute descriptors");
        jsc.add("");
        for (int i = 0; i < atts.length; ++i) {
            FieldInfo member = atts[i];
            if (member.isTransient()) continue;
            if (base != null) {
                String baseNodeName = member.getNodeName();
                if (baseNodeName.equals("-error-if-this-is-used-")) {
                    this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                    continue;
                }
                if (base.getAttributeField(baseNodeName) != null) {
                    DescriptorSourceFactory.createRestrictedDescriptor(member, jsc);
                    continue;
                }
                this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                continue;
            }
            this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
        }
        FieldInfo[] elements = classInfo.getElementFields();
        jsc.add("//-- initialize element descriptors");
        jsc.add("");
        for (int i = 0; i < elements.length; ++i) {
            FieldInfo member = elements[i];
            if (member.isTransient()) continue;
            if (base != null) {
                String baseNodeName = member.getNodeName();
                if (baseNodeName == null) {
                    this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                    continue;
                }
                if (baseNodeName.equals("-error-if-this-is-used-")) {
                    this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                    continue;
                }
                if (base.getElementField(baseNodeName) != null) {
                    DescriptorSourceFactory.createRestrictedDescriptor(member, jsc);
                    continue;
                }
                this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
                continue;
            }
            this.createDescriptor(classDesc, member, localClassName, nsURI, jsc);
        }
        return classDesc;
    }

    private String getQualifiedDescriptorClassName(String name) {
        String descPackage = JNaming.getPackageFromClassName(name);
        String descClassName = JNaming.getLocalNameFromClassName(name);
        descPackage = descPackage != null && descPackage.length() > 0 ? descPackage + "." + "descriptors" + "." : "";
        return descPackage + descClassName + "Descriptor";
    }

    private static void createRestrictedDescriptor(FieldInfo member, JSourceCode jsc) {
        jsc.add("desc = (org.exolab.castor.xml.util.XMLFieldDescriptorImpl) getFieldDescriptor(\"");
        jsc.append(member.getNodeName());
        jsc.append("\"");
        jsc.append(", _nsURI");
        if (member.getNodeType() == 1) {
            jsc.append(", org.exolab.castor.xml.NodeType.Element);");
        } else if (member.getNodeType() == 0) {
            jsc.append(", org.exolab.castor.xml.NodeType.Attribute);");
        } else {
            jsc.append("org.exolab.castor.xml.NodeType.Text);");
        }
        DescriptorSourceFactory.addValidationCode(member, jsc);
    }

    private void createDescriptor(DescriptorJClass classDesc, FieldInfo member, String localClassName, String nsURI, JSourceCode jsc) {
        XSType xsType = member.getSchemaType();
        boolean any = false;
        boolean isElement = member.getNodeType() == 1;
        boolean isAttribute = member.getNodeType() == 0;
        boolean isText = member.getNodeType() == 2;
        jsc.add("//-- ");
        jsc.append(member.getName());
        if (member.getName().equals("_anyObject")) {
            any = true;
        }
        if (xsType.isCollection()) {
            xsType = ((CollectionInfo)member).getContent().getSchemaType();
        }
        String nodeName = member.getNodeName();
        String nodeNameParam = null;
        if (nodeName != null && !isText) {
            nodeNameParam = "\"" + nodeName + "\"";
            if (this._config.classDescFieldNames()) {
                nodeNameParam = member.getNodeName().toUpperCase();
                JModifiers publicStaticFinal = new JModifiers();
                publicStaticFinal.makePublic();
                publicStaticFinal.setStatic(true);
                publicStaticFinal.setFinal(true);
                JField jField = new JField(SGTypes.STRING, nodeNameParam);
                jField.setModifiers(publicStaticFinal);
                jField.setInitString("\"" + nodeName + "\"");
                classDesc.addMember(jField);
            }
        }
        jsc.add("desc = new org.exolab.castor.xml.util.XMLFieldDescriptorImpl(");
        jsc.append(DescriptorSourceFactory.classType(xsType.getJType()));
        jsc.append(", \"");
        jsc.append(member.getName());
        jsc.append("\", ");
        if (nodeNameParam != null) {
            jsc.append(nodeNameParam);
        } else if (isText) {
            jsc.append("\"PCDATA\"");
        } else {
            jsc.append("(java.lang.String) null");
        }
        if (isElement) {
            jsc.append(", org.exolab.castor.xml.NodeType.Element);");
        } else if (isAttribute) {
            jsc.append(", org.exolab.castor.xml.NodeType.Attribute);");
        } else if (isText) {
            jsc.append(", org.exolab.castor.xml.NodeType.Text);");
        }
        switch (xsType.getType()) {
            case 1: {
                jsc.add("desc.setImmutable(true);");
                break;
            }
            case 26: {
                jsc.add("desc.setReference(true);");
                break;
            }
            case 25: {
                jsc.add("this._identity = desc;");
                break;
            }
            case 18: {
                jsc.add("desc.setSchemaType(\"QName\");");
                break;
            }
        }
        if (member.getXMLFieldHandler() != null) {
            String handler = member.getXMLFieldHandler();
            jsc.add("handler = new " + handler + "();");
            jsc.add("//-- test for generalized field handler");
            jsc.add("if (handler instanceof ");
            jsc.append(GENERALIZED_FIELD_HANDLER_CLASS.getName());
            jsc.append(")");
            jsc.add("{");
            jsc.indent();
            jsc.add("//-- save reference to user-specified handler");
            jsc.add(GENERALIZED_FIELD_HANDLER_CLASS.getName());
            jsc.append(" gfh = (");
            jsc.append(GENERALIZED_FIELD_HANDLER_CLASS.getName());
            jsc.append(") handler;");
            this._xmlFieldHandlerFactory.createXMLFieldHandler(member, xsType, localClassName, jsc, true);
            jsc.add("gfh.setFieldHandler(handler);");
            jsc.add("handler = gfh;");
            jsc.unindent();
            jsc.add("}");
        } else {
            this._xmlFieldHandlerFactory.createXMLFieldHandler(member, xsType, localClassName, jsc, false);
            this.addSpecialHandlerLogic(member, xsType, jsc);
        }
        jsc.add("desc.setSchemaType(\"" + xsType.getName() + "\");");
        jsc.add("desc.setHandler(handler);");
        if (member.isContainer()) {
            jsc.add("desc.setContainer(true);");
            String className = xsType.getName();
            if (className.equals(localClassName)) {
                jsc.add("desc.setClassDescriptor(this);");
            } else {
                String descriptorClassName = this.getQualifiedDescriptorClassName(className);
                jsc.add("desc.setClassDescriptor(new " + descriptorClassName + "());");
            }
        }
        if (member.getNamespaceURI() != null) {
            jsc.add("desc.setNameSpaceURI(\"");
            jsc.append(member.getNamespaceURI());
            jsc.append("\");");
        }
        if (member.isRequired()) {
            jsc.add("desc.setRequired(true);");
        }
        if (member.isNillable()) {
            jsc.add("desc.setNillable(true);");
        }
        if (any) {
            jsc.add("desc.setMatches(\"*\");");
        }
        if (isElement || isAttribute) {
            jsc.add("desc.setMultivalued(" + member.isMultivalued());
            jsc.append(");");
        }
        jsc.add("addFieldDescriptor(desc);");
        if (isElement) {
            jsc.add("addSequenceElement(desc);");
        }
        jsc.add("");
        if (isElement) {
            List substitutionGroupMembers = member.getSubstitutionGroupMembers();
            jsc.add("java.util.List substitutionGroupes" + member.getName() + " = new java.util.ArrayList();");
            Iterator substitutionGroupIter = substitutionGroupMembers.iterator();
            while (substitutionGroupIter.hasNext()) {
                String substitutionGroup = (String)substitutionGroupIter.next();
                jsc.add("substitutionGroupes" + member.getName() + ".add(\"");
                jsc.append(substitutionGroup);
                jsc.append("\");");
            }
            jsc.add("desc.setSubstitutes(substitutionGroupes" + member.getName() + ");");
        }
        DescriptorSourceFactory.addValidationCode(member, jsc);
    }

    private void addSpecialHandlerLogic(FieldInfo member, XSType xsType, JSourceCode jsc) {
        if (xsType.isEnumerated()) {
            jsc.add("handler = new org.exolab.castor.xml.handlers.EnumFieldHandler(");
            jsc.append(DescriptorSourceFactory.classType(xsType.getJType()));
            jsc.append(", handler);");
            jsc.add("desc.setImmutable(true);");
        } else if (xsType.getType() == 3) {
            jsc.add("handler = new org.exolab.castor.xml.handlers.DateFieldHandler(");
            jsc.append("handler);");
            jsc.add("desc.setImmutable(true);");
        } else if (xsType.getType() == 16) {
            jsc.add("desc.setImmutable(true);");
        } else if (member.getSchemaType().isCollection()) {
            switch (xsType.getType()) {
                case 30: 
                case 31: {
                    jsc.add("handler = new org.exolab.castor.xml.handlers.CollectionFieldHandler(");
                    jsc.append("handler, new org.exolab.castor.xml.validators.NameValidator(");
                    jsc.append("org.exolab.castor.xml.XMLConstants.NAME_TYPE_NMTOKEN));");
                    break;
                }
                case 18: {
                    jsc.add("handler = new org.exolab.castor.xml.handlers.CollectionFieldHandler(");
                    jsc.append("handler, null);");
                    break;
                }
                case 26: 
                case 27: {
                    jsc.add("desc.setMultivalued(");
                    jsc.append("" + member.isMultivalued());
                    jsc.append(");");
                    break;
                }
            }
        }
    }

    private static void addValidationCode(FieldInfo member, JSourceCode jsc) {
        if (member == null || jsc == null) {
            return;
        }
        jsc.add("//-- validation code for: ");
        jsc.append(member.getName());
        String validator = member.getValidator();
        if (validator != null && validator.length() > 0) {
            jsc.add("fieldValidator = new " + validator + "();");
        } else {
            jsc.add("fieldValidator = new org.exolab.castor.xml.FieldValidator();");
            if (member.getName().equals("_anyObject")) {
                jsc.add("desc.setValidator(fieldValidator);");
                return;
            }
            XSType xsType = member.getSchemaType();
            if (xsType.isCollection()) {
                XSListType xsList = (XSListType)xsType;
                jsc.add("fieldValidator.setMinOccurs(");
                jsc.append(Integer.toString(xsList.getMinimumSize()));
                jsc.append(");");
                if (xsList.getMaximumSize() > 0) {
                    jsc.add("fieldValidator.setMaxOccurs(");
                    jsc.append(Integer.toString(xsList.getMaximumSize()));
                    jsc.append(");");
                }
            } else if (member.isRequired()) {
                jsc.add("fieldValidator.setMinOccurs(1);");
            }
            jsc.add("{ //-- local scope");
            jsc.indent();
            xsType.validationCode(jsc, member.getFixedValue(), FIELD_VALIDATOR_NAME);
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add("desc.setValidator(fieldValidator);");
    }

    private static String classType(JType jType) {
        if (jType.isPrimitive()) {
            JPrimitiveType primitive = (JPrimitiveType)jType;
            return primitive.getWrapperName() + ".TYPE";
        }
        return jType.toString() + ".class";
    }
}

