/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.conflictresolution.ClassNameCRStrategy;
import org.exolab.castor.builder.conflictresolution.ClassNameCRStrategyRegistry;
import org.exolab.castor.builder.descriptors.DescriptorSourceFactory;
import org.exolab.castor.builder.factory.MappingFileSourceFactory;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.util.dialog.ConsoleDialog;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JNaming;

public final class SingleClassGenerator {
    private static final String DEFAULT_HEADER = "This class was automatically generated with \n<a href=\"http://www.castor.org\">Castor 1.1.1</a>, using an XML Schema.\n$Id$";
    private static final String CDR_FILE = ".castor.cdr";
    private boolean _promptForOverwrite = true;
    private String _destDir = null;
    private String _lineSeparator = null;
    private boolean _createDescriptors = true;
    private final JComment _header;
    private final ConsoleDialog _dialog;
    private final DescriptorSourceFactory _descSourceFactory;
    private final MappingFileSourceFactory _mappingSourceFactory;
    private final SourceGenerator _sourceGenerator;
    private ClassNameCRStrategy _conflictStrategy;
    private ClassNameCRStrategyRegistry _classNameConflictResolutionStrategyRegistry;

    public SingleClassGenerator(ConsoleDialog dialog, SourceGenerator sourceGenerator, String conflictStrategyType) {
        this._dialog = dialog;
        this._sourceGenerator = sourceGenerator;
        this._header = new JComment(3);
        this._header.appendComment(DEFAULT_HEADER);
        this._descSourceFactory = new DescriptorSourceFactory(this._sourceGenerator);
        this._mappingSourceFactory = new MappingFileSourceFactory(this._sourceGenerator);
        String strategy = sourceGenerator.getProperty("org.exolab.castor.builder.nameConflictStrategies", "");
        this._classNameConflictResolutionStrategyRegistry = new ClassNameCRStrategyRegistry(strategy);
        this.createNameConflictStrategy(conflictStrategyType);
    }

    public void setDestDir(String destDir) {
        this._destDir = destDir;
    }

    public void setLineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator;
    }

    public void setDescriptorCreation(boolean createDescriptors) {
        this._createDescriptors = createDescriptors;
    }

    public void setPromptForOverwrite(boolean promptForOverwrite) {
        this._promptForOverwrite = promptForOverwrite;
    }

    boolean processIfNotAlreadyProcessed(Enumeration classKeys, SGStateInfo state) throws IOException {
        while (classKeys.hasMoreElements()) {
            ClassInfo classInfo = state.resolve(classKeys.nextElement());
            JClass jClass = classInfo.getJClass();
            if (state.processed(jClass)) continue;
            this.process(jClass, state);
            if (state.getStatusCode() != 1) continue;
            return false;
        }
        return true;
    }

    boolean process(JClass[] classes, SGStateInfo state) throws IOException {
        for (int i = 0; i < classes.length; ++i) {
            this.process(classes[i], state);
            if (state.getStatusCode() != 1) continue;
            return false;
        }
        return true;
    }

    boolean process(JClass jClass, SGStateInfo state) throws IOException {
        if (state.getStatusCode() == 1) {
            return false;
        }
        if (state.processed(jClass)) {
            return true;
        }
        this.checkNameNotReserved(jClass.getName(), state);
        ClassInfo classInfo = state.resolve(jClass);
        JClass conflict = state.getProcessed(jClass.getName());
        if (conflict != null && !state.getSuppressNonFatalWarnings()) {
            SGStateInfo stateAfterResolution = this._conflictStrategy.dealWithClassNameConflict(state, classInfo, conflict);
            return stateAfterResolution.getStatusCode() != 1;
        }
        state.markAsProcessed(jClass);
        if (this.checkAllowPrinting(jClass)) {
            jClass.removeImport("org.exolab.castor.types.Date");
            jClass.setHeader(this._header);
            jClass.print(this._destDir, this._lineSeparator);
        }
        if (classInfo != null) {
            this.processClassDescriptor(jClass, state, classInfo);
        }
        return state.getStatusCode() != 1;
    }

    private void processClassDescriptor(JClass jClass, SGStateInfo state, ClassInfo classInfo) throws IOException {
        if (this._createDescriptors) {
            JClass desc = this._descSourceFactory.createSource(classInfo);
            if (this.checkAllowPrinting(desc)) {
                this.updateCDRFile(jClass, desc, state);
                desc.setHeader(this._header);
                desc.print(this._destDir, this._lineSeparator);
            }
        } else {
            MappingRoot mapping;
            String pkg = state.getPackageName();
            if (pkg == null) {
                pkg = "";
            }
            if ((mapping = state.getMapping(pkg)) == null) {
                mapping = new MappingRoot();
                state.setMapping(pkg, mapping);
            }
            mapping.addClassMapping(this._mappingSourceFactory.createMapping(classInfo));
        }
    }

    private boolean checkAllowPrinting(JClass jClass) {
        if (!this._promptForOverwrite) {
            return true;
        }
        String filename = jClass.getFilename(this._destDir);
        File file = new File(filename);
        if (!file.exists()) {
            return true;
        }
        return this._conflictStrategy.dealWithFileOverwrite(filename);
    }

    private void checkNameNotReserved(String elementName, SGStateInfo sInfo) {
        String warn;
        if (elementName == null) {
            return;
        }
        String nameToCompare = elementName.substring(0, 1).toUpperCase() + elementName.substring(1);
        if (JNaming.isInJavaLang(nameToCompare)) {
            String err = "'" + nameToCompare + "' conflicts with a class in java.lang.* and may cause a conflict during\n" + " compilation. If you get this complaint during compilation, you need to\n" + " use a mapping file or change the name of the schema element.";
            sInfo.getDialog().notify(err);
        }
        if (JNaming.isReservedByCastor(nameToCompare)) {
            warn = "'" + nameToCompare + "' might conflict with a field name used" + " by Castor.  If you get a complaint\nabout a duplicate name, you will" + " need to use a mapping file or change\nthe name of the conflicting" + " schema element.";
            sInfo.getDialog().notify(warn);
        }
        if (JNaming.isReservedByWindows(nameToCompare)) {
            warn = "'" + nameToCompare + "' is reserved by the Windows filesystem and" + " cannot be\nused as a class name.  Windows will not allow you to create" + " a file with this\nname.  You will have to use a mapping file or change" + " the name of the conflicting\nschema element.  For more information," + " see\nhttp://msdn.microsoft.com/library/default.asp?" + "url=/library/en-us/fileio/fs/naming_a_file.asp";
            sInfo.getDialog().notify(warn);
        }
    }

    private void updateCDRFile(JClass jClass, JClass jDesc, SGStateInfo sInfo) throws IOException {
        String entityFilename = jClass.getFilename(this._destDir);
        File file = new File(entityFilename);
        File parentDirectory = file.getParentFile();
        File cdrFile = new File(parentDirectory, CDR_FILE);
        String cdrFilename = cdrFile.getAbsolutePath();
        Properties props = sInfo.getCDRFile(cdrFilename);
        if (props == null) {
            props = new Properties();
            if (cdrFile.exists()) {
                props.load(new FileInputStream(cdrFile));
            }
            sInfo.setCDRFile(cdrFilename, props);
        }
        props.setProperty(jClass.getName(), jDesc.getName());
    }

    public void setNameConflictStrategy(String nameConflictStrategy) {
        this.createNameConflictStrategy(nameConflictStrategy);
    }

    private void createNameConflictStrategy(String nameConflictStrategy) {
        this._conflictStrategy = this._classNameConflictResolutionStrategyRegistry.getClassNameConflictResolutionStrategy(nameConflictStrategy);
        this._conflictStrategy.setConsoleDialog(this._dialog);
        this._conflictStrategy.setSingleClassGenerator(this);
    }

    public SourceGenerator getSourceGenerator() {
        return this._sourceGenerator;
    }
}

