/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.javasource.JAnnotatedElement;
import org.exolab.javasource.JAnnotatedElementHelper;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JInterface;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public abstract class JStructure
extends JType
implements JAnnotatedElement {
    private static final String DEFAULT_HEADER = "$Id$";
    private static final String DEFAULT_VERSION = "$Revision$ $Date$";
    private static final String JSW_SHOULD_NOT_BE_NULL = "argument 'jsw' should not be null.";
    private JComment _header = null;
    private Vector _imports = null;
    private Vector _interfaces = null;
    private JDocComment _jdc = null;
    private JModifiers _modifiers = null;
    private String _packageName = null;
    private JAnnotatedElementHelper _annotatedElement = null;

    protected JStructure(String name) {
        super(name);
        if (!JStructure.isValidClassName(name)) {
            String lname = this.getLocalName();
            String err = "'" + lname + "' is ";
            err = JNaming.isKeyword(lname) ? err + "a reserved word and may not be used as  a class name." : err + "not a valid Java identifier.";
            throw new IllegalArgumentException(err);
        }
        this._packageName = JNaming.getPackageFromClassName(name);
        this._imports = new Vector();
        this._interfaces = new Vector();
        this._jdc = new JDocComment();
        this._modifiers = new JModifiers();
        this._annotatedElement = new JAnnotatedElementHelper();
        this._jdc.addDescriptor(JDocDescriptor.createVersionDesc(DEFAULT_VERSION));
    }

    public abstract void addField(JField var1);

    public abstract void addMember(JMember var1);

    public void addImport(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        String pkgName = JNaming.getPackageFromClassName(className);
        if (pkgName != null) {
            if (pkgName.equals(this._packageName) || pkgName.equals("java.lang")) {
                return;
            }
            for (int i = 0; i < this._imports.size(); ++i) {
                String imp = (String)this._imports.elementAt(i);
                if (imp.equals(className)) {
                    return;
                }
                if (imp.compareTo(className) <= 0) continue;
                this._imports.insertElementAt(className, i);
                return;
            }
            this._imports.addElement(className);
        }
    }

    protected final void addImport(JAnnotation annotation) {
        this.addImport(annotation.getAnnotationType().getName());
    }

    protected final void addImport(JAnnotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            this.addImport(annotations[i].getAnnotationType().getName());
        }
    }

    public final void addInterface(String interfaceName) {
        if (!this._interfaces.contains(interfaceName)) {
            this._interfaces.addElement(interfaceName);
        }
    }

    public final void addInterface(JInterface jInterface) {
        if (jInterface == null) {
            return;
        }
        String interfaceName = jInterface.getName();
        if (!this._interfaces.contains(interfaceName)) {
            this._interfaces.addElement(interfaceName);
        }
    }

    public abstract JField getField(String var1);

    public abstract JField[] getFields();

    public final String getFilename(String destDir) {
        File pathFile;
        String filename = this.getLocalName() + ".java";
        String javaPackagePath = "";
        if (this._packageName != null && this._packageName.length() > 0) {
            javaPackagePath = this._packageName.replace('.', File.separatorChar);
        }
        if (!(pathFile = destDir == null ? new File(javaPackagePath) : new File(destDir, javaPackagePath)).exists()) {
            pathFile.mkdirs();
        }
        if (pathFile.toString().length() > 0) {
            filename = pathFile.toString() + File.separator + filename;
        }
        return filename;
    }

    public final JComment getHeader() {
        return this._header;
    }

    public final Enumeration getImports() {
        return this._imports.elements();
    }

    public final Enumeration getInterfaces() {
        return this._interfaces.elements();
    }

    public final JDocComment getJDocComment() {
        return this._jdc;
    }

    protected final JAnnotatedElementHelper getAnnotatedElementHelper() {
        return this._annotatedElement;
    }

    public final JModifiers getModifiers() {
        return this._modifiers;
    }

    public final String getPackageName() {
        return this._packageName;
    }

    public final String getName(boolean stripPackage) {
        String name = super.getName();
        if (stripPackage) {
            name = JNaming.getLocalNameFromClassName(name);
        }
        return name;
    }

    public final boolean hasImport(String classname) {
        return this._imports.contains(classname);
    }

    public final boolean removeImport(String className) {
        boolean result = false;
        if (className == null) {
            return result;
        }
        if (className.length() == 0) {
            return result;
        }
        result = this._imports.removeElement(className);
        return result;
    }

    public static boolean isValidClassName(String classname) {
        if (classname == null) {
            return false;
        }
        String name = classname;
        int beforeTypeName = name.indexOf("<");
        if (beforeTypeName > 0) {
            name = name.substring(0, beforeTypeName);
        }
        name = JNaming.getLocalNameFromClassName(name);
        return JNaming.isValidJavaIdentifier(name);
    }

    public final void print() {
        this.print(null, null);
    }

    public final void print(String destDir, String lineSeparator) {
        this.getLocalName();
        String filename = this.getFilename(destDir);
        File file = new File(filename);
        JSourceWriter jsw = null;
        try {
            jsw = new JSourceWriter(new FileWriter(file));
        }
        catch (IOException ioe) {
            System.out.println("unable to create class file: " + filename);
            return;
        }
        if (lineSeparator == null) {
            jsw.setLineSeparator(System.getProperty("line.separator"));
        } else {
            jsw.setLineSeparator(lineSeparator);
        }
        this.print(jsw);
        jsw.close();
    }

    public abstract void print(JSourceWriter var1);

    public final void printHeader(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException(JSW_SHOULD_NOT_BE_NULL);
        }
        JComment header = this.getHeader();
        if (header != null) {
            header.print(jsw);
        } else {
            jsw.writeln("/*");
            jsw.writeln(" * $Id$");
            jsw.writeln(" */");
        }
        jsw.writeln();
        jsw.flush();
    }

    public final void printImportDeclarations(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException(JSW_SHOULD_NOT_BE_NULL);
        }
        if (this._imports.size() > 0) {
            jsw.writeln("  //---------------------------------/");
            jsw.writeln(" //- Imported classes and packages -/");
            jsw.writeln("//---------------------------------/");
            jsw.writeln();
            Enumeration enumeration = this._imports.elements();
            while (enumeration.hasMoreElements()) {
                jsw.write("import ");
                jsw.write(enumeration.nextElement());
                jsw.writeln(';');
            }
            jsw.writeln();
            jsw.flush();
        }
    }

    public final void printPackageDeclaration(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException(JSW_SHOULD_NOT_BE_NULL);
        }
        if (this._packageName != null && this._packageName.length() > 0) {
            jsw.write("package ");
            jsw.write(this._packageName);
            jsw.writeln(';');
            jsw.writeln();
        }
        jsw.flush();
    }

    public final void setHeader(JComment comment) {
        this._header = comment;
    }

    public void setPackageName(String packageName) {
        this._packageName = packageName;
        this.changePackage(packageName);
    }

    public final void addAnnotation(JAnnotation annotation) {
        this._annotatedElement.addAnnotation(annotation);
        this.addImport(annotation);
    }

    public final JAnnotation getAnnotation(JAnnotationType annotationType) {
        return this._annotatedElement.getAnnotation(annotationType);
    }

    public final JAnnotation[] getAnnotations() {
        return this._annotatedElement.getAnnotations();
    }

    public final boolean isAnnotationPresent(JAnnotationType annotationType) {
        return this._annotatedElement.isAnnotationPresent(annotationType);
    }

    public final JAnnotation removeAnnotation(JAnnotationType annotationType) {
        return this._annotatedElement.removeAnnotation(annotationType);
    }

    public final boolean hasAnnotations() {
        return this._annotatedElement.hasAnnotations();
    }

    protected final int getInterfaceCount() {
        return this._interfaces.size();
    }

    protected static void printlnWithPrefix(String prefix, String source, JSourceWriter jsw) {
        jsw.write(prefix);
        if (source == null) {
            return;
        }
        char[] chars = source.toCharArray();
        int lastIdx = 0;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch != '\n') continue;
            jsw.write(chars, lastIdx, i - lastIdx + 1);
            lastIdx = i + 1;
            if (i >= chars.length) continue;
            jsw.write(prefix);
        }
        if (lastIdx < chars.length) {
            jsw.write(chars, lastIdx, chars.length - lastIdx);
        }
        jsw.writeln();
    }
}

