/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.math.BigInteger;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSUnsignedLong
extends XSPatternBase {
    private BigInteger _maxInclusive = null;
    private BigInteger _maxExclusive = null;
    private BigInteger _minInclusive = null;
    private BigInteger _minExclusive = null;
    private int _totalDigits = -1;
    private static final JType JTYPE = new JClass("java.math.BigInteger");

    public XSUnsignedLong() {
        super((short)46);
        this.setMinInclusive(BigInteger.valueOf(0L));
        this.setMaxInclusive(new BigInteger("18446744073709551615"));
    }

    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "(\"0\");";
    }

    public JType getJType() {
        return JTYPE;
    }

    public BigInteger getMaxExclusive() {
        return this._maxExclusive;
    }

    public BigInteger getMaxInclusive() {
        return this._maxInclusive;
    }

    public BigInteger getMinExclusive() {
        return this._minExclusive;
    }

    public BigInteger getMinInclusive() {
        return this._minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(BigInteger max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(BigInteger max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(BigInteger min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(BigInteger min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSUnsignedLong.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            BigInteger min;
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(new BigInteger(facet.getValue()));
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(new BigInteger(facet.getValue()));
                continue;
            }
            if ("minExclusive".equals(name)) {
                min = new BigInteger(facet.getValue());
                if (min.compareTo(new BigInteger("-1")) == -1) {
                    throw new IllegalArgumentException("minExclusive must be > -1 for " + this.getName());
                }
                this.setMinExclusive(min);
                continue;
            }
            if ("minInclusive".equals(name)) {
                min = new BigInteger(facet.getValue());
                if (min.compareTo(new BigInteger("0")) == -1) {
                    throw new IllegalArgumentException("minInclusive must be > 0 for " + this.getName());
                }
                this.setMinInclusive(min);
                continue;
            }
            if ("pattern".equals(name)) {
                this.addPattern(facet.getValue());
                continue;
            }
            if ("totalDigits".equals(name)) {
                this.setTotalDigits(facet.toInt());
                continue;
            }
            if ("fractionDigits".equals(name)) {
                if (facet.toInt() == 0) continue;
                throw new IllegalArgumentException("fractionDigits must be 0 for " + this.getName());
            }
            if (!"whiteSpace".equals(name) || facet.getValue().equals("collapse")) continue;
            throw new IllegalArgumentException("Warning: The facet 'whitespace' can only be set to 'collapse' for '" + this.getName() + "'.");
        }
    }

    public String createFromJavaObjectCode(String variableName) {
        return "((java.math.BigInteger) " + variableName + ")";
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.BigIntegerValidator typeValidator = new org.exolab.castor.xml.validators.BigIntegerValidator();");
        if (this._minExclusive != null) {
            jsc.add("java.math.BigInteger min = new java.math.BigInteger(\"");
            jsc.append(this._minExclusive + "\");");
            jsc.add("typeValidator.setMinExclusive(min);");
        } else if (this._minInclusive != null) {
            jsc.add("java.math.BigInteger min = new java.math.BigInteger(\"");
            jsc.append(this._minInclusive + "\");");
            jsc.add("typeValidator.setMinInclusive(min);");
        }
        if (this._maxExclusive != null) {
            jsc.add("java.math.BigInteger max = new java.math.BigInteger(\"");
            jsc.append(this._maxExclusive + "\");");
            jsc.add("typeValidator.setMaxExclusive(max);");
        } else if (this._maxInclusive != null) {
            jsc.add("java.math.BigInteger max = new java.math.BigInteger(\"");
            jsc.append(this._maxInclusive + "\");");
            jsc.add("typeValidator.setMaxInclusive(max);");
        }
        if (fixedValue != null) {
            new BigInteger(fixedValue);
            jsc.add("typeValidator.setFixed(new BigInteger(\"");
            jsc.append(fixedValue);
            jsc.append("\");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        int totalDigits = this.getTotalDigits();
        if (totalDigits != -1) {
            jsc.add("typeValidator.setTotalDigits(");
            jsc.append(Integer.toString(totalDigits));
            jsc.append(");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

