/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSShort
extends XSPatternBase {
    private Short _maxInclusive = null;
    private Short _maxExclusive = null;
    private Short _minInclusive = null;
    private Short _minExclusive = null;
    private int _totalDigits = -1;
    private final JType _jType;
    private final boolean _asWrapper;

    public XSShort() {
        this(false);
    }

    public XSShort(boolean asWrapper) {
        super((short)37);
        this._asWrapper = asWrapper;
        this._jType = asWrapper ? new JClass("java.lang.Short") : JType.SHORT;
    }

    public JType getJType() {
        return this._jType;
    }

    public Short getMaxExclusive() {
        return this._maxExclusive;
    }

    public Short getMaxInclusive() {
        return this._maxInclusive;
    }

    public Short getMinExclusive() {
        return this._minExclusive;
    }

    public Short getMinInclusive() {
        return this._minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(short max) {
        this._maxExclusive = new Short(max);
        this._maxInclusive = null;
    }

    public void setMaxExclusive(Short max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(short max) {
        this._maxInclusive = new Short(max);
        this._maxExclusive = null;
    }

    public void setMaxInclusive(Short max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(short min) {
        this._minExclusive = new Short(min);
        this._minInclusive = null;
    }

    public void setMinExclusive(Short min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(short min) {
        this._minInclusive = new Short(min);
        this._minExclusive = null;
    }

    public void setMinInclusive(Short min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSShort.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toShort());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toShort());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toShort());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toShort());
                continue;
            }
            if ("pattern".equals(name)) {
                this.addPattern(facet.getValue());
                continue;
            }
            if ("totalDigits".equals(name)) {
                this.setTotalDigits(facet.toInt());
                continue;
            }
            if ("fractionDigits".equals(name)) {
                if (facet.toInt() == 0) continue;
                throw new IllegalArgumentException("fractionDigits must be 0 for " + this.getName());
            }
            if (!"whiteSpace".equals(name) || facet.getValue().equals("collapse")) continue;
            throw new IllegalArgumentException("Warning: The facet 'whitespace' can only be set to 'collapse' for '" + this.getName() + "'.");
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("new java.lang.Short(");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Short) ");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".shortValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.ShortValidator typeValidator = new org.exolab.castor.xml.validators.ShortValidator();");
        if (this._minExclusive != null) {
            jsc.add("typeValidator.setMinExclusive((short) " + this._minExclusive + ");");
        } else if (this._minInclusive != null) {
            jsc.add("typeValidator.setMinInclusive((short) " + this._minInclusive + ");");
        }
        if (this._maxExclusive != null) {
            jsc.add("typeValidator.setMaxExclusive((short) " + this._maxExclusive + ");");
        } else if (this._maxInclusive != null) {
            jsc.add("typeValidator.setMaxInclusive((short) " + this._maxInclusive + ");");
        }
        if (fixedValue != null) {
            Short.parseShort(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append("(short)");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        int totalDigits = this.getTotalDigits();
        if (totalDigits != -1) {
            jsc.add("typeValidator.setTotalDigits(");
            jsc.append(Integer.toString(totalDigits));
            jsc.append(");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

