/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSInt
extends XSPatternBase {
    private Integer _maxInclusive = null;
    private Integer _maxExclusive = null;
    private Integer _minInclusive = null;
    private Integer _minExclusive = null;
    private int _totalDigits = -1;
    private final JType _jType;
    private final boolean _asWrapper;

    public XSInt() {
        this(false);
    }

    public XSInt(boolean asWrapper) {
        this(asWrapper, 36);
    }

    protected XSInt(boolean asWrapper, short type) {
        super(type);
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Integer") : JType.INT;
        this.setMinInclusive(Integer.MIN_VALUE);
        this.setMaxInclusive(Integer.MAX_VALUE);
    }

    public JType getJType() {
        return this._jType;
    }

    public Integer getMaxExclusive() {
        return this._maxExclusive;
    }

    public Integer getMaxInclusive() {
        return this._maxInclusive;
    }

    public Integer getMinExclusive() {
        return this._minExclusive;
    }

    public Integer getMinInclusive() {
        return this._minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(int max) {
        this._maxExclusive = new Integer(max);
        this._maxInclusive = null;
    }

    public void setMaxExclusive(Integer max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(int max) {
        this._maxInclusive = new Integer(max);
        this._maxExclusive = null;
    }

    public void setMaxInclusive(Integer max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(int min) {
        this._minExclusive = new Integer(min);
        this._minInclusive = null;
    }

    public void setMinExclusive(Integer min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(int min) {
        this._minInclusive = new Integer(min);
        this._minExclusive = null;
    }

    public void setMinInclusive(Integer min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSInt.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toInt());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toInt());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toInt());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toInt());
                continue;
            }
            if ("pattern".equals(name)) {
                this.addPattern(facet.getValue());
                continue;
            }
            if ("totalDigits".equals(name)) {
                this.setTotalDigits(facet.toInt());
                continue;
            }
            if ("fractionDigits".equals(name)) {
                if (facet.toInt() == 0) continue;
                throw new IllegalArgumentException("fractionDigits must be 0 for " + this.getName());
            }
            if (!"whiteSpace".equals(name) || facet.getValue().equals("collapse")) continue;
            throw new IllegalArgumentException("Warning: The facet 'whitespace' can only be set to 'collapse' for '" + this.getName() + "'.");
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        return "new java.lang.Integer(" + variableName + ")";
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Integer) ");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".intValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.IntValidator typeValidator = new org.exolab.castor.xml.validators.IntValidator();");
        if (this._minExclusive != null) {
            jsc.add("typeValidator.setMinExclusive(" + this._minExclusive + ");");
        } else if (this._minInclusive != null) {
            jsc.add("typeValidator.setMinInclusive(" + this._minInclusive + ");");
        }
        if (this._maxExclusive != null) {
            jsc.add("typeValidator.setMaxExclusive(" + this._maxExclusive + ");");
        } else if (this._maxInclusive != null) {
            jsc.add("typeValidator.setMaxInclusive(" + this._maxInclusive + ");");
        }
        if (fixedValue != null) {
            if (this._jType == JType.INT) {
                Integer.parseInt(fixedValue);
            }
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        int totalDigits = this.getTotalDigits();
        if (totalDigits != -1) {
            jsc.add("typeValidator.setTotalDigits(");
            jsc.append(Integer.toString(totalDigits));
            jsc.append(");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

