/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSByte
extends XSPatternBase {
    private Byte _maxInclusive = null;
    private Byte _maxExclusive = null;
    private Byte _minInclusive = null;
    private Byte _minExclusive = null;
    private int _totalDigits = -1;
    private final JType _jType;
    private final boolean _asWrapper;

    public XSByte() {
        this(false);
    }

    public XSByte(boolean asWrapper) {
        super((short)38);
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Byte") : JType.BYTE;
    }

    public JType getJType() {
        return this._jType;
    }

    public Byte getMaxExclusive() {
        return this._maxExclusive;
    }

    public Byte getMaxInclusive() {
        return this._maxInclusive;
    }

    public Byte getMinExclusive() {
        return this._minExclusive;
    }

    public Byte getMinInclusive() {
        return this._minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public void setMaxExclusive(byte max) {
        this._maxExclusive = new Byte(max);
        this._maxInclusive = null;
    }

    public void setMaxExclusive(Byte max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(byte max) {
        this._maxInclusive = new Byte(max);
        this._maxExclusive = null;
    }

    public void setMaxInclusive(Byte max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(byte min) {
        this._minExclusive = new Byte(min);
        this._minInclusive = null;
    }

    public void setMinExclusive(Byte min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(byte min) {
        this._minInclusive = new Byte(min);
        this._minExclusive = null;
    }

    public void setMinInclusive(Byte min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSByte.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toByte());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toByte());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toByte());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toByte());
                continue;
            }
            if ("pattern".equals(name)) {
                this.addPattern(facet.getValue());
                continue;
            }
            if ("totalDigits".equals(name)) {
                this.setTotalDigits(facet.toInt());
                continue;
            }
            if ("fractionDigits".equals(name)) {
                if (facet.toInt() == 0) continue;
                throw new IllegalArgumentException("fractionDigits must be 0 for " + this.getName());
            }
            if (!"whiteSpace".equals(name) || facet.getValue().equals("collapse")) continue;
            throw new IllegalArgumentException("Warning: The facet 'whitespace' can only be set to 'collapse' for 'byte'.");
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        return "new Byte(" + variableName + ")";
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((Byte) " + variableName + ")");
        if (!this._asWrapper) {
            sb.append(".byteValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.ByteValidator typeValidator = new org.exolab.castor.xml.validators.ByteValidator();");
        if (this._minExclusive != null) {
            jsc.add("typeValidator.setMinExclusive((byte) " + this._minExclusive + ");");
        } else if (this._minInclusive != null) {
            jsc.add("typeValidator.setMinInclusive((byte) " + this._minInclusive + ");");
        }
        if (this._maxExclusive != null) {
            jsc.add("typeValidator.setMaxExclusive((byte) " + this._maxExclusive + ");");
        } else if (this._maxInclusive != null) {
            jsc.add("typeValidator.setMaxInclusive((byte) " + this._maxInclusive + ");");
        }
        if (fixedValue != null) {
            Byte.parseByte(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append("(byte) ");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        int totalDigits = this.getTotalDigits();
        if (totalDigits != -1) {
            jsc.add("typeValidator.setTotalDigits(");
            jsc.append(Integer.toString(totalDigits));
            jsc.append(");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

