/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.conflictresolution;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.conflictresolution.BaseClassNameCRStrategy;
import org.exolab.castor.builder.conflictresolution.ClassNameCRStrategy;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.util.dialog.ConsoleDialog;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.javasource.JClass;

public class InformViaLogClassNameCRStrategy
extends BaseClassNameCRStrategy
implements ClassNameCRStrategy {
    private static final Log LOG = LogFactory.getLog((Class)InformViaLogClassNameCRStrategy.class);
    public static final String NAME = "informViaLog";

    public SGStateInfo dealWithClassNameConflict(SGStateInfo state, ClassInfo newClassInfo, JClass conflict) {
        ClassInfo oldClassInfo = state.resolve(conflict);
        if (oldClassInfo == newClassInfo) {
            return state;
        }
        Annotated a1 = null;
        Annotated a2 = null;
        Enumeration enumeration = state.keys();
        while (enumeration.hasMoreElements() && (a1 == null || a2 == null)) {
            Object key = enumeration.nextElement();
            if (!(key instanceof Annotated)) continue;
            ClassInfo cInfo = state.resolve(key);
            if (newClassInfo == cInfo) {
                a1 = (Annotated)key;
                continue;
            }
            if (oldClassInfo != cInfo) continue;
            a2 = (Annotated)key;
        }
        StringBuffer message = new StringBuffer();
        message.append("Warning: A class name generation conflict has occured between ");
        if (a1 != null) {
            message.append(SchemaNames.getStructureName(a1));
            message.append(" '");
            message.append(ExtendedBinding.getSchemaLocation((Structure)a1));
        } else {
            message.append(newClassInfo.getNodeTypeName());
            message.append(" '");
            message.append(newClassInfo.getNodeName());
        }
        message.append("' and ");
        if (a2 != null) {
            message.append(SchemaNames.getStructureName((Structure)a2));
            message.append(" '");
            message.append(ExtendedBinding.getSchemaLocation((Structure)a2));
        } else {
            message.append(oldClassInfo.getNodeTypeName());
            message.append(" '");
            message.append(oldClassInfo.getNodeName());
        }
        message.append("'. Please use a Binding file to solve this problem.");
        LOG.warn((Object)message);
        return state;
    }

    public String getName() {
        return NAME;
    }

    public void setConsoleDialog(ConsoleDialog dialog) {
    }

    public boolean dealWithFileOverwrite(String filename) {
        LOG.warn((Object)(filename + " already exists, but will be overwritten."));
        return true;
    }
}

