/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.exolab.castor.builder.BaseFactory;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.ClassInfoResolver;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public class MemberFactory
extends BaseFactory {
    public MemberFactory(BuilderConfiguration config, FieldInfoFactory infoFactory, GroupNaming groupNaming) {
        super(config, infoFactory, groupNaming);
        if (this._config.generateExtraCollectionMethods()) {
            this._infoFactory.setCreateExtraMethods(true);
        }
        String suffix = this._config.getProperty("org.exolab.castor.builder.collections.reference.suffix", null);
        this._infoFactory.setReferenceMethodSuffix(suffix);
        if (this._config.boundPropertiesEnabled()) {
            this._infoFactory.setBoundProperties(true);
        }
    }

    public FieldInfo createFieldInfoForAny(Wildcard any, boolean useJava50) {
        String nsURI;
        if (any == null) {
            return null;
        }
        if (any.isAttributeWildcard()) {
            return null;
        }
        XSClass xsType = new XSClass(SGTypes.Object, "any");
        String vName = "_anyObject";
        String xmlName = null;
        FieldInfo result = null;
        if (any.getMaxOccurs() > 1 || any.getMaxOccurs() < 0) {
            result = this._infoFactory.createCollection(xsType, vName, "anyObject", useJava50);
            XSList xsList = ((CollectionInfo)result).getXSList();
            xsList.setMinimumSize(any.getMinOccurs());
            xsList.setMaximumSize(any.getMaxOccurs());
        } else {
            result = this._infoFactory.createFieldInfo(xsType, vName);
        }
        if (any.getMinOccurs() > 0) {
            result.setRequired(true);
        } else {
            result.setRequired(false);
        }
        result.setNodeName(xmlName);
        if (any.getNamespaces().hasMoreElements() && (nsURI = (String)any.getNamespaces().nextElement()).length() > 0) {
            if (nsURI.equals("##targetNamespace")) {
                Schema schema = any.getSchema();
                if (schema != null) {
                    result.setNamespaceURI(schema.getTargetNamespace());
                }
            } else if (!nsURI.startsWith("##")) {
                result.setNamespaceURI(nsURI);
            }
        }
        return result;
    }

    public FieldInfo createFieldInfoForChoiceValue() {
        String fieldName = "_choiceValue";
        XSClass xsType = new XSClass(SGTypes.Object, "any");
        FieldInfo fInfo = null;
        fInfo = this._infoFactory.createFieldInfo(xsType, fieldName);
        fInfo.setNodeType((short)1);
        fInfo.setComment("Internal choice value storage");
        fInfo.setRequired(false);
        fInfo.setTransient(true);
        fInfo.setNodeName("##any");
        fInfo.setMethods(1);
        return fInfo;
    }

    public FieldInfo createFieldInfoForContent(XSType xsType, boolean useJava50) {
        String fieldName = "_content";
        FieldInfo fInfo = null;
        fInfo = xsType.getType() == 45 ? this._infoFactory.createCollection(((XSList)xsType).getContentType(), fieldName, null, useJava50) : this._infoFactory.createFieldInfo(xsType, fieldName);
        fInfo.setNodeType((short)2);
        fInfo.setComment("internal content storage");
        fInfo.setRequired(false);
        fInfo.setNodeName("#text");
        if (xsType instanceof XSString) {
            fInfo.setDefaultValue("\"\"");
        }
        return fInfo;
    }

    public FieldInfo createFieldInfo(XMLBindingComponent component, ClassInfoResolver resolver, boolean useJava50) {
        String comment;
        String xmlName = component.getXMLName();
        String memberName = component.getJavaMemberName();
        if (!memberName.startsWith("_")) {
            memberName = "_" + memberName;
        }
        XMLType xmlType = component.getXMLType();
        ClassInfo classInfo = resolver.resolve(component);
        XSType xsType = null;
        FieldInfo fieldInfo = null;
        boolean enumeration = false;
        boolean simpleTypeCollection = false;
        if (xmlType != null) {
            if (xmlType.isSimpleType()) {
                SimpleType simpleType = (SimpleType)xmlType;
                SimpleType baseType = null;
                String derivationMethod = simpleType.getDerivationMethod();
                if (derivationMethod != null && "restriction".equals(derivationMethod)) {
                    baseType = (SimpleType)simpleType.getBaseType();
                }
                if (simpleType.hasFacet("enumeration")) {
                    enumeration = true;
                    if (resolver != null) {
                        classInfo = resolver.resolve(xmlType);
                    }
                    if (classInfo != null) {
                        xsType = classInfo.getSchemaType();
                    }
                } else if (simpleType instanceof ListType || baseType instanceof ListType) {
                    if (baseType != null) {
                        if (!baseType.isBuiltInType()) {
                            simpleTypeCollection = true;
                        }
                    } else if (!simpleType.isBuiltInType()) {
                        simpleTypeCollection = true;
                    }
                }
                if (xsType == null) {
                    xsType = component.getJavaType();
                }
            } else if (xmlType.isAnyType()) {
                if (classInfo != null) {
                    xsType = classInfo.getSchemaType();
                }
                if (xsType == null) {
                    xsType = new XSClass(SGTypes.Object);
                }
            } else if (xmlType.isComplexType() && xmlType.getName() != null && this._config.mappingSchemaType2Java()) {
                XMLBindingComponent temp = new XMLBindingComponent(this._config, this._groupNaming);
                temp.setBinding(component.getBinding());
                temp.setView((Annotated)xmlType);
                ClassInfo typeInfo = resolver.resolve(xmlType);
                if (typeInfo != null) {
                    xsType = typeInfo.getSchemaType();
                } else {
                    String className = temp.getQualifiedName();
                    if (className != null) {
                        JClass jClass = new JClass(className);
                        if (((ComplexType)xmlType).isAbstract()) {
                            jClass.getModifiers().setAbstract(true);
                        }
                        xsType = new XSClass(jClass);
                        className = null;
                    }
                }
            }
        } else {
            if (xsType == null) {
                xsType = component.getJavaType();
            }
            if (xsType == null) {
                switch (component.getAnnotated().getStructureType()) {
                    case 3: 
                    case 8: {
                        xsType = new XSClass(SGTypes.Object);
                        break;
                    }
                }
            }
        }
        if (xsType == null) {
            ComplexType complexType;
            String className = component.getQualifiedName();
            JClass jClass = new JClass(className);
            xsType = new XSClass(jClass);
            if (xmlType != null && xmlType.isComplexType() && (complexType = (ComplexType)xmlType).isAbstract()) {
                jClass.getModifiers().setAbstract(true);
            }
            className = null;
        }
        int maxOccurs = component.getUpperBound();
        int minOccurs = component.getLowerBound();
        if (simpleTypeCollection || (maxOccurs < 0 || maxOccurs > 1) && !memberName.endsWith("Choice")) {
            String vName = memberName + "List";
            CollectionInfo cInfo = this._infoFactory.createCollection(xsType, vName, memberName, component.getCollectionType(), useJava50);
            XSList xsList = cInfo.getXSList();
            if (!simpleTypeCollection) {
                xsList.setMaximumSize(maxOccurs);
                xsList.setMinimumSize(minOccurs);
            }
            fieldInfo = cInfo;
        } else {
            switch (xsType.getType()) {
                case 25: {
                    fieldInfo = this._infoFactory.createIdentity(memberName);
                    break;
                }
                case 45: {
                    String collectionName = component.getCollectionType();
                    fieldInfo = this._infoFactory.createCollection(((XSList)xsType).getContentType(), memberName, memberName, collectionName, useJava50);
                    break;
                }
                default: {
                    fieldInfo = this._infoFactory.createFieldInfo(xsType, memberName);
                }
            }
        }
        fieldInfo.setNodeName(xmlName);
        fieldInfo.setRequired(minOccurs > 0);
        switch (component.getAnnotated().getStructureType()) {
            case 8: {
                fieldInfo.setNodeType((short)1);
                break;
            }
            case 3: {
                fieldInfo.setNodeType((short)0);
                break;
            }
            case 10: 
            case 16: {
                fieldInfo.setNodeName("-error-if-this-is-used-");
                fieldInfo.setContainer(true);
                break;
            }
        }
        String nsURI = component.getTargetNamespace();
        if (nsURI != null && nsURI.length() > 0) {
            fieldInfo.setNamespaceURI(nsURI);
        }
        this.handleDefaultValue(component, classInfo, xsType, fieldInfo, enumeration);
        if (component.isNillable()) {
            fieldInfo.setNillable(true);
        }
        if ((comment = this.createComment(component.getAnnotated())) != null) {
            fieldInfo.setComment(comment);
        }
        if (component.getXMLFieldHandler() != null) {
            fieldInfo.setXMLFieldHandler(component.getXMLFieldHandler());
        }
        if (component.getValidator() != null) {
            fieldInfo.setValidator(component.getValidator());
        }
        if (component.getVisiblity() != null) {
            String visibility = component.getVisiblity();
            fieldInfo.setVisibility(visibility);
        }
        return fieldInfo;
    }

    private void handleDefaultValue(XMLBindingComponent component, ClassInfo classInfo, XSType xsType, FieldInfo fieldInfo, boolean enumeration) {
        String value = component.getValue();
        if (value == null) {
            return;
        }
        if ((value = this.adjustDefaultValue(xsType, value)).length() == 0) {
            value = "\"\"";
        }
        if (xsType.getJType().toString().equals("java.lang.String")) {
            char ch = value.charAt(0);
            if (ch != '\'' && ch != '\"') {
                value = '\"' + value + '\"';
            }
        } else if (enumeration) {
            JType jType = classInfo != null ? classInfo.getJClass() : xsType.getJType();
            value = jType.getName() + ".valueOf(\"" + value + "\")";
        } else if (xsType.getJType().isArray()) {
            JType componentType = ((JArrayType)xsType.getJType()).getComponentType();
            value = "new " + componentType.getName() + "[] { " + componentType.getWrapperName() + ".valueOf(\"" + value + "\")." + componentType.getName() + "Value() }";
        } else if (!xsType.getJType().isPrimitive()) {
            value = xsType.isDateTime() ? (xsType.getType() == 3 ? "new org.exolab.castor.types.DateTime(\"" + value + "\").toDate()" : "new " + xsType.getJType().getName() + "(\"" + value + "\")") : "new " + xsType.getJType().getName() + "(\"" + value + "\")";
        }
        if (component.isFixed()) {
            fieldInfo.setFixedValue(value);
        } else {
            fieldInfo.setDefaultValue(value);
        }
    }

    private String adjustDefaultValue(XSType xsType, String value) {
        switch (xsType.getType()) {
            case 14: {
                return value + 'f';
            }
            case 11: {
                Boolean bool = new Boolean(value);
                return bool.toString();
            }
        }
        return value;
    }

    private String createComment(Annotated annotated) {
        Enumeration enumeration = annotated.getAnnotations();
        if (enumeration.hasMoreElements()) {
            return this.createComment((Annotation)enumeration.nextElement());
        }
        switch (annotated.getStructureType()) {
            case 8: {
                ElementDecl elem = (ElementDecl)annotated;
                if (!elem.isReference()) break;
                return this.createComment((Annotated)elem.getReference());
            }
            case 3: {
                AttributeDecl att = (AttributeDecl)annotated;
                if (!att.isReference()) break;
                return this.createComment((Annotated)att.getReference());
            }
        }
        return null;
    }

    private String createComment(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        Enumeration enumeration = annotation.getDocumentation();
        if (enumeration.hasMoreElements()) {
            Documentation documentation = (Documentation)enumeration.nextElement();
            return this.normalize(documentation.getContent());
        }
        return null;
    }
}

