/*
 * Decompiled with CFR 0.152.
 */
package org.castor.anttask;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.util.XMLInstance2Schema;
import org.xml.sax.SAXException;

public final class XMLInstance2SchemaTask
extends MatchingTask {
    private static final String NO_XML_DOCUMENT_MSG = "At least one XML document instance must be provided.";
    private File _xmlInstanceFile;
    private File _xmlInstanceDir;
    private final Vector<FileSet> _xmlInstanceFileSets = new Vector();
    private String _xmlSchemaFileName;
    private boolean _defaultGroupingAsAll;

    public void setFile(File file) {
        this._xmlInstanceFile = file;
    }

    public void setDir(File dir) {
        this._xmlInstanceDir = dir;
    }

    public void addFileset(FileSet set) {
        this._xmlInstanceFileSets.add(set);
    }

    public void setXmlSchemaFileName(String ddlFileName) {
        this._xmlSchemaFileName = ddlFileName;
    }

    public void setDefaultGrouping(String defaultGroupingAsAll) {
        this._defaultGroupingAsAll = true;
    }

    private void config() {
    }

    private void processFile(String filePath, String outputFilePath) {
        this.log("Processing " + filePath);
        try {
            XMLInstance2Schema schemaGenerator = new XMLInstance2Schema();
            if (this._defaultGroupingAsAll) {
                schemaGenerator.setDefaultGroupingAsAll();
            }
            Schema schema = schemaGenerator.createSchema(filePath);
            String outputFileName = outputFilePath;
            if (outputFileName == null) {
                outputFileName = this.deriveOutputFilePath(filePath);
            }
            FileWriter dstWriter = new FileWriter(outputFileName);
            schemaGenerator.serializeSchema((Writer)dstWriter, schema);
        }
        catch (IOException e) {
            throw new BuildException("Problem writing to the given putput sink " + this._xmlInstanceFile.getAbsolutePath(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException("Problem streaming the generated XML schema instance to the given file.", (Throwable)e);
        }
    }

    private String deriveOutputFilePath(String outputFileName) {
        return outputFileName + ".xsd";
    }

    public void execute() {
        if (this._xmlInstanceFile == null && this._xmlInstanceDir == null && this._xmlInstanceFileSets.isEmpty()) {
            throw new BuildException(NO_XML_DOCUMENT_MSG);
        }
        this.config();
        if (this._xmlInstanceFile != null) {
            this.processFile(this._xmlInstanceFile.getAbsolutePath(), this._xmlSchemaFileName);
        }
        if (this._xmlInstanceDir != null && this._xmlInstanceDir.exists() && this._xmlInstanceDir.isDirectory()) {
            String[] files;
            this.log("Given XML schema file name will be ignored.");
            DirectoryScanner ds = this.getDirectoryScanner(this._xmlInstanceDir);
            for (String file : files = ds.getIncludedFiles()) {
                String filePath = this._xmlInstanceDir.getAbsolutePath() + File.separator + file;
                this.processFile(filePath, null);
            }
        }
        for (FileSet xmlInstanceFileSet : this._xmlInstanceFileSets) {
            String[] files;
            this.log("Given XML schema file name will be ignored.");
            FileSet fs = xmlInstanceFileSet;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File subdir = fs.getDir(this.getProject());
            for (String file : files = ds.getIncludedFiles()) {
                String filePath = subdir.getAbsolutePath() + File.separator + file;
                this.processFile(filePath, null);
            }
        }
    }
}

