/*
 * Decompiled with CFR 0.152.
 */
package org.castor.anttask;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.castor.xml.BackwardCompatibilityContext;
import org.castor.xml.InternalContext;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.factory.FieldInfoFactory;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaContextImpl;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class CastorCodeGenTask
extends MatchingTask {
    private static final String PROBLEM_SETTING_JDO_DESC = "Problem calling SourceGenerator.setJdoDescriptorCreation: ";
    private static final String DISABLE_DESCRIPTORS_MSG = "Disabling generation of Class descriptors";
    private static final String DISABLE_MARSHAL_MSG = "Disabling generation of Marshaling framework methods (marshal, unmarshal, validate).";
    private static final String CASTOR_TESTABLE_MSG = "The generated classes will implement org.exolab.castor.tests.CastorTestable";
    private static final String INVALID_LINESEP_MSG = "Invalid value for lineseparator, must be win, unix, or mac.";
    private static final String NO_SCHEMA_MSG = "At least one of the file, url or dir attributes, or a fileset element, must be set.";
    private InternalContext _internalContext;
    private File _schemaFile = null;
    private String _schemaURL = null;
    private File _schemaDir = null;
    private Vector _schemaFilesets = new Vector();
    private String _srcpackage;
    private String _todir;
    private String _bindingfile;
    private String _types;
    private String _lineseparator;
    private boolean _verbose;
    private boolean _warnings = true;
    private boolean _nodesc;
    private boolean _nomarshal;
    private boolean _generateMapping;
    private boolean _testable;
    private boolean _generateImportedSchemas;
    private boolean _sax1;
    private boolean _caseInsensitive;
    private String _properties;
    private String _nameConflictStrategy = "warnViaConsoleDialog";
    private String _automaticConflictStrategy = "xpath";
    private boolean _generateJdoDescriptors;
    private String _jclassPrinterType = "standard";
    private SourceGenerator _sgen;

    public CastorCodeGenTask() {
        this._internalContext = new BackwardCompatibilityContext();
    }

    public void setFile(File file) {
        this._schemaFile = file;
    }

    public void setSchemaURL(String schemaURL) {
        this._schemaURL = schemaURL;
    }

    public void setDir(File dir) {
        this._schemaDir = dir;
    }

    public void addFileset(FileSet set) {
        this._schemaFilesets.addElement(set);
    }

    public void setPackage(String pack) {
        this._srcpackage = pack;
    }

    public void setTodir(String dest) {
        this._todir = dest;
    }

    public void setBindingfile(String bindingfile) {
        this._bindingfile = bindingfile;
    }

    public void setLineseparator(String ls) {
        this._lineseparator = ls;
    }

    public void setTypes(String tf) {
        this._types = tf.equals("j2") ? "arraylist" : tf;
    }

    public void setVerbose(boolean b) {
        this._verbose = b;
    }

    public void setNameConflictStrategy(String nameConflictStrategy) {
        this._nameConflictStrategy = nameConflictStrategy;
    }

    public void setAutomaticConflictStrategy(String automaticConflictStrategy) {
        this._automaticConflictStrategy = automaticConflictStrategy;
    }

    public void setWarnings(boolean b) {
        this._warnings = b;
    }

    public void setNodesc(boolean b) {
        this._nodesc = b;
    }

    public void setNomarshal(boolean b) {
        this._nomarshal = b;
    }

    public void setTestable(boolean b) {
        this._testable = b;
    }

    public void setGenerateImportedSchemas(boolean generateImportedSchemas) {
        this._generateImportedSchemas = generateImportedSchemas;
    }

    public void setGenerateJdoDescriptors(boolean generateJdoDescriptors) {
        this._generateJdoDescriptors = generateJdoDescriptors;
    }

    public void setSAX1(boolean sax1) {
        this._sax1 = sax1;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public void setProperties(String properties) {
        this._properties = properties;
    }

    public void setJClassPrinterType(String jclassPrinterType) {
        this._jclassPrinterType = jclassPrinterType;
    }

    private void config() {
        if (this._types != null) {
            FieldInfoFactory factory;
            try {
                factory = new FieldInfoFactory(this._types);
                this._sgen = new CastorSourceGeneratorWrapper(factory);
            }
            catch (Exception e) {
                try {
                    factory = (FieldInfoFactory)Class.forName(this._types).newInstance();
                    this._sgen = new CastorSourceGeneratorWrapper(factory);
                }
                catch (Exception e2) {
                    throw new BuildException("Invalid types \"" + this._types + "\": " + e.getMessage());
                }
            }
        } else {
            this._sgen = new CastorSourceGeneratorWrapper();
        }
        String lineSep = System.getProperty("line.separator");
        if (this._lineseparator != null) {
            if ("win".equals(this._lineseparator)) {
                this.log("Using Windows style line separation.");
                lineSep = "\r\n";
            } else if ("unix".equals(this._lineseparator)) {
                this.log("Using UNIX style line separation.");
                lineSep = "\n";
            } else if ("mac".equals(this._lineseparator)) {
                this.log("Using Macintosh style line separation.");
                lineSep = "\r";
            } else {
                throw new BuildException(INVALID_LINESEP_MSG);
            }
        }
        this._sgen.setLineSeparator(lineSep);
        this._sgen.setDestDir(this._todir);
        if (this._bindingfile != null) {
            this._sgen.setBinding(this._bindingfile);
        }
        this._sgen.setVerbose(this._verbose);
        this._sgen.setSuppressNonFatalWarnings(!this._warnings);
        this._sgen.setDescriptorCreation(!this._nodesc);
        if (this._nodesc) {
            this.log(DISABLE_DESCRIPTORS_MSG);
        }
        this._sgen.setCreateMarshalMethods(!this._nomarshal);
        if (this._nomarshal) {
            this.log(DISABLE_MARSHAL_MSG);
        }
        this._sgen.setGenerateImportedSchemas(this._generateImportedSchemas);
        this._sgen.setSAX1(this._sax1);
        this._sgen.setCaseInsensitive(this._caseInsensitive);
        this._sgen.setNameConflictStrategy(this._nameConflictStrategy);
        this._sgen.setClassNameConflictResolver(this._automaticConflictStrategy);
        this._sgen.setJClassPrinterType(this._jclassPrinterType);
        this._sgen.setGenerateMappingFile(this._generateMapping);
        if (this._generateJdoDescriptors) {
            this.callSetterMethodUsingReflection(this._sgen, "setJdoDescriptorCreation", Boolean.TYPE, new Boolean(this._generateJdoDescriptors));
        }
        this._sgen.setTestable(this._testable);
        if (this._testable) {
            this.log(CASTOR_TESTABLE_MSG);
        }
        if (this._properties != null) {
            String filePath = new File(this._properties).getAbsolutePath();
            Properties customProperties = new Properties();
            try {
                customProperties.load(new FileInputStream(filePath));
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Properties file \"" + filePath + "\" not found");
            }
            catch (IOException e) {
                throw new BuildException("Can't read properties file \"" + filePath + "\": " + e);
            }
            this._sgen.setDefaultProperties(customProperties);
        }
    }

    private void processFile(String filePath) {
        this.log("Processing " + filePath);
        try {
            this._sgen.generateSource(filePath, this._srcpackage);
        }
        catch (FileNotFoundException e) {
            String message = "XML Schema file \"" + this._schemaFile.getAbsolutePath() + "\" not found.";
            this.log(message);
            throw new BuildException(message);
        }
        catch (Exception iox) {
            throw new BuildException((Throwable)iox);
        }
    }

    private void processURL(String schemaURL) {
        this.log("Processing " + schemaURL);
        try {
            InputSource inputSource = new InputSource(schemaURL);
            this._sgen.generateSource(inputSource, this._srcpackage);
        }
        catch (FileNotFoundException e) {
            String message = "XML Schema file \"" + this._schemaURL + "\" not found.";
            this.log(message);
            throw new BuildException(message);
        }
        catch (Exception iox) {
            throw new BuildException((Throwable)iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this._schemaFile == null && this._schemaDir == null && this._schemaFilesets.size() == 0 && this._schemaURL == null) {
            throw new BuildException(NO_SCHEMA_MSG);
        }
        try {
            this.config();
            if (this._schemaFile != null) {
                this.processFile(this._schemaFile.getAbsolutePath());
            }
            if (this._schemaDir != null && this._schemaDir.exists() && this._schemaDir.isDirectory()) {
                DirectoryScanner ds = this.getDirectoryScanner(this._schemaDir);
                String[] files = ds.getIncludedFiles();
                for (int i = 0; i < files.length; ++i) {
                    String filePath = this._schemaDir.getAbsolutePath() + File.separator + files[i];
                    this.processFile(filePath);
                }
            }
            for (int i = 0; i < this._schemaFilesets.size(); ++i) {
                FileSet fs = (FileSet)this._schemaFilesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File subdir = fs.getDir(this.getProject());
                String[] files = ds.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    String filePath = subdir.getAbsolutePath() + File.separator + files[j];
                    this.processFile(filePath);
                }
            }
            if (this._schemaURL != null) {
                this.processURL(this._schemaURL);
            }
        }
        finally {
            this._sgen = null;
        }
    }

    private void callSetterMethodUsingReflection(SourceGenerator sgen, String methodName, Class parameterType, Object parameterValue) throws BuildException {
        try {
            Method method = sgen.getClass().getMethod(methodName, parameterType);
            method.invoke((Object)sgen, parameterValue);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            throw new BuildException(PROBLEM_SETTING_JDO_DESC, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException(PROBLEM_SETTING_JDO_DESC, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BuildException(PROBLEM_SETTING_JDO_DESC, (Throwable)e);
        }
    }

    private final class CastorSourceGeneratorWrapper
    extends SourceGenerator {
        public CastorSourceGeneratorWrapper() {
        }

        public CastorSourceGeneratorWrapper(FieldInfoFactory fieldInfoFactory) {
            super(fieldInfoFactory);
        }

        public CastorSourceGeneratorWrapper(FieldInfoFactory fieldInfoFactory, ExtendedBinding extendedBinding) {
            super(fieldInfoFactory, extendedBinding);
        }

        public void generateSource(InputSource source, String packageName) {
            Parser parser = null;
            try {
                parser = CastorCodeGenTask.this._internalContext.getParser();
            }
            catch (RuntimeException e) {
                throw new BuildException("Unable to create SAX parser.", (Throwable)e);
            }
            if (parser == null) {
                throw new BuildException("Unable to create SAX parser.");
            }
            SchemaContextImpl schemaContext = new SchemaContextImpl();
            SchemaUnmarshaller schemaUnmarshaller = null;
            try {
                schemaUnmarshaller = new SchemaUnmarshaller((SchemaContext)schemaContext);
            }
            catch (XMLException e) {
                throw new BuildException("Unable to create schema unmarshaller.", (Throwable)e);
            }
            Sax2ComponentReader handler = new Sax2ComponentReader((ComponentReader)schemaUnmarshaller);
            parser.setDocumentHandler((DocumentHandler)handler);
            parser.setErrorHandler((ErrorHandler)handler);
            try {
                parser.parse(source);
            }
            catch (IOException e) {
                String msg = "Can't read input file " + source.getSystemId() + ".\n" + e;
                throw new BuildException(msg, (Throwable)e);
            }
            catch (SAXException e) {
                String msg = "Can't parse input file " + source.getSystemId() + ".\n" + e;
                throw new BuildException(msg, (Throwable)e);
            }
            Schema schema = schemaUnmarshaller.getSchema();
            try {
                this.generateSource(schema, packageName);
            }
            catch (Exception iox) {
                throw new BuildException((Throwable)iox);
            }
        }
    }
}

