/*
 * Decompiled with CFR 0.152.
 */
package org.castor.anttask;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.castor.ddlgen.Generator;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.GeneratorFactory;
import org.castor.mapping.MappingUnmarshaller;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;

public final class CastorDDLGenTask
extends MatchingTask {
    private static final String NO_MAPPING_MSG = "A mapping file must be provided for DDL generation.";
    private File _mappingFile = null;
    private File _mappingDir = null;
    private Vector _mappingFilesets = new Vector();
    private String _ddlFileName;
    private String _databaseEngine;
    private String _globalProperties;
    private String _databaseEngineProperties;
    private OutputStream _outputStream;

    public void setFile(File file) {
        this._mappingFile = file;
    }

    public void setDir(File dir) {
        this._mappingDir = dir;
    }

    public void addFileset(FileSet set) {
        this._mappingFilesets.addElement(set);
    }

    public void setDatabaseEngine(String databaseEngine) {
        this._databaseEngine = databaseEngine;
    }

    public void setDatabaseEngineProperties(String databaseEngineProperties) {
        this._databaseEngineProperties = databaseEngineProperties;
    }

    public void setDdlFileName(String ddlFileName) {
        this._ddlFileName = ddlFileName;
    }

    public void setGlobalProperties(String globalProperties) {
        this._globalProperties = globalProperties;
    }

    private void config() {
        if (this._databaseEngine == null) {
            throw new BuildException("No database engine specified.");
        }
        try {
            this._outputStream = new FileOutputStream(this._ddlFileName);
        }
        catch (IOException e) {
            throw new BuildException("Problem finding the Castor JDO mapping file " + this._mappingFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private void processFile(String filePath) {
        this.log("Processing " + filePath);
        try {
            Generator ddlgen = GeneratorFactory.createDDLGenerator((String)this._databaseEngine, (String)this._globalProperties, (String)this._databaseEngineProperties);
            Mapping mapping = new Mapping();
            mapping.loadMapping(filePath);
            new MappingUnmarshaller().loadMappingOnly(mapping);
            ddlgen.setMapping(mapping);
            ddlgen.generateDDL(this._outputStream);
        }
        catch (IOException e) {
            throw new BuildException("Problem finding the Castor JDO mapping file " + this._mappingFile.getAbsolutePath(), (Throwable)e);
        }
        catch (MappingException e) {
            throw new BuildException("Problem loading the Castor JDO mapping file " + this._mappingFile.getAbsolutePath(), (Throwable)e);
        }
        catch (GeneratorException e) {
            throw new BuildException("Problem generating DDL script for " + this._mappingFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public void execute() {
        if (this._mappingFile == null && this._mappingDir == null && this._mappingFilesets.size() == 0) {
            throw new BuildException(NO_MAPPING_MSG);
        }
        this.config();
        if (this._mappingFile != null) {
            this.processFile(this._mappingFile.getAbsolutePath());
        }
        if (this._mappingDir != null && this._mappingDir.exists() && this._mappingDir.isDirectory()) {
            DirectoryScanner ds = this.getDirectoryScanner(this._mappingDir);
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String filePath = this._mappingDir.getAbsolutePath() + File.separator + files[i];
                this.processFile(filePath);
            }
        }
        for (int i = 0; i < this._mappingFilesets.size(); ++i) {
            FileSet fs = (FileSet)this._mappingFilesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File subdir = fs.getDir(this.getProject());
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                String filePath = subdir.getAbsolutePath() + File.separator + files[j];
                this.processFile(filePath);
            }
        }
    }
}

