/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.maven2.AbstractCargoMojo;
import org.codehaus.cargo.maven2.configuration.Deployable;
import org.codehaus.cargo.tools.daemon.DaemonClient;

public abstract class AbstractDaemonMojo
extends AbstractCargoMojo {
    protected DaemonClient daemonClient = null;
    protected String daemonHandleId = null;
    protected boolean daemonAutostartContainer = false;
    protected List<String> daemonClasspaths = null;
    protected final List<org.codehaus.cargo.container.deployable.Deployable> daemonDeployables = new ArrayList<org.codehaus.cargo.container.deployable.Deployable>();
    protected InstalledLocalContainer daemonContainer;

    @Override
    public void doExecute() throws MojoExecutionException {
        this.getCargoProject().setDaemonRun(true);
        Container container = this.createContainer();
        if (!(container instanceof InstalledLocalContainer)) {
            throw new MojoExecutionException("Container must be of INSTALLED type.");
        }
        String daemonURL = this.getDaemon().getProperty("cargo.daemon.url");
        String daemonUsername = this.getDaemon().getProperty("cargo.daemon.username");
        String daemonPassword = this.getDaemon().getProperty("cargo.daemon.password");
        String daemonHandleId = this.getDaemon().getProperty("cargo.daemon.handleid");
        if (daemonURL == null || daemonURL.isEmpty()) {
            throw new MojoExecutionException("Missing daemon URL property.");
        }
        if (daemonHandleId == null || daemonHandleId.isEmpty()) {
            throw new MojoExecutionException("Missing daemon handle id property.");
        }
        this.daemonAutostartContainer = Boolean.parseBoolean(this.getDaemon().getProperty("cargo.daemon.autostart"));
        this.daemonClasspaths = this.getDaemon().getClasspaths();
        try {
            this.daemonClient = new DaemonClient(new URL(daemonURL), daemonUsername, daemonPassword);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Malformed daemon URL: " + e);
        }
        this.daemonHandleId = daemonHandleId;
        this.daemonContainer = (InstalledLocalContainer)container;
        this.createDeployables(container);
        this.performAction();
    }

    protected abstract void performAction() throws MojoExecutionException;

    private void createDeployables(Container container) throws MojoExecutionException {
        if (this.getDeployablesElement() != null) {
            for (Deployable deployableElement : this.getDeployablesElement()) {
                org.codehaus.cargo.container.deployable.Deployable deployable = deployableElement.createDeployable(container.getId(), this.getCargoProject());
                this.daemonDeployables.add(deployable);
            }
        }
        if (this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() && (this.getDeployablesElement() == null || this.getDeployablesElement().length == 0)) {
            this.daemonDeployables.add(this.createAutoDeployDeployable(container));
        }
    }
}

