/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.maven2.AbstractCommonMojo;
import org.codehaus.cargo.maven2.configuration.ArtifactInstaller;
import org.codehaus.cargo.maven2.configuration.Configuration;
import org.codehaus.cargo.maven2.configuration.Container;
import org.codehaus.cargo.maven2.configuration.Deployable;
import org.codehaus.cargo.maven2.configuration.Deployer;
import org.codehaus.cargo.maven2.jetty.JettyArtifactResolver;
import org.codehaus.cargo.maven2.log.MavenLogger;
import org.codehaus.cargo.maven2.util.CargoProject;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractCargoMojo
extends AbstractCommonMojo {
    public static final String CONTEXT_KEY_CONTAINER = AbstractCargoMojo.class.getName() + "-Container";
    private FileHandler fileHandler = new DefaultFileHandler();
    private Configuration configuration;
    private Container container;
    private Map<String, String> daemonProperties;
    private Deployer deployer;
    private Deployable[] deployables;
    private ArtifactMetadataSource metadataSource;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> repositories;
    private boolean skip;
    private ArtifactFactory artifactFactory;
    private CargoProject cargoProject;
    private Settings settings;
    private String pluginVersion;

    public static String calculateContainerArtifactId(String containerId) {
        return "cargo-core-container-" + containerId.replaceAll("\\d+x", "");
    }

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    protected Deployer getDeployerElement() {
        return this.deployer;
    }

    protected void setDeployerElement(Deployer deployerElement) {
        this.deployer = deployerElement;
    }

    protected String getDaemonProperty(String name) {
        return this.daemonProperties.get(name);
    }

    protected Deployable[] getDeployablesElement() {
        ArrayList<Deployable> deployablesList;
        Deployable[] deployables = this.deployables;
        if (this.getConfigurationElement() != null && this.getConfigurationElement().getDeployables() != null && this.getConfigurationElement().getDeployables().length != 0) {
            deployablesList = new ArrayList<Deployable>();
            if (deployables != null) {
                deployablesList.addAll(Arrays.asList(deployables));
            }
            deployablesList.addAll(Arrays.asList(this.getConfigurationElement().getDeployables()));
            deployables = new Deployable[deployablesList.size()];
            deployables = deployablesList.toArray(deployables);
            this.getLog().warn((CharSequence)"The <deployables> element under the inner <configuration> element is deprecated. Please use <deployables> under the plugin <configuration> instead.");
        }
        if (this.getDeployerElement() != null && this.getDeployerElement().getDeployables() != null && this.getDeployerElement().getDeployables().length != 0) {
            deployablesList = new ArrayList();
            if (deployables != null) {
                deployablesList.addAll(Arrays.asList(deployables));
            }
            deployablesList.addAll(Arrays.asList(this.getDeployerElement().getDeployables()));
            deployables = new Deployable[deployablesList.size()];
            deployables = deployablesList.toArray(deployables);
            this.getLog().warn((CharSequence)"The <deployables> element under the <deployer> element is deprecated. Please use <deployables> under the plugin <configuration> instead.");
        }
        return deployables;
    }

    protected void setDeployablesElement(Deployable[] deployablesElement) {
        this.deployables = deployablesElement;
    }

    protected Configuration getConfigurationElement() {
        return this.configuration;
    }

    protected void setConfigurationElement(Configuration configurationElement) {
        this.configuration = configurationElement;
    }

    protected Container getContainerElement() {
        return this.container;
    }

    protected void setContainerElement(Container containerElement) {
        this.container = containerElement;
    }

    protected void setCargoProject(CargoProject cargoProject) {
        this.cargoProject = cargoProject;
    }

    protected CargoProject getCargoProject() {
        return this.cargoProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cargo execution");
            return;
        }
        if (this.cargoProject == null) {
            this.cargoProject = new CargoProject(this.getProject(), this.getLog());
        }
        HashMap<String, String> previousProperties = new HashMap<String, String>(10);
        previousProperties.put("http.proxyHost", System.clearProperty("http.proxyHost"));
        previousProperties.put("http.proxyPort", System.clearProperty("http.proxyPort"));
        previousProperties.put("https.proxyHost", System.clearProperty("https.proxyHost"));
        previousProperties.put("https.proxyPort", System.clearProperty("https.proxyPort"));
        previousProperties.put("http.proxyUser", System.clearProperty("http.proxyUser"));
        previousProperties.put("http.proxyPassword", System.clearProperty("http.proxyPassword"));
        previousProperties.put("https.proxyUser", System.clearProperty("https.proxyUser"));
        previousProperties.put("https.proxyPassword", System.clearProperty("https.proxyPassword"));
        previousProperties.put("http.nonProxyHosts", System.clearProperty("http.nonProxyHosts"));
        previousProperties.put("https.nonProxyHosts", System.clearProperty("https.nonProxyHosts"));
        try {
            Proxy proxy = null;
            if (this.settings != null) {
                proxy = this.settings.getActiveProxy();
            }
            if (proxy != null) {
                if (proxy.getHost() != null) {
                    System.setProperty("http.proxyHost", proxy.getHost());
                    System.setProperty("https.proxyHost", proxy.getHost());
                    System.setProperty("http.proxyPort", Integer.toString(proxy.getPort()));
                    System.setProperty("https.proxyPort", Integer.toString(proxy.getPort()));
                }
                if (proxy.getUsername() != null && proxy.getPassword() != null) {
                    System.setProperty("http.proxyUser", proxy.getUsername());
                    System.setProperty("https.proxyUser", proxy.getUsername());
                    System.setProperty("http.proxyPassword", proxy.getPassword());
                    System.setProperty("https.proxyPassword", proxy.getPassword());
                }
                if (proxy.getNonProxyHosts() != null) {
                    System.setProperty("http.nonProxyHosts", proxy.getNonProxyHosts());
                    System.setProperty("https.nonProxyHosts", proxy.getNonProxyHosts());
                }
            }
            this.doExecute();
        }
        finally {
            for (Map.Entry previousProperty : previousProperties.entrySet()) {
                if (previousProperty.getValue() != null) {
                    System.setProperty((String)previousProperty.getKey(), (String)previousProperty.getValue());
                    continue;
                }
                System.clearProperty((String)previousProperty.getKey());
            }
        }
    }

    protected abstract void doExecute() throws MojoExecutionException;

    protected org.codehaus.cargo.container.configuration.Configuration createConfiguration() throws MojoExecutionException {
        if (this.getConfigurationElement() == null) {
            Configuration configurationElement = new Configuration();
            if (this.getContainerElement().getType().isLocal()) {
                File home = new File(this.getCargoProject().getBuildDirectory(), "cargo/configurations/" + this.getContainerElement().getContainerId());
                configurationElement.setType(ConfigurationType.STANDALONE);
                configurationElement.setHome(home.getAbsolutePath());
            } else {
                configurationElement.setType(ConfigurationType.RUNTIME);
            }
            this.setConfigurationElement(configurationElement);
        }
        org.codehaus.cargo.container.configuration.Configuration configuration = this.getConfigurationElement().createConfiguration(this.getContainerElement().getContainerId(), this.getContainerElement().getType(), this.getDeployablesElement(), this.getCargoProject());
        for (Map.Entry property : configuration.getProperties().entrySet()) {
            String propertyKey = (String)property.getKey();
            if (!"cargo.server.settings".equals(propertyKey)) continue;
            String serverId = (String)property.getValue();
            this.getLog().debug((CharSequence)("Found cargo.server.settings: key is " + propertyKey + ", value is " + serverId));
            for (Object serverObject : this.settings.getServers()) {
                Xpp3Dom[] globalConfigurationOptions;
                Server server = (Server)serverObject;
                if (!serverId.equals(server.getId())) continue;
                this.getLog().debug((CharSequence)("The Maven settings.xml file contains a reference for the server with cargo.server.settings " + serverId + ", starting property injection"));
                for (Xpp3Dom option : globalConfigurationOptions = ((Xpp3Dom)server.getConfiguration()).getChildren()) {
                    configuration.setProperty(option.getName(), option.getValue());
                    if (option.getName().contains("password")) {
                        this.getLog().debug((CharSequence)("\tInjected password property: " + option.getName() + "= ***"));
                        continue;
                    }
                    this.getLog().debug((CharSequence)("\tInjected property: " + option.getName() + " = " + option.getValue()));
                }
            }
        }
        return configuration;
    }

    protected org.codehaus.cargo.container.Container createContainer() throws MojoExecutionException {
        org.codehaus.cargo.container.Container container = null;
        Map context = this.getPluginContext();
        String containerKey = CONTEXT_KEY_CONTAINER;
        if (this.getContainerElement() != null) {
            containerKey = containerKey + "." + this.getContainerElement().getType() + "." + this.getContainerElement().getHome();
        }
        if (this.getConfigurationElement() != null) {
            containerKey = containerKey + "." + this.getConfigurationElement().getHome();
        }
        if (context != null) {
            container = (org.codehaus.cargo.container.Container)context.get(containerKey);
        }
        if (container == null) {
            container = this.createNewContainer();
        } else if (this.getConfigurationElement() != null) {
            this.createDefaultContainerElementIfNecessary();
            org.codehaus.cargo.container.configuration.Configuration configuration = this.createConfiguration();
            configuration.setLogger(container.getLogger());
            if (container instanceof RemoteContainer) {
                if (!(configuration instanceof RuntimeConfiguration)) {
                    throw new MojoExecutionException("Expected a " + RuntimeConfiguration.class.getName() + " but got a " + configuration.getClass().getName());
                }
                ((RemoteContainer)container).setConfiguration((RuntimeConfiguration)configuration);
            } else if (container instanceof LocalContainer) {
                if (!(configuration instanceof LocalConfiguration)) {
                    throw new MojoExecutionException("Expected a " + LocalConfiguration.class.getName() + " but got a " + configuration.getClass().getName());
                }
                ((LocalContainer)container).setConfiguration((LocalConfiguration)configuration);
            } else {
                throw new MojoExecutionException("Unknown container type " + container.getClass().getName());
            }
        }
        if (context != null) {
            context.put(containerKey, container);
        }
        return container;
    }

    protected org.codehaus.cargo.container.Container createNewContainer() throws MojoExecutionException {
        this.createDefaultContainerElementIfNecessary();
        if (this.getContainerElement().getType() == ContainerType.EMBEDDED) {
            this.loadEmbeddedContainerDependencies();
        }
        Logger logger = this.createLogger();
        org.codehaus.cargo.container.configuration.Configuration configuration = this.createConfiguration();
        configuration.setLogger(logger);
        org.codehaus.cargo.container.Container container = this.getContainerElement().createContainer(configuration, logger, this.getCargoProject(), this.artifactFactory, this.artifactResolver, this.localRepository, this.repositories, this.settings);
        return container;
    }

    protected void createDefaultContainerElementIfNecessary() throws MojoExecutionException {
        String containerId;
        if (this.getContainerElement() == null) {
            if (this.getCargoProject().getPackaging() != null && !this.getCargoProject().getPackaging().equalsIgnoreCase("war")) {
                throw new MojoExecutionException("For all packaging other than war you need to configure the container you wish to use.");
            }
            Container containerElement = new Container();
            this.setContainerElement(containerElement);
        }
        if (this.getContainerElement().getContainerId() == null) {
            if (this.getContainerElement().getArtifactInstaller() != null) {
                throw new MojoExecutionException("You have specified no containerId but have specified an artifactInstaller. Please check the plugin configuration.");
            }
            if (this.getContainerElement().getZipUrlInstaller() != null) {
                throw new MojoExecutionException("You have specified no containerId but have specified a zipUrlInstaller. Please check the plugin configuration.");
            }
            this.getContainerElement().setContainerId("jetty7x");
            this.getContainerElement().setType(ContainerType.INSTALLED);
            ArtifactInstaller artifactInstaller = new ArtifactInstaller();
            artifactInstaller.setGroupId("org.eclipse.jetty");
            artifactInstaller.setArtifactId("jetty-distribution");
            artifactInstaller.setVersion("7.6.7.v20120910");
            this.getContainerElement().setArtifactInstaller(artifactInstaller);
            this.getLog().info((CharSequence)("No container defined, using a default [" + this.getContainerElement().getContainerId() + ", " + this.getContainerElement().getType().getType() + "] container"));
        }
        if ((containerId = this.getContainerElement().getContainerId()) != null && this.artifactFactory != null) {
            String containerArtifactId = AbstractCargoMojo.calculateContainerArtifactId(containerId);
            Artifact containerArtifact = this.artifactFactory.createArtifact("org.codehaus.cargo", containerArtifactId, this.pluginVersion, null, "jar");
            try {
                this.artifactResolver.resolve(containerArtifact, this.repositories, this.localRepository);
                URL containerArtifactUrl = containerArtifact.getFile().toURI().toURL();
                ArrayList<URL> urlClassLoaderURLs = new ArrayList<URL>();
                for (ClassLoader classLoader = ResourceUtils.getResourceLoader(); classLoader != null; classLoader = classLoader.getParent()) {
                    if (!(classLoader instanceof URLClassLoader)) continue;
                    urlClassLoaderURLs.addAll(Arrays.asList(((URLClassLoader)classLoader).getURLs()));
                }
                if (urlClassLoaderURLs.contains(containerArtifactUrl)) {
                    this.createLogger().debug("Container artifact " + containerArtifact + " for container " + containerId + " already in class loader", ((Object)((Object)this)).getClass().getName());
                } else {
                    Artifact dummy = this.artifactFactory.createArtifact("dummy", "dummy", "0.1", null, "pom");
                    Set artifacts = new HashSet<Artifact>(1);
                    artifacts.add(containerArtifact);
                    artifacts = this.artifactResolver.resolveTransitively(artifacts, dummy, this.localRepository, this.repositories, this.metadataSource, (ArtifactFilter)new ScopeArtifactFilter("compile")).getArtifacts();
                    ArrayList<URL> containerArtifactURLs = new ArrayList<URL>();
                    for (Artifact artifact : artifacts) {
                        URL artifactURL = artifact.getFile().toURI().toURL();
                        if (urlClassLoaderURLs.contains(artifactURL)) continue;
                        containerArtifactURLs.add(artifactURL);
                    }
                    URL[] containerArtifactArray = new URL[containerArtifactURLs.size()];
                    containerArtifactArray = containerArtifactURLs.toArray(containerArtifactArray);
                    URLClassLoader containerArtifactClassLoader = new URLClassLoader(containerArtifactArray, ((Object)((Object)this)).getClass().getClassLoader());
                    ResourceUtils.setResourceLoader((ClassLoader)containerArtifactClassLoader);
                    this.createLogger().debug("Resolved artifact and dependencies: " + containerArtifactURLs, ((Object)((Object)this)).getClass().getName());
                    this.createLogger().info("Resolved container artifact " + containerArtifact + " for container " + containerId, ((Object)((Object)this)).getClass().getName());
                }
            }
            catch (Exception e) {
                this.createLogger().debug("Cannot resolve container artifact " + containerArtifact + " for container " + containerId + ": " + e.toString(), ((Object)((Object)this)).getClass().getName());
            }
        }
    }

    protected void loadEmbeddedContainerDependencies() throws MojoExecutionException {
        if (this.getContainerElement().getContainerId().startsWith("jetty")) {
            JettyArtifactResolver resolver = new JettyArtifactResolver(this.artifactResolver, this.localRepository, this.repositories, this.artifactFactory);
            ClassLoader classLoader = resolver.resolveDependencies(this.getContainerElement().getContainerId(), this.getCargoProject().getEmbeddedClassLoader());
            this.getCargoProject().setEmbeddedClassLoader(classLoader);
        }
    }

    protected org.codehaus.cargo.container.deployable.Deployable createAutoDeployDeployable(org.codehaus.cargo.container.Container container) throws MojoExecutionException {
        Deployable deployableElement = new Deployable();
        return deployableElement.createDeployable(container.getId(), this.getCargoProject());
    }

    protected boolean containsAutoDeployable(Deployable[] deployableElements) {
        boolean found = false;
        for (Deployable deployableElement : deployableElements) {
            if (!deployableElement.getGroupId().equals(this.getCargoProject().getGroupId()) || !deployableElement.getArtifactId().equals(this.getCargoProject().getArtifactId())) continue;
            found = true;
            break;
        }
        return found;
    }

    protected Logger createLogger() {
        MavenLogger logger;
        if (this.getContainerElement() != null && this.getContainerElement().getLog() != null) {
            this.getContainerElement().getLog().getParentFile().mkdirs();
            logger = new FileLogger(this.getContainerElement().getLog(), true);
        } else {
            logger = new MavenLogger(this.getLog());
        }
        if (this.getContainerElement() != null && this.getContainerElement().getLogLevel() != null) {
            logger.setLevel(this.getContainerElement().getLogLevel());
        } else if (this.getLog().isDebugEnabled()) {
            logger.setLevel(LogLevel.DEBUG);
        } else if (this.getLog().isInfoEnabled()) {
            logger.setLevel(LogLevel.INFO);
        } else {
            logger.setLevel(LogLevel.WARN);
        }
        return logger;
    }
}

