/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone.event;

import java.security.Principal;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.springframework.security.core.Authentication;

public class IdentityProviderModifiedEvent
extends AbstractUaaEvent {
    private static final long serialVersionUID = -4559543713244231262L;
    private AuditEventType eventType;
    protected static final String dataFormat = "id=%s; type=%s; origin=%s; zone=%s";

    public IdentityProviderModifiedEvent(IdentityProvider identityProvider, Authentication authentication, AuditEventType type) {
        super(identityProvider, authentication);
        this.eventType = type;
    }

    @Override
    public AuditEvent getAuditEvent() {
        IdentityProvider provider = (IdentityProvider)this.source;
        return this.createAuditRecord(this.getSource().toString(), this.eventType, this.getOrigin((Principal)this.getAuthentication()), String.format(dataFormat, provider.getId(), provider.getType(), provider.getOriginKey(), provider.getIdentityZoneId()));
    }

    public static IdentityProviderModifiedEvent identityProviderCreated(IdentityProvider identityProvider) {
        return new IdentityProviderModifiedEvent(identityProvider, IdentityProviderModifiedEvent.getContextAuthentication(), AuditEventType.IdentityProviderCreatedEvent);
    }

    public static IdentityProviderModifiedEvent identityProviderModified(IdentityProvider identityProvider) {
        return new IdentityProviderModifiedEvent(identityProvider, IdentityProviderModifiedEvent.getContextAuthentication(), AuditEventType.IdentityProviderModifiedEvent);
    }
}

