/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.cloudfoundry.identity.uaa.client.ClientAdminEndpointsValidator;
import org.cloudfoundry.identity.uaa.client.ClientDetailsValidator;
import org.cloudfoundry.identity.uaa.client.InvalidClientDetailsException;
import org.cloudfoundry.identity.uaa.zone.ClientSecretValidator;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;

public class ZoneEndpointsClientDetailsValidator
implements ClientDetailsValidator {
    private final String requiredScope;
    private ClientSecretValidator clientSecretValidator;

    public ZoneEndpointsClientDetailsValidator(String requiredScope) {
        this.requiredScope = requiredScope;
    }

    @Override
    public ClientDetails validate(ClientDetails clientDetails, ClientDetailsValidator.Mode mode) throws InvalidClientDetailsException {
        if (mode == ClientDetailsValidator.Mode.CREATE) {
            if (!Collections.singleton("openid").equals(clientDetails.getScope())) {
                throw new InvalidClientDetailsException("only openid scope is allowed");
            }
            if (!Collections.singleton("uaa.resource").equals(AuthorityUtils.authorityListToSet((Collection)clientDetails.getAuthorities()))) {
                throw new InvalidClientDetailsException("only uaa.resource authority is allowed");
            }
            if (StringUtils.isBlank((String)clientDetails.getClientId())) {
                throw new InvalidClientDetailsException("client_id cannot be blank");
            }
            ClientAdminEndpointsValidator.checkRequestedGrantTypes(clientDetails.getAuthorizedGrantTypes());
            if (clientDetails.getAuthorizedGrantTypes().contains("client_credentials") || clientDetails.getAuthorizedGrantTypes().contains("authorization_code") || clientDetails.getAuthorizedGrantTypes().contains("user_token") || clientDetails.getAuthorizedGrantTypes().contains("refresh_token") || clientDetails.getAuthorizedGrantTypes().contains("urn:ietf:params:oauth:grant-type:saml2-bearer") || clientDetails.getAuthorizedGrantTypes().contains("urn:ietf:params:oauth:grant-type:jwt-bearer") || clientDetails.getAuthorizedGrantTypes().contains("password")) {
                if (StringUtils.isBlank((String)clientDetails.getClientSecret())) {
                    throw new InvalidClientDetailsException("client_secret cannot be blank");
                }
                this.clientSecretValidator.validate(clientDetails.getClientSecret());
            }
            if (!Collections.singletonList("uaa").equals(clientDetails.getAdditionalInformation().get("allowedproviders"))) {
                throw new InvalidClientDetailsException("only the internal IdP ('uaa') is allowed");
            }
            BaseClientDetails validatedClientDetails = new BaseClientDetails(clientDetails);
            validatedClientDetails.setAdditionalInformation(clientDetails.getAdditionalInformation());
            validatedClientDetails.setResourceIds(Collections.singleton("none"));
            validatedClientDetails.addAdditionalInformation("createdwith", (Object)this.requiredScope);
            return validatedClientDetails;
        }
        if (mode == ClientDetailsValidator.Mode.MODIFY) {
            throw new IllegalStateException("This validator cannot be used for modification requests");
        }
        if (mode == ClientDetailsValidator.Mode.DELETE) {
            if (!this.requiredScope.equals(clientDetails.getAdditionalInformation().get("createdwith"))) {
                throw new InvalidClientDetailsException("client must have been createdwith scope " + this.requiredScope);
            }
            return clientDetails;
        }
        throw new IllegalStateException("This validator must be called with a mode");
    }

    @Override
    public ClientSecretValidator getClientSecretValidator() {
        return this.clientSecretValidator;
    }

    public void setClientSecretValidator(ClientSecretValidator clientSecretValidator) {
        this.clientSecretValidator = clientSecretValidator;
    }
}

