/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;

public class InMemoryClientServicesExtentions
extends ClientServicesExtension {
    public ConcurrentMap<String, Map<String, BaseClientDetails>> services = new ConcurrentHashMap<String, Map<String, BaseClientDetails>>();

    public void setClientDetailsStore(String zoneId, Map<String, BaseClientDetails> store) {
        this.services.put(zoneId, store);
    }

    public Map<String, BaseClientDetails> getInMemoryService(String zoneId) {
        HashMap clientDetailsStore = new HashMap();
        this.services.putIfAbsent(zoneId, clientDetailsStore);
        return (Map)this.services.get(zoneId);
    }

    public void clear() {
        this.services.clear();
    }

    @Override
    public void addClientSecret(String clientId, String newSecret, String zoneId) throws NoSuchClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteClientSecret(String clientId, String zoneId) throws NoSuchClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addClientDetails(ClientDetails clientDetails, String zoneId) throws ClientAlreadyExistsException {
        this.getInMemoryService(zoneId).put(clientDetails.getClientId(), (BaseClientDetails)clientDetails);
    }

    @Override
    public void updateClientDetails(ClientDetails clientDetails, String zoneId) throws NoSuchClientException {
        this.addClientDetails(clientDetails, zoneId);
    }

    @Override
    public void updateClientSecret(String clientId, String secret, String zoneId) throws NoSuchClientException {
        Optional.ofNullable((BaseClientDetails)this.loadClientByClientId(clientId, zoneId)).ifPresent(client -> client.setClientSecret(secret));
    }

    @Override
    public void removeClientDetails(String clientId, String zoneId) throws NoSuchClientException {
        this.getInMemoryService(zoneId).remove(clientId);
    }

    @Override
    public List<ClientDetails> listClientDetails(String zoneId) {
        return this.getInMemoryService(zoneId).entrySet().stream().map(e -> (BaseClientDetails)e.getValue()).collect(Collectors.toList());
    }

    @Override
    public ClientDetails loadClientByClientId(String clientId, String zoneId) throws ClientRegistrationException {
        BaseClientDetails result = this.getInMemoryService(zoneId).get(clientId);
        if (result == null) {
            throw new NoSuchClientException("No client with requested id: " + clientId);
        }
        return result;
    }
}

