/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.security.GeneralSecurityException;
import java.util.Map;
import org.cloudfoundry.identity.uaa.saml.SamlKey;
import org.cloudfoundry.identity.uaa.util.KeyWithCert;
import org.cloudfoundry.identity.uaa.zone.BannerValidator;
import org.cloudfoundry.identity.uaa.zone.ConsentValidator;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfigurationValidator;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneValidator;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneConfigurationException;
import org.cloudfoundry.identity.uaa.zone.MfaConfigValidator;
import org.cloudfoundry.identity.uaa.zone.SamlConfig;
import org.cloudfoundry.identity.uaa.zone.TokenPolicy;
import org.springframework.util.StringUtils;

public class GeneralIdentityZoneConfigurationValidator
implements IdentityZoneConfigurationValidator {
    private MfaConfigValidator mfaConfigValidator;

    @Override
    public IdentityZoneConfiguration validate(IdentityZone zone, IdentityZoneValidator.Mode mode) throws InvalidIdentityZoneConfigurationException {
        IdentityZoneConfiguration config = zone.getConfig();
        if (mode == IdentityZoneValidator.Mode.CREATE || mode == IdentityZoneValidator.Mode.MODIFY) {
            String activeKeyId;
            String currentKeyId = null;
            try {
                SamlConfig samlConfig = config.getSamlConfig();
                if (samlConfig != null && samlConfig.getKeys().size() > 0) {
                    activeKeyId = samlConfig.getActiveKeyId();
                    if (activeKeyId == null || samlConfig.getKeys().get(activeKeyId) == null) {
                        throw new InvalidIdentityZoneConfigurationException(String.format("Invalid SAML active key ID: '%s'. Couldn't find any matching keys.", activeKeyId));
                    }
                    for (Map.Entry entry : samlConfig.getKeys().entrySet()) {
                        currentKeyId = (String)entry.getKey();
                        String samlSpCert = ((SamlKey)entry.getValue()).getCertificate();
                        String samlSpKey = ((SamlKey)entry.getValue()).getKey();
                        String samlSpkeyPassphrase = ((SamlKey)entry.getValue()).getPassphrase();
                        if (samlSpKey != null && samlSpCert != null) {
                            new KeyWithCert(samlSpKey, samlSpkeyPassphrase, samlSpCert);
                        }
                        this.failIfPartialCertKeyInfo(samlSpCert, samlSpKey, samlSpkeyPassphrase);
                    }
                }
            }
            catch (GeneralSecurityException ex) {
                throw new InvalidIdentityZoneConfigurationException(String.format("There is a security problem with the SAML SP Key configuration for key '%s'.", currentKeyId), ex);
            }
            TokenPolicy tokenPolicy = config.getTokenPolicy();
            if (tokenPolicy != null && StringUtils.hasText((String)(activeKeyId = tokenPolicy.getActiveKeyId()))) {
                Map jwtKeys = tokenPolicy.getKeys();
                if (jwtKeys == null || jwtKeys.isEmpty()) {
                    throw new InvalidIdentityZoneConfigurationException("Identity zone cannot specify an active key ID with no keys configured for the zone.", null);
                }
                if (!jwtKeys.containsKey(activeKeyId)) {
                    throw new InvalidIdentityZoneConfigurationException("The specified active key ID is not present in the configured keys: " + activeKeyId, null);
                }
            }
            if (!StringUtils.isEmpty((Object)config.getIssuer()) && (tokenPolicy == null || StringUtils.isEmpty((Object)tokenPolicy.getActiveKeyId()))) {
                throw new InvalidIdentityZoneConfigurationException("You cannot set issuer value unless you have set your own signing key for this identity zone.");
            }
        }
        if (config.getBranding() != null && config.getBranding().getConsent() != null) {
            ConsentValidator.validate(config.getBranding().getConsent());
        }
        if (config.getBranding() != null && config.getBranding().getBanner() != null) {
            BannerValidator.validate(config.getBranding().getBanner());
        }
        if (config.getMfaConfig() != null) {
            this.mfaConfigValidator.validate(config.getMfaConfig(), zone.getId());
        }
        return config;
    }

    private void failIfPartialCertKeyInfo(String samlSpCert, String samlSpKey, String samlSpkeyPassphrase) throws InvalidIdentityZoneConfigurationException {
        if (samlSpCert == null && samlSpKey == null && samlSpkeyPassphrase == null || samlSpCert != null && samlSpKey != null && samlSpkeyPassphrase != null) {
            return;
        }
        throw new InvalidIdentityZoneConfigurationException("Identity zone cannot be udpated with partial Saml CertKey config.", null);
    }

    public GeneralIdentityZoneConfigurationValidator setMfaConfigValidator(MfaConfigValidator mfaConfigValidator) {
        this.mfaConfigValidator = mfaConfigValidator;
        return this;
    }
}

