/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.Consent;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneConfigurationException;
import org.springframework.util.StringUtils;

public class ConsentValidator {
    public static void validate(Consent consent) throws InvalidIdentityZoneConfigurationException {
        if (consent != null) {
            if (StringUtils.isEmpty((Object)consent.getText())) {
                throw new InvalidIdentityZoneConfigurationException("Consent text must be set if configuring consent");
            }
            if (StringUtils.hasText((String)consent.getLink()) && !UaaUrlUtils.isUrl(consent.getLink())) {
                throw new InvalidIdentityZoneConfigurationException("Invalid consent link: " + consent.getLink() + ". Must be a properly formatted URI beginning with http:// or https://", null);
            }
        }
    }
}

