/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.servlet.View;

public class ConvertingExceptionView
implements View {
    private static final Log logger = LogFactory.getLog(ConvertingExceptionView.class);
    private ResponseEntity<? extends ExceptionReport> responseEntity;
    private final HttpMessageConverter<?>[] messageConverters;

    public ConvertingExceptionView(ResponseEntity<? extends ExceptionReport> responseEntity, HttpMessageConverter<?>[] messageConverters) {
        this.responseEntity = responseEntity;
        this.messageConverters = messageConverters;
    }

    public String getContentType() {
        return "*/*";
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpInputMessage inputMessage = this.createHttpInputMessage(request);
            HttpOutputMessage outputMessage = this.createHttpOutputMessage(response);
            this.handleHttpEntityResponse(this.responseEntity, inputMessage, outputMessage);
        }
        catch (Exception invocationEx) {
            logger.error((Object)"Invoking request method resulted in exception", (Throwable)invocationEx);
        }
    }

    protected HttpInputMessage createHttpInputMessage(HttpServletRequest servletRequest) throws Exception {
        return new ServletServerHttpRequest(servletRequest);
    }

    protected HttpOutputMessage createHttpOutputMessage(HttpServletResponse servletResponse) throws Exception {
        return new ServletServerHttpResponse(servletResponse);
    }

    private void handleHttpEntityResponse(ResponseEntity<? extends ExceptionReport> responseEntity, HttpInputMessage inputMessage, HttpOutputMessage outputMessage) throws Exception {
        if (outputMessage instanceof ServerHttpResponse) {
            ((ServerHttpResponse)outputMessage).setStatusCode(responseEntity.getStatusCode());
        }
        if (responseEntity.getBody() != null) {
            this.writeWithMessageConverters(responseEntity.getBody(), inputMessage, outputMessage);
        } else {
            outputMessage.getBody();
        }
    }

    private void writeWithMessageConverters(Object returnValue, HttpInputMessage inputMessage, HttpOutputMessage outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
        List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
        if (acceptedMediaTypes.isEmpty()) {
            acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
        }
        MediaType.sortByQualityValue((List)acceptedMediaTypes);
        Class<?> returnValueType = returnValue.getClass();
        ArrayList allSupportedMediaTypes = new ArrayList();
        if (this.messageConverters != null) {
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
                    if (!messageConverter.canWrite(returnValueType, acceptedMediaType)) continue;
                    messageConverter.write(returnValue, acceptedMediaType, outputMessage);
                    if (logger.isDebugEnabled()) {
                        MediaType contentType = outputMessage.getHeaders().getContentType();
                        if (contentType == null) {
                            contentType = acceptedMediaType;
                        }
                        logger.debug((Object)("Written [" + returnValue + "] as \"" + contentType + "\" using [" + messageConverter + "]"));
                    }
                    return;
                }
            }
            for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
                allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
            }
        }
        throw new HttpMediaTypeNotAcceptableException(allSupportedMediaTypes);
    }
}

