/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.util.EncodingUtils;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;

public class CachingPasswordEncoder
implements PasswordEncoder {
    private final MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
    private final byte[] secret = Utf8.encode((CharSequence)new RandomValueStringGenerator().generate());
    private final byte[] salt = KeyGenerators.secureRandom().generateKey();
    private final int iterations;
    private int maxKeys = 1000;
    private int maxEncodedPasswords = 5;
    private boolean enabled = true;
    private int expiryInSeconds = 300;
    private volatile Cache<CharSequence, Set<String>> cache = null;
    private PasswordEncoder passwordEncoder;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public CachingPasswordEncoder() throws NoSuchAlgorithmException {
        this.iterations = 25;
        this.buildCache();
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public String encode(CharSequence rawPassword) throws AuthenticationException {
        return this.getPasswordEncoder().encode(rawPassword);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) throws AuthenticationException {
        if (this.isEnabled()) {
            String cacheKey = this.cacheEncode(rawPassword);
            return this.internalMatches(cacheKey, rawPassword, encodedPassword);
        }
        return this.getPasswordEncoder().matches(rawPassword, encodedPassword);
    }

    protected Set<String> getOrCreateHashList(String cacheKey) {
        Set result = (Set)this.cache.getIfPresent((Object)cacheKey);
        if (result == null) {
            if (this.cache.size() >= (long)this.getMaxKeys()) {
                this.cache.invalidateAll();
            }
            this.cache.put((Object)cacheKey, Collections.synchronizedSet(new LinkedHashSet()));
        }
        return (Set)this.cache.getIfPresent((Object)cacheKey);
    }

    private boolean internalMatches(String cacheKey, CharSequence rawPassword, String encodedPassword) {
        Set<String> cacheValue = (Set<String>)this.cache.getIfPresent((Object)cacheKey);
        boolean result = false;
        ArrayList searchList = cacheValue != null ? new ArrayList(cacheValue) : Collections.emptyList();
        for (String encoded : searchList) {
            if (!this.hashesEquals(encoded, encodedPassword)) continue;
            return true;
        }
        if (!result && this.getPasswordEncoder().matches(rawPassword, encodedPassword)) {
            result = true;
            cacheValue = this.getOrCreateHashList(cacheKey);
            if (cacheValue != null) {
                if (cacheValue.size() >= this.getMaxEncodedPasswords()) {
                    cacheValue.clear();
                }
                cacheValue.add(encodedPassword);
            }
        }
        return result;
    }

    protected String cacheEncode(CharSequence rawPassword) {
        byte[] digest = this.digest(rawPassword);
        return new String(Hex.encode((byte[])digest));
    }

    private byte[] digest(CharSequence rawPassword) {
        byte[] digest = this.digest(EncodingUtils.concatenate((byte[][])new byte[][]{this.salt, this.secret, Utf8.encode((CharSequence)rawPassword)}));
        return EncodingUtils.concatenate((byte[][])new byte[][]{this.salt, digest});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] digest(byte[] value) {
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            for (int i = 0; i < this.iterations; ++i) {
                value = this.messageDigest.digest(value);
            }
            return value;
        }
    }

    private boolean hashesEquals(String a, String b) {
        char[] cab;
        char[] caa = a.toCharArray();
        if (caa.length != (cab = b.toCharArray()).length) {
            return false;
        }
        int ret = 0;
        for (int i = 0; i < caa.length; ++i) {
            ret = (byte)(ret | caa[i] ^ cab[i]);
        }
        return ret == 0;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(int maxKeys) {
        this.maxKeys = maxKeys;
        this.buildCache();
    }

    public int getMaxEncodedPasswords() {
        return this.maxEncodedPasswords;
    }

    public void setMaxEncodedPasswords(int maxEncodedPasswords) {
        this.maxEncodedPasswords = maxEncodedPasswords;
        this.buildCache();
    }

    public long getNumberOfKeys() {
        return this.cache.size();
    }

    public ConcurrentMap<CharSequence, Set<String>> asMap() {
        return this.cache.asMap();
    }

    public int getExpiryInSeconds() {
        return this.expiryInSeconds;
    }

    public void setExpiryInSeconds(int expiryInSeconds) {
        this.expiryInSeconds = expiryInSeconds;
        this.buildCache();
    }

    protected void buildCache() {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)this.expiryInSeconds, TimeUnit.SECONDS).build();
    }
}

