/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class UserInfo {
    @JsonProperty(value="roles")
    private List<String> roles;
    @JsonProperty(value="user_attributes")
    private LinkedMultiValueMap<String, String> userAttributes;

    @JsonIgnore
    public UserInfo setRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    @JsonIgnore
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonIgnore
    public UserInfo setUserAttributes(MultiValueMap<String, String> userAttributes) {
        this.userAttributes = new LinkedMultiValueMap(userAttributes);
        return this;
    }

    @JsonIgnore
    public MultiValueMap<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        if (!this.compareRoles(this.getRoles(), ((UserInfo)o).getRoles())) {
            return false;
        }
        return this.getUserAttributes() != null ? this.getUserAttributes().equals(userInfo.getUserAttributes()) : userInfo.getUserAttributes() == null;
    }

    protected boolean compareRoles(List<String> l1, List<String> l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        return l1.containsAll(l2) && l2.containsAll(l1);
    }

    public int hashCode() {
        int result = this.getRoles() != null ? this.getRoles().hashCode() : 0;
        result = 31 * result + (this.getUserAttributes() != null ? this.getUserAttributes().hashCode() : 0);
        return result;
    }
}

