/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.oauth.UaaOauth2Authentication;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.expression.OAuth2SecurityExpressionMethods;
import org.springframework.util.StringUtils;

public class ContextSensitiveOAuth2SecurityExpressionMethods
extends OAuth2SecurityExpressionMethods {
    private final IdentityZone identityZone;
    private final Authentication authentication;

    private String replaceContext(String role) {
        IdentityZone zone = IdentityZoneHolder.get();
        return role.replace("{zone.id}", zone.getId());
    }

    private String[] replaceContext(String[] roles) {
        if (roles == null || roles.length == 0) {
            return roles;
        }
        String[] adjusted = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            adjusted[i] = this.replaceContext(roles[i]);
        }
        return adjusted;
    }

    public ContextSensitiveOAuth2SecurityExpressionMethods(Authentication authentication) {
        this(authentication, IdentityZone.getUaa());
    }

    public ContextSensitiveOAuth2SecurityExpressionMethods(Authentication authentication, IdentityZone authenticationZone) {
        super(authentication);
        this.authentication = authentication;
        this.identityZone = authenticationZone;
    }

    public boolean clientHasRole(String role) {
        return super.clientHasRole(this.replaceContext(role));
    }

    public boolean clientHasAnyRole(String ... roles) {
        return super.clientHasAnyRole(this.replaceContext(roles));
    }

    private boolean isUaaAdmin() {
        return super.hasAnyScope(new String[]{"uaa.admin"});
    }

    public boolean hasAnyScope(String ... scopes) {
        return this.isUaaAdmin() || super.hasAnyScope(this.replaceContext(scopes));
    }

    public boolean hasAnyScopeMatching(String ... scopesRegex) {
        return this.isUaaAdmin() || super.hasAnyScopeMatching(this.replaceContext(scopesRegex));
    }

    public boolean hasScopeInAuthZone(String scope) {
        boolean hasScope = this.hasScope(scope);
        String authZoneId = this.getAuthenticationZoneId();
        boolean bl = hasScope = hasScope && StringUtils.hasText((String)authZoneId);
        if (hasScope) {
            hasScope = this.identityZone != null && this.identityZone.getId().equals(authZoneId);
        }
        return hasScope;
    }

    public String getAuthenticationZoneId() {
        if (this.authentication.getPrincipal() instanceof UaaPrincipal) {
            return ((UaaPrincipal)this.authentication.getPrincipal()).getZoneId();
        }
        if (this.authentication instanceof UaaOauth2Authentication) {
            return ((UaaOauth2Authentication)this.authentication).getZoneId();
        }
        if (this.authentication.getDetails() instanceof OAuth2AuthenticationDetails) {
            String tokenValue = ((OAuth2AuthenticationDetails)this.authentication.getDetails()).getTokenValue();
            return this.getZoneIdFromToken(tokenValue);
        }
        return null;
    }

    private String getZoneIdFromToken(String token) {
        Map claims;
        Jwt tokenJwt;
        try {
            tokenJwt = JwtHelper.decode(token);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Cannot decode token", t);
        }
        try {
            claims = (Map)JsonUtils.readValue((String)tokenJwt.getClaims(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new IllegalStateException("Cannot read token claims", e);
        }
        return (String)claims.get("zid");
    }
}

