/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.cloudfoundry.identity.uaa.provider.saml.idp.TestRequestWrapper;
import org.cloudfoundry.identity.uaa.provider.saml.idp.TestResponseWrapper;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.context.SAMLMessageContext;

public class IdpSamlContextProviderImpl
extends SAMLContextProviderImpl {
    public SAMLMessageContext getLocalEntity(HttpServletRequest request, HttpServletResponse response) throws MetadataProviderException {
        SAMLMessageContext context = super.getLocalEntity((HttpServletRequest)new TestRequestWrapper(request), (HttpServletResponse)new TestResponseWrapper(response));
        context.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        return context;
    }

    protected void populateLocalEntityId(SAMLMessageContext context, String requestURI) throws MetadataProviderException {
        int filterIndex;
        HTTPInTransport inTransport = (HTTPInTransport)context.getInboundMessageTransport();
        String entityId = (String)inTransport.getAttribute("localEntityId");
        if (entityId != null) {
            log.debug("Using protocol specified IdP {}", (Object)entityId);
            context.setLocalEntityId(entityId);
            context.setLocalEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            return;
        }
        if (requestURI == null) {
            requestURI = "";
        }
        if ((filterIndex = requestURI.indexOf("/alias/")) != -1) {
            QName localEntityRole;
            String localAlias = requestURI.substring(filterIndex + 7);
            int entityTypePosition = localAlias.lastIndexOf(47);
            if (entityTypePosition != -1) {
                String entityRole = localAlias.substring(entityTypePosition + 1);
                localEntityRole = "sp".equalsIgnoreCase(entityRole) ? SPSSODescriptor.DEFAULT_ELEMENT_NAME : IDPSSODescriptor.DEFAULT_ELEMENT_NAME;
                localAlias = localAlias.substring(0, entityTypePosition);
            } else {
                localEntityRole = IDPSSODescriptor.DEFAULT_ELEMENT_NAME;
            }
            entityId = this.metadata.getEntityIdForAlias(localAlias);
            if (entityId == null) {
                throw new MetadataProviderException("No local entity found for alias " + localAlias + ", verify your configuration.");
            }
            log.debug("Using IdP {} specified in request with alias {}", (Object)entityId, (Object)localAlias);
            context.setLocalEntityId(entityId);
            context.setLocalEntityRole(localEntityRole);
        } else {
            context.setLocalEntityId(this.metadata.getDefaultIDP());
            context.setLocalEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        }
    }
}

