/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpExtendedMetadata;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpWebSSOProfileOptions;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpWebSsoProfile;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.signature.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.Assert;

public class IdpSamlAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdpSamlAuthenticationSuccessHandler.class);
    private IdpWebSsoProfile idpWebSsoProfile;
    private MetadataManager metadataManager;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        SAMLMessageContext context = ((UaaAuthentication)authentication).getSamlMessageContext();
        IdpExtendedMetadata extendedMetadata = null;
        try {
            extendedMetadata = (IdpExtendedMetadata)this.metadataManager.getExtendedMetadata(context.getLocalEntityId());
        }
        catch (MetadataProviderException e) {
            throw new ServletException("Failed to obtain local SAML IdP extended metadata.", (Throwable)e);
        }
        try {
            this.populatePeerContext(context);
        }
        catch (MetadataProviderException e) {
            throw new ServletException("Failed to populate peer SAML SP context.", (Throwable)e);
        }
        try {
            IdpWebSSOProfileOptions options = new IdpWebSSOProfileOptions();
            options.setAssertionsSigned(extendedMetadata.isAssertionsSigned());
            options.setAssertionTimeToLiveSeconds(extendedMetadata.getAssertionTimeToLiveSeconds());
            this.idpWebSsoProfile.sendResponse(authentication, context, options);
        }
        catch (SAMLException e) {
            LOGGER.debug("Incoming SAML message is invalid.", (Throwable)e);
            throw new AuthenticationServiceException("Incoming SAML message is invalid.", (Throwable)e);
        }
        catch (MetadataProviderException e) {
            LOGGER.debug("Error determining metadata contracts.", (Throwable)e);
            throw new AuthenticationServiceException("Error determining metadata contracts.", (Throwable)e);
        }
        catch (MessageEncodingException e) {
            LOGGER.debug("Error decoding incoming SAML message.", (Throwable)e);
            throw new AuthenticationServiceException("Error encoding outgoing SAML message.", (Throwable)e);
        }
        catch (MarshallingException | SecurityException | SignatureException e) {
            LOGGER.debug("Error signing SAML assertion.", e);
            throw new AuthenticationServiceException("Error signing SAML assertion.", e);
        }
    }

    protected void populatePeerContext(SAMLMessageContext samlContext) throws MetadataProviderException {
        String peerEntityId = samlContext.getPeerEntityId();
        QName peerEntityRole = samlContext.getPeerEntityRole();
        if (peerEntityId == null) {
            throw new MetadataProviderException("Peer entity ID wasn't specified, but is requested");
        }
        EntityDescriptor entityDescriptor = this.metadataManager.getEntityDescriptor(peerEntityId);
        RoleDescriptor roleDescriptor = this.metadataManager.getRole(peerEntityId, peerEntityRole, "urn:oasis:names:tc:SAML:2.0:protocol");
        ExtendedMetadata extendedMetadata = this.metadataManager.getExtendedMetadata(peerEntityId);
        if (entityDescriptor == null || roleDescriptor == null) {
            throw new MetadataProviderException("Metadata for entity " + peerEntityId + " and role " + peerEntityRole + " wasn't found");
        }
        samlContext.setPeerEntityMetadata(entityDescriptor);
        samlContext.setPeerEntityRoleMetadata(roleDescriptor);
        samlContext.setPeerExtendedMetadata(extendedMetadata);
    }

    @Autowired
    public void setIdpWebSsoProfile(IdpWebSsoProfile idpWebSsoProfile) {
        Assert.notNull((Object)idpWebSsoProfile, (String)"SAML Web SSO profile can't be null.");
        this.idpWebSsoProfile = idpWebSsoProfile;
    }

    @Autowired
    public void setMetadataManager(MetadataManager metadataManager) {
        Assert.notNull((Object)metadataManager, (String)"SAML metadata manager can't be null.");
        this.metadataManager = metadataManager;
    }
}

